/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.metadata;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.metadata.ResultsMetadataConstants;

public class MetadataProvider {
    protected Map<?, Object>[] metadata;

    public MetadataProvider(Map<?, Object>[] metadata) {
        this.metadata = metadata;
    }

    public Object getValue(int columnIndex, Integer metadataPropertyKey) {
        if (columnIndex < 0 || columnIndex >= this.metadata.length) assert (columnIndex < 0 || columnIndex >= this.metadata.length);
        Map<?, Object> column = this.metadata[columnIndex];
        return column.get(metadataPropertyKey);
    }

    public int getColumnCount() {
        return this.metadata.length;
    }

    public String getStringValue(int columnIndex, Integer metadataPropertyKey) {
        return (String)this.getValue(columnIndex, metadataPropertyKey);
    }

    public int getIntValue(int columnIndex, Integer metadataPropertyKey) {
        return (Integer)this.getValue(columnIndex, metadataPropertyKey);
    }

    public boolean getBooleanValue(int columnIndex, Integer metadataPropertyKey) {
        return (Boolean)this.getValue(columnIndex, metadataPropertyKey);
    }

    public static Map<Integer, Object> getColumnMetadata(String catalogName, String tableName, String columnName, String dataType, Integer nullable, Connection driverConnection) {
        return MetadataProvider.getColumnMetadata(catalogName, tableName, columnName, dataType, nullable, ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, driverConnection);
    }

    public static Map<Integer, Object> getColumnMetadata(String catalogName, String tableName, String columnName, String dataType, Integer nullable, Integer searchable, Boolean writable, Boolean signed, Boolean caseSensitive, Connection driverConnection) {
        HashMap<Integer, Object> metadataMap = new HashMap<Integer, Object>();
        JcrType type = JcrType.typeInfo(dataType);
        if (type == null) {
            throw new RuntimeException("Program error: jcr type " + dataType + " not found");
        }
        metadataMap.put(ResultsMetadataConstants.CATALOG, catalogName);
        metadataMap.put(ResultsMetadataConstants.TABLE, tableName);
        metadataMap.put(ResultsMetadataConstants.COLUMN, columnName);
        metadataMap.put(ResultsMetadataConstants.DATA_TYPE, dataType);
        metadataMap.put(ResultsMetadataConstants.PRECISION, type.getDefaultPrecision());
        metadataMap.put(ResultsMetadataConstants.RADIX, new Integer(10));
        metadataMap.put(ResultsMetadataConstants.SCALE, new Integer(0));
        metadataMap.put(ResultsMetadataConstants.AUTO_INCREMENTING, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.CASE_SENSITIVE, caseSensitive);
        metadataMap.put(ResultsMetadataConstants.NULLABLE, nullable);
        metadataMap.put(ResultsMetadataConstants.SEARCHABLE, searchable);
        metadataMap.put(ResultsMetadataConstants.SIGNED, signed);
        metadataMap.put(ResultsMetadataConstants.WRITABLE, writable);
        metadataMap.put(ResultsMetadataConstants.CURRENCY, Boolean.FALSE);
        metadataMap.put(ResultsMetadataConstants.DISPLAY_SIZE, type.getNominalDisplaySize());
        return metadataMap;
    }
}

