/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.NotThreadSafe;

@NotThreadSafe
public class MultiIterator<E>
implements Iterator<E> {
    private final Iterator<Iterator<E>> iterators;
    private Iterator<E> current;

    public MultiIterator(Iterable<Iterator<E>> iterators) {
        this.iterators = iterators.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.nextIterator()) {
            return this.current.hasNext();
        }
        return false;
    }

    @Override
    public E next() {
        if (this.nextIterator()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    protected boolean nextIterator() {
        while (this.current == null || !this.current.hasNext()) {
            if (!this.iterators.hasNext()) {
                return false;
            }
            this.current = this.iterators.next();
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

