/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimestampWithTimezone {
    public static DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss a");
    private static ThreadLocal<Calendar> CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    public static Calendar getCalendar() {
        return CALENDAR.get();
    }

    public static void resetCalendar(TimeZone tz) {
        TimeZone.setDefault(tz);
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(tz);
        CALENDAR.set(cal);
    }

    public static Timestamp createTimestamp(Calendar initial, Calendar target) {
        if (target == null) {
            target = TimestampWithTimezone.getCalendar();
        }
        long time = target.getTimeInMillis();
        Calendar new_target = TimestampWithTimezone.adjustCalendarForTimeStamp(initial, target);
        Timestamp tsInTz = TimestampWithTimezone.createTimestamp(new_target);
        target.setTimeInMillis(time);
        return tsInTz;
    }

    public static Time createTime(Calendar initial, Calendar target) {
        if (target == null) {
            target = TimestampWithTimezone.getCalendar();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendarForTime(initial, target);
        target.set(14, 0);
        Time result = TimestampWithTimezone.createTime(target);
        target.setTimeInMillis(time);
        return result;
    }

    public static Date createDate(Calendar initial, Calendar target) {
        if (target == null) {
            return TimestampWithTimezone.createDate(initial);
        }
        long time = target.getTimeInMillis();
        target = TimestampWithTimezone.adjustCalendarForDate(initial, target);
        Date result = TimestampWithTimezone.normalizeDate(target, true);
        target.setTimeInMillis(time);
        return result;
    }

    public static Time createTime(Calendar target) {
        return new Time(target.getTimeInMillis());
    }

    public static Date createDate(Calendar target) {
        return new Date(target.getTime().getTime());
    }

    public static Timestamp createTimestamp(Calendar target) {
        return new Timestamp(target.getTime().getTime());
    }

    private static Date normalizeDate(Calendar target, boolean isDate) {
        if (isDate) {
            target.set(11, 0);
            target.set(12, 0);
            target.set(13, 0);
            target.set(14, 0);
        }
        return TimestampWithTimezone.createDate(target);
    }

    private static void adjustCalendarForTime(Calendar initial, Calendar target) {
        assert (initial != null);
        if (initial.getTimeZone().hasSameRules(target.getTimeZone())) {
            target.setTime(initial.getTime());
            return;
        }
        target.clear();
        for (int i = 0; i <= 14; ++i) {
            target.set(i, initial.get(i));
        }
    }

    private static Calendar adjustCalendarForDate(Calendar initial, Calendar target) {
        assert (initial != null);
        if (initial.getTimeZone().hasSameRules(target.getTimeZone())) {
            target.setTime(initial.getTime());
            return target;
        }
        GregorianCalendar ntarget = new GregorianCalendar(target.getTimeZone());
        ntarget.setTimeInMillis(initial.getTimeInMillis());
        return ntarget;
    }

    private static Calendar adjustCalendarForTimeStamp(Calendar initial, Calendar target) {
        assert (initial != null);
        if (initial.getTimeZone().hasSameRules(target.getTimeZone())) {
            target.setTime(initial.getTime());
            return target;
        }
        TimeZone targetTimeZone = target.getTimeZone();
        GregorianCalendar ret = new GregorianCalendar(targetTimeZone);
        ret.setTimeInMillis(initial.getTimeInMillis() + (long)targetTimeZone.getOffset(initial.getTimeInMillis()) - (long)initial.getTimeZone().getOffset(initial.getTimeInMillis()));
        ret.getTime();
        return ret;
    }
}

