/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class JcrBlob
implements Blob {
    private final Value value;
    private final long length;

    protected JcrBlob(Value value, long length) {
        this.value = value;
        this.length = length;
        assert (this.value != null);
    }

    @Override
    public void free() throws SQLException {
        try {
            Binary binary = this.value.getBinary();
            binary.dispose();
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            return this.value.getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        SQLException error = null;
        try {
            byte[] data = new byte[length];
            int numRead = 0;
            Binary binary = this.value.getBinary();
            try {
                numRead = binary.read(data, pos);
            }
            finally {
                binary.dispose();
            }
            if (numRead < length) {
                byte[] shortData = new byte[numRead];
                System.arraycopy(data, 0, shortData, 0, numRead);
                data = shortData;
            }
            return data;
        }
        catch (IOException e) {
            error = new SQLException(e.getLocalizedMessage(), e);
            throw error;
        }
        catch (RepositoryException e) {
            error = new SQLException(e.getLocalizedMessage(), e);
            throw error;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

