/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.logging;

import org.modeshape.common.CommonI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.logging.jdk.JdkLoggerFactory;
import org.modeshape.common.logging.log4j.Log4jLoggerFactory;
import org.modeshape.common.logging.slf4j.SLF4JLoggerFactory;

public abstract class LogFactory {
    public static final String CUSTOM_LOG_FACTORY_CLASSNAME = "org.modeshape.common.logging.CustomLoggerFactory";
    private static LogFactory LOGFACTORY;

    private static boolean isSLF4JAvailable() {
        try {
            Class.forName("org.slf4j.Logger");
            Class.forName("org.slf4j.LoggerFactory");
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isLog4jAvailable() {
        try {
            Class.forName("org.apache.log4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isCustomLoggerAvailable() {
        try {
            Class.forName(CUSTOM_LOG_FACTORY_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static LogFactory getLogFactory() {
        return LOGFACTORY;
    }

    Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    protected abstract Logger getLogger(String var1);

    static {
        Throwable customLoggingError = null;
        boolean customLogging = false;
        boolean slf4jLogging = false;
        boolean log4jLogging = false;
        if (LogFactory.isCustomLoggerAvailable()) {
            try {
                Class<?> customClass = Class.forName(CUSTOM_LOG_FACTORY_CLASSNAME);
                LOGFACTORY = (LogFactory)customClass.newInstance();
                customLogging = true;
            }
            catch (Throwable throwable) {
                customLoggingError = throwable;
            }
        }
        if (LOGFACTORY == null) {
            if (LogFactory.isSLF4JAvailable()) {
                LOGFACTORY = new SLF4JLoggerFactory();
                slf4jLogging = true;
            } else if (LogFactory.isLog4jAvailable()) {
                LOGFACTORY = new Log4jLoggerFactory();
                log4jLogging = true;
            } else {
                LOGFACTORY = new JdkLoggerFactory();
            }
        }
        Logger logger = LOGFACTORY.getLogger(LogFactory.class.getName());
        if (customLogging) {
            logger.info(CommonI18n.customLoggingAvailable, CUSTOM_LOG_FACTORY_CLASSNAME);
        } else if (slf4jLogging) {
            logger.info(CommonI18n.slf4jAvailable, new Object[0]);
        } else if (log4jLogging) {
            logger.info(CommonI18n.log4jAvailable, new Object[0]);
        } else {
            logger.info(CommonI18n.jdkFallback, new Object[0]);
        }
        if (customLoggingError != null) {
            logger.warn(customLoggingError, CommonI18n.errorInitializingCustomLoggerFactory, CUSTOM_LOG_FACTORY_CLASSNAME);
        }
    }
}

