/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class JsonNode
extends JSONObject {
    private static final long serialVersionUID = 1L;
    private final String id;

    protected JsonNode(String id) {
        assert (id != null);
        this.id = id;
    }

    public byte[] getContent() throws Exception {
        return super.toString().getBytes();
    }

    public String getId() {
        return this.id;
    }

    public abstract URL getUrl() throws Exception;

    @Override
    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("ID: ").append(this.getId());
        txt.append(", URL: ");
        try {
            txt.append(this.getUrl());
        }
        catch (Exception e) {
            txt.append("exception obtaining URL");
        }
        txt.append(", content: ").append(super.toString());
        return txt.toString();
    }

    protected JsonNode withPrimaryType(String primaryType) throws JSONException {
        return this.withProperty("jcr:primaryType", primaryType);
    }

    protected JsonNode withMixin(String mixin) throws JSONException {
        JSONObject properties = this.properties();
        if (!properties.has("jcr:mixinTypes")) {
            this.withProperty("jcr:mixinTypes", new JSONArray());
        }
        return this.withProperty("jcr:mixinTypes", mixin);
    }

    protected JsonNode withProperty(String key, Object value) throws JSONException {
        Object existingValue;
        JSONObject properties = this.properties();
        if (properties.has(key) && (existingValue = properties.get(key)) != null && existingValue instanceof JSONArray) {
            ((JSONArray)existingValue).put(value);
            return this;
        }
        properties.put(key, value);
        return this;
    }

    protected JsonNode withChild(String name, JSONObject child) throws JSONException {
        JSONObject children = this.children();
        children.put(name, child);
        return this;
    }

    protected JSONObject children() throws JSONException {
        if (!this.has("children")) {
            this.put("children", new JSONObject());
        }
        return this.getJSONObject("children");
    }

    protected JSONObject properties() throws JSONException {
        if (!this.has("properties")) {
            this.put("properties", new JSONObject());
        }
        return this.getJSONObject("properties");
    }
}

