/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.jdbc.metadata.QueryResultRow;

class QueryResultRowIterator
implements RowIterator {
    private final Iterator<List<?>> tuples;
    private long position = 0L;
    private long numRows;
    private Row nextRow;
    private String[] colNames;

    protected QueryResultRowIterator(List<List<?>> tuplesArray, String[] columnNames) {
        this.tuples = tuplesArray.iterator();
        this.numRows = tuplesArray.size();
        this.colNames = columnNames;
    }

    public boolean hasSelector(String selectorName) {
        return false;
    }

    @Override
    public Row nextRow() {
        if (this.nextRow == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.nextRow != null);
        Row result = this.nextRow;
        this.nextRow = null;
        ++this.position;
        return result;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getSize() {
        return this.numRows;
    }

    @Override
    public void skip(long skipNum) {
        for (long i = 0L; i != skipNum; ++i) {
            this.tuples.next();
        }
        this.position += skipNum;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        while (this.tuples.hasNext()) {
            List<?> tuple = this.tuples.next();
            try {
                this.nextRow = this.getNextRow(tuple);
                if (this.nextRow != null) {
                    return true;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            --this.numRows;
        }
        return false;
    }

    private Row getNextRow(List<?> tuple) throws RepositoryException {
        return new QueryResultRow(this, tuple, this.colNames);
    }

    public Object next() {
        return this.nextRow();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

