/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.DecorateTypes;
import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;

public class DecoratorMatcher {
    public <T> T decorate(Class<T> targetClass, T target, Class type, Annotation[] annotations, MediaType mediaType) {
        HashMap<Class<? extends Annotation>, Annotation> meta = new HashMap<Class<? extends Annotation>, Annotation>();
        if (type != null) {
            for (Annotation annotation : type.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Decorator.class)) continue;
                meta.put(annotation.annotationType(), annotation);
            }
        }
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                Decorator decorator = annotation.annotationType().getAnnotation(Decorator.class);
                if (decorator == null || !targetClass.isAssignableFrom(decorator.target())) continue;
                meta.put(annotation.annotationType(), annotation);
            }
        }
        if (meta.size() == 0) {
            return target;
        }
        MediaTypeMap<Class> typeMap = new MediaTypeMap<Class>();
        for (Class decoratorAnnotation : meta.keySet()) {
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            String[] mediaTypes = new String[]{"*/*"};
            DecorateTypes produces = decorator.processor().getAnnotation(DecorateTypes.class);
            if (produces != null) {
                mediaTypes = produces.value();
            }
            for (String pType : mediaTypes) {
                typeMap.add(MediaType.valueOf(pType), decoratorAnnotation);
            }
        }
        List list = typeMap.getPossible(mediaType);
        for (Class decoratorAnnotation : list) {
            Annotation annotation = (Annotation)meta.get(decoratorAnnotation);
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            DecoratorProcessor processor = null;
            try {
                processor = decorator.processor().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            target = processor.decorate(target, annotation, type, annotations, mediaType);
        }
        return target;
    }
}

