/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.maven;

import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.maven.MavenUrl;

public class MavenUrlTest {
    private MavenUrl valid;
    private String validHostname;
    private int validPort;
    private String validWorkspace;
    private String validPath;
    private URLStreamHandler urlStreamHandler;

    @Before
    public void beforeEach() {
        this.validHostname = "localhost";
        this.validPort = 1000;
        this.validWorkspace = "workspaceTwo";
        this.validPath = "/path/to/some/node";
        this.valid = new MavenUrl();
        this.valid.setHostname(this.validHostname);
        this.valid.setPort(this.validPort);
        this.valid.setWorkspaceName(this.validWorkspace);
        this.valid.setPath(this.validPath);
        this.urlStreamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) {
                return null;
            }
        };
    }

    @Test
    public void shouldAcceptNullOrBlankHostButStoreAsEmptyString() {
        this.valid.setHostname(null);
        Assert.assertThat((Object)this.valid.getHostname(), (Matcher)Is.is((Object)""));
        this.valid.setHostname("  ");
        Assert.assertThat((Object)this.valid.getHostname(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldAcceptNullOrBlankWorkspaceNameButStoreAsEmptyString() {
        this.valid.setWorkspaceName(null);
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)""));
        this.valid.setWorkspaceName("   ");
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldRemoveLeadingAndTrailingDelimitersFromWorkspace() {
        this.valid.setWorkspaceName("//workspaceName");
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)"workspaceName"));
        this.valid.setWorkspaceName("//workspaceName//");
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)"workspaceName"));
        this.valid.setWorkspaceName("workspaceName//");
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)"workspaceName"));
        this.valid.setWorkspaceName("//");
        Assert.assertThat((Object)this.valid.getWorkspaceName(), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldAcceptNullOrBlankPathButStorePathWithLeadingDelimiter() {
        this.valid.setPath(null);
        Assert.assertThat((Object)this.valid.getPath(), (Matcher)Is.is((Object)"/"));
        this.valid.setPath("   ");
        Assert.assertThat((Object)this.valid.getPath(), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void shouldAcceptPathWithoutLeadingDelimiterButStorePathWithLeadingDelimiter() {
        this.valid.setPath("path/x");
        Assert.assertThat((Object)this.valid.getPath(), (Matcher)Is.is((Object)"/path/x"));
    }

    @Test
    public void shouldAllowPathWithOneOrMoreTrailingDelimiters() {
        this.valid.setPath("path/x/");
        Assert.assertThat((Object)this.valid.getPath(), (Matcher)Is.is((Object)"/path/x/"));
        this.valid.setPath("path/x///");
        Assert.assertThat((Object)this.valid.getPath(), (Matcher)Is.is((Object)"/path/x///"));
    }

    @Test
    public void shouldParseUrlsWithValidFormat() throws Exception {
        this.parse("jcr://localhost:10001/workspaceName/path/to/node/x", "localhost", 10001, "workspaceName", "/path/to/node/x");
        this.parse("jcr://localhost:10001//path/to/node/x", "localhost", 10001, "", "/path/to/node/x");
        this.parse("jcr://localhost:10001/", "localhost", 10001, "", "/");
        this.parse("jcr://localhost:10001/workspaceName/", "localhost", 10001, "workspaceName", "/");
        this.parse("jcr://localhost:10001/workspaceName//", "localhost", 10001, "workspaceName", "/", "jcr://localhost:10001/workspaceName/");
        this.parse("jcr://localhost:10001/workspaceName//a//", "localhost", 10001, "workspaceName", "/a//", "jcr://localhost:10001/workspaceName/a//");
        this.parse("jcr://localhost:10001/workspaceName", "localhost", 10001, "workspaceName", "/", "jcr://localhost:10001/workspaceName/");
        this.parse("jcr:///workspaceName/path/to/node/x", "", -1, "workspaceName", "/path/to/node/x", "jcr:/workspaceName/path/to/node/x");
        this.parse("jcr:////path/to/node/x", "", -1, "", "/path/to/node/x", "jcr://path/to/node/x");
        this.parse("jcr:/workspaceName/path/to/node/x", "", -1, "workspaceName", "/path/to/node/x", "jcr:/workspaceName/path/to/node/x");
        this.parse("jcr://path/to/node/x", "path", -1, "to", "/node/x", "jcr://path/to/node/x");
    }

    @Test
    public void shouldNotParseUrlsWithInvalidFormat() {
        Assert.assertThat((Object)MavenUrl.parse((String)"http:///workspaceName/path/to/node/x", null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    public void parse(String url, String expectedHostname, int expectedPort, String expectedWorkspaceName, String expectedPath) throws Exception {
        this.parse(url, expectedHostname, expectedPort, expectedWorkspaceName, expectedPath, url);
    }

    public void parse(String url, String expectedHostname, int expectedPort, String expectedWorkspaceName, String expectedPath, String expectedUrl) throws Exception {
        MavenUrl result = MavenUrl.parse((String)url, null);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result.getHostname(), (Matcher)Is.is((Object)expectedHostname));
        Assert.assertThat((Object)result.getPort(), (Matcher)Is.is((Object)expectedPort));
        Assert.assertThat((Object)result.getWorkspaceName(), (Matcher)Is.is((Object)expectedWorkspaceName));
        Assert.assertThat((Object)result.getPath(), (Matcher)Is.is((Object)expectedPath));
        URL resultingUrl = result.getUrl(this.urlStreamHandler, null);
        Assert.assertThat((Object)resultingUrl.toString(), (Matcher)Is.is((Object)expectedUrl));
    }

    public MavenUrl createUrl(String hostname, int port, String workspaceName, String path, String expectedUrl) throws Exception {
        MavenUrl url = new MavenUrl();
        url.setHostname(hostname);
        url.setPort(port);
        url.setWorkspaceName(workspaceName);
        url.setPath(path);
        URL resultingUrl = url.getUrl(this.urlStreamHandler, null);
        Assert.assertThat((Object)resultingUrl.toString(), (Matcher)Is.is((Object)expectedUrl));
        Assert.assertThat((Object)url.toString(), (Matcher)Is.is((Object)expectedUrl));
        return url;
    }

    @Test
    public void shouldCreateUrlWithHostnameAndPortAndWorkspaceAndPath() throws Exception {
        this.createUrl("localhost", 10001, "workspace", "/a/b/c", "jcr://localhost:10001/workspace/a/b/c");
    }

    @Test
    public void shouldCreateUrlWithHostnameAndPortAndWorkspaceAndNoPath() throws Exception {
        this.createUrl("localhost", 10001, "workspace", null, "jcr://localhost:10001/workspace/");
        this.createUrl("localhost", 10001, "workspace", "", "jcr://localhost:10001/workspace/");
        this.createUrl("localhost", 10001, "workspace", "   ", "jcr://localhost:10001/workspace/");
    }

    @Test
    public void shouldCreateUrlWithHostnameAndPortAndPathAndNoWorkspace() throws Exception {
        this.createUrl("localhost", 10001, null, "/a/b/c", "jcr://localhost:10001//a/b/c");
        this.createUrl("localhost", 10001, "", "/a/b/c", "jcr://localhost:10001//a/b/c");
        this.createUrl("localhost", 10001, "   ", "/a/b/c", "jcr://localhost:10001//a/b/c");
    }

    @Test
    public void shouldCreateUrlWithHostnameAndWorkspaceAndPathAndNoPort() throws Exception {
        this.createUrl("localhost", -1, "workspace", "/a/b/c", "jcr://localhost/workspace/a/b/c");
    }

    @Test
    public void shouldCreateUrlWithWorkspaceAndPathAndNoHostnameOrPort() throws Exception {
        this.createUrl(null, -1, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
        this.createUrl("", -1, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
        this.createUrl("   ", -1, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
    }

    @Test
    public void shouldCreateUrlWithPortWorkspaceAndPathAndNoHostname() throws Exception {
        this.createUrl(null, 10001, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
        this.createUrl("", 10001, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
        this.createUrl("   ", 10001, "workspace", "/a/b/c", "jcr:/workspace/a/b/c");
    }

    @Test
    public void shouldCreateUrlWithPathAndNoHostnameOrPortOrWorkspace() throws Exception {
        this.createUrl(null, -1, null, "/a/b/c", "jcr://a/b/c");
        this.createUrl("", -1, null, "/a/b/c", "jcr://a/b/c");
        this.createUrl("   ", -1, null, "/a/b/c", "jcr://a/b/c");
    }
}

