/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.demo.sequencer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.JcrTools;

public class SequencerDemo {
    protected static boolean print = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        ModeShapeEngine engine = new ModeShapeEngine();
        engine.start();
        JcrRepository repository = null;
        String repositoryName = null;
        try {
            URL url = SequencerDemo.class.getClassLoader().getResource("my-repository.json");
            RepositoryConfiguration config = RepositoryConfiguration.read((URL)url);
            Problems problems = config.validate();
            if (problems.hasErrors()) {
                System.err.println("Problems starting the engine.");
                System.err.println(problems);
                System.exit(-1);
            }
            repository = engine.deploy(config);
            repositoryName = config.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
        Session session = null;
        JcrTools tools = new JcrTools();
        try {
            repository = engine.getRepository(repositoryName);
            session = repository.login("default");
            Node root = session.getRootNode();
            Node filesNode = root.addNode("files", "nt:folder");
            assert (filesNode != null);
            tools.uploadFile(session, "/files/caution.png", SequencerDemo.getFile("caution.png"));
            tools.uploadFile(session, "/files/sample1.mp3", SequencerDemo.getFile("sample1.mp3"));
            tools.uploadFile(session, "/files/fixedWidthFile.txt", SequencerDemo.getFile("fixedWidthFile.txt"));
            tools.uploadFile(session, "/files/JcrRepository.class", SequencerDemo.getFile("JcrRepository.clazz"));
            session.save();
            Node png = SequencerDemo.findNodeAndWait(session, "/images/caution.png", 10L, TimeUnit.SECONDS);
            if (print) {
                tools.printSubgraph(png);
            }
            Node sampleMp3 = SequencerDemo.findNodeAndWait(session, "/audio/sample1.mp3", 10L, TimeUnit.SECONDS);
            if (print) {
                tools.printSubgraph(sampleMp3);
            }
            Node javaClass = SequencerDemo.findNodeAndWait(session, "/java/JcrRepository.class", 10L, TimeUnit.SECONDS);
            if (print) {
                tools.printSubgraph(javaClass);
            }
            Node textFile = SequencerDemo.findNodeAndWait(session, "/text/fixedWidthFile.txt", 10L, TimeUnit.SECONDS);
            if (print) {
                tools.printSubgraph(textFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.logout();
            }
            System.out.println("Shutting down engine ...");
            try {
                engine.shutdown().get();
                System.out.println("Success!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static InputStream getFile(String path) {
        File file = new File(path);
        if (file.exists() && file.canRead()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return SequencerDemo.class.getClassLoader().getResourceAsStream(path);
    }

    public static Node findNodeAndWait(Session session, String path, long maxWaitTime, TimeUnit unit) throws RepositoryException, InterruptedException {
        long start = System.currentTimeMillis();
        long maxWaitInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        while (true) {
            try {
                return session.getNode(path);
            }
            catch (PathNotFoundException e) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - start <= maxWaitInMillis) continue;
                throw new PathNotFoundException("Failed to find node '" + path + "' even after waiting " + maxWaitTime + " " + (Object)((Object)unit));
            }
            break;
        }
    }
}

