/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class PrimitiveJsonNodeConverter
implements ConditionalConverter<JsonNode, Object> {
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return JsonNode.class.isAssignableFrom(sourceType) && !ContainerNode.class.isAssignableFrom(sourceType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public Object convert(MappingContext<JsonNode, Object> context) {
        JsonNode source = (JsonNode)context.getSource();
        if (source == null) {
            return null;
        }
        if (source.isNumber()) {
            MappingContext mappingContext = context.create((Object)source.numberValue(), context.getDestinationType());
            return context.getMappingEngine().map(mappingContext);
        }
        MappingContext mappingContext = context.create((Object)source.textValue(), context.getDestinationType());
        return context.getMappingEngine().map(mappingContext);
    }
}

