/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng.internal;

import java.util.List;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.util.reflection.Fields;
import org.mockito.internal.util.reflection.InstanceField;
import org.mockito.quality.Strictness;
import org.testng.IInvokedMethod;
import org.testng.ITestResult;

public class MockitoBeforeTestNGMethod {
    private final Map<Object, MockitoSession> sessions;

    public MockitoBeforeTestNGMethod(Map<Object, MockitoSession> sessions) {
        this.sessions = sessions;
    }

    public void applyFor(IInvokedMethod method, ITestResult testResult) {
        this.initMocks(testResult);
        this.reinitCaptors(method, testResult);
    }

    private void reinitCaptors(IInvokedMethod method, ITestResult testResult) {
        if (method.isConfigurationMethod()) {
            return;
        }
        this.initializeCaptors(testResult.getInstance());
    }

    private void initMocks(ITestResult testResult) {
        Object testInstance = testResult.getInstance();
        if (this.alreadyInitialized(testInstance)) {
            return;
        }
        MockitoSession session = Mockito.mockitoSession().initMocks(testInstance).strictness(Strictness.STRICT_STUBS).startMocking();
        this.sessions.put(testInstance, session);
    }

    private void initializeCaptors(Object instance) {
        List instanceFields = Fields.allDeclaredFieldsOf((Object)instance).filter(Fields.annotatedBy((Class[])new Class[]{Captor.class})).instanceFields();
        for (InstanceField instanceField : instanceFields) {
            instanceField.set(new CaptorAnnotationProcessor().process((Captor)instanceField.annotation(Captor.class), instanceField.jdkField()));
        }
    }

    private boolean alreadyInitialized(Object instance) {
        return this.sessions.containsKey(instance);
    }
}

