/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.kotlin;

import java.lang.reflect.Array;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.mockito.ArgumentCaptor;
import org.mockito.kotlin.ArgumentCaptorKt;
import org.mockito.kotlin.internal.CreateInstanceKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000*\f\b\u0000\u0010\u0001 \u0001*\u0004\u0018\u00010\u00022\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/mockito/kotlin/KArgumentCaptor;", "T", "", "captor", "Lorg/mockito/ArgumentCaptor;", "tClass", "Lkotlin/reflect/KClass;", "<init>", "(Lorg/mockito/ArgumentCaptor;Lkotlin/reflect/KClass;)V", "firstValue", "getFirstValue", "()Ljava/lang/Object;", "secondValue", "getSecondValue", "thirdValue", "getThirdValue", "lastValue", "getLastValue", "singleValue", "getSingleValue", "allValues", "", "getAllValues", "()Ljava/util/List;", "capture", "singleElementArray", "mockito-kotlin"})
public final class KArgumentCaptor<T> {
    @NotNull
    private final ArgumentCaptor<T> captor;
    @NotNull
    private final KClass<?> tClass;

    public KArgumentCaptor(@NotNull ArgumentCaptor<T> captor, @NotNull KClass<?> tClass) {
        Intrinsics.checkNotNullParameter(captor, (String)"captor");
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        this.captor = captor;
        this.tClass = tClass;
    }

    public final T getFirstValue() {
        return ArgumentCaptorKt.getFirstValue(this.captor);
    }

    public final T getSecondValue() {
        return ArgumentCaptorKt.getSecondValue(this.captor);
    }

    public final T getThirdValue() {
        return ArgumentCaptorKt.getThirdValue(this.captor);
    }

    public final T getLastValue() {
        return ArgumentCaptorKt.getLastValue(this.captor);
    }

    public final T getSingleValue() {
        return ArgumentCaptorKt.getSingleValue(this.captor);
    }

    @NotNull
    public final List<T> getAllValues() {
        List list = this.captor.getAllValues();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllValues(...)");
        return list;
    }

    public final T capture() {
        Object object = this.captor.capture();
        if (object == null) {
            object = JvmClassMappingKt.getJavaClass(this.tClass).isArray() ? this.singleElementArray() : CreateInstanceKt.createInstance(this.tClass);
        }
        return (T)object;
    }

    private final Object singleElementArray() {
        return Array.newInstance(JvmClassMappingKt.getJavaClass(this.tClass).getComponentType(), 1);
    }
}

