/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.mockftpserver.core.CommandSyntaxException;
import org.mockftpserver.core.IllegalStateException;
import org.mockftpserver.core.NotLoggedInException;
import org.mockftpserver.core.command.AbstractCommandHandler;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.fake.ServerConfiguration;
import org.mockftpserver.fake.ServerConfigurationAware;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.filesystem.FileSystem;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemException;
import org.mockftpserver.fake.filesystem.InvalidFilenameException;

public abstract class AbstractFakeCommandHandler
extends AbstractCommandHandler
implements ServerConfigurationAware {
    protected static final String INTERNAL_ERROR_KEY = "internalError";
    private ServerConfiguration serverConfiguration;
    protected int replyCodeForFileSystemException = 550;

    @Override
    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public void handleCommand(Command command, Session session) {
        Assert.notNull(this.serverConfiguration, "serverConfiguration");
        Assert.notNull(command, "command");
        Assert.notNull(session, "session");
        try {
            this.handle(command, session);
        }
        catch (CommandSyntaxException e) {
            this.handleException(command, session, e, 501);
        }
        catch (IllegalStateException e) {
            this.handleException(command, session, e, 503);
        }
        catch (NotLoggedInException e) {
            this.handleException(command, session, e, 530);
        }
        catch (InvalidFilenameException e) {
            this.handleFileSystemException(command, session, e, 553, e.getPath());
        }
        catch (FileSystemException e) {
            this.handleFileSystemException(command, session, e, this.replyCodeForFileSystemException, e.getPath());
        }
    }

    protected FileSystem getFileSystem() {
        return this.serverConfiguration.getFileSystem();
    }

    protected abstract void handle(Command var1, Session var2);

    protected void sendReply(Session session, int replyCode, String messageKey) {
        this.sendReply(session, replyCode, messageKey, Collections.EMPTY_LIST);
    }

    protected void sendReply(Session session, int replyCode, String messageKey, List args) {
        Assert.notNull(session, "session");
        this.assertValidReplyCode(replyCode);
        String text = this.getTextForKey(messageKey);
        String replyText = args != null && !args.isEmpty() ? MessageFormat.format(text, args.toArray()) : text;
        String replyTextToLog = replyText == null ? "" : " " + replyText;
        String argsToLog = args != null && !args.isEmpty() ? " args=" + args : "";
        this.LOG.info("Sending reply [" + replyCode + replyTextToLog + "]" + argsToLog);
        session.sendReply(replyCode, replyText);
    }

    protected void sendReply(Session session, int replyCode) {
        this.sendReply(session, replyCode, Collections.EMPTY_LIST);
    }

    protected void sendReply(Session session, int replyCode, List args) {
        this.sendReply(session, replyCode, Integer.toString(replyCode), args);
    }

    private void handleException(Command command, Session session, Throwable exception, int replyCode) {
        this.LOG.warn("Error handling command: " + command + "; " + exception, exception);
        this.sendReply(session, replyCode);
    }

    private void handleFileSystemException(Command command, Session session, FileSystemException exception, int replyCode, Object arg) {
        this.LOG.warn("Error handling command: " + command + "; " + exception, (Throwable)exception);
        this.sendReply(session, replyCode, exception.getMessageKey(), Collections.singletonList(arg));
    }

    protected Object getRequiredSessionAttribute(Session session, String name) {
        Object value = session.getAttribute(name);
        if (value == null) {
            throw new IllegalStateException("Session missing required attribute [" + name + "]");
        }
        return value;
    }

    protected void verifyLoggedIn(Session session) {
        if (this.getUserAccount(session) == null) {
            throw new NotLoggedInException("User has not logged in");
        }
    }

    protected UserAccount getUserAccount(Session session) {
        return (UserAccount)session.getAttribute("userAccount");
    }

    protected void verifyFileSystemCondition(boolean condition, String path, String messageKey) {
        if (!condition) {
            throw new FileSystemException(path, messageKey);
        }
    }

    protected void verifyExecutePermission(Session session, String path) {
        UserAccount userAccount = this.getUserAccount(session);
        FileSystemEntry entry = this.getFileSystem().getEntry(path);
        this.verifyFileSystemCondition(userAccount.canExecute(entry), path, "filesystem.cannotExecute");
    }

    protected void verifyWritePermission(Session session, String path) {
        UserAccount userAccount = this.getUserAccount(session);
        FileSystemEntry entry = this.getFileSystem().getEntry(path);
        this.verifyFileSystemCondition(userAccount.canWrite(entry), path, "filesystem.cannotWrite");
    }

    protected void verifyReadPermission(Session session, String path) {
        UserAccount userAccount = this.getUserAccount(session);
        FileSystemEntry entry = this.getFileSystem().getEntry(path);
        this.verifyFileSystemCondition(userAccount.canRead(entry), path, "filesystem.cannotRead");
    }

    protected String getRealPath(Session session, String path) {
        String currentDirectory = (String)session.getAttribute("currentDirectory");
        if (path == null) {
            return currentDirectory;
        }
        if (this.getFileSystem().isAbsolute(path)) {
            return path;
        }
        return this.getFileSystem().path(currentDirectory, path);
    }

    protected String endOfLine() {
        return "\r\n";
    }

    private String getTextForKey(String key) {
        String msgKey = key != null ? key : INTERNAL_ERROR_KEY;
        try {
            return this.getReplyTextBundle().getString(msgKey);
        }
        catch (MissingResourceException e) {
            this.LOG.warn("No reply text defined for key [" + msgKey + "]");
            return null;
        }
    }

    protected boolean validateUserAccount(String username, Session session) {
        UserAccount userAccount = this.serverConfiguration.getUserAccount(username);
        if (userAccount == null || !userAccount.isValid()) {
            this.LOG.error("UserAccount missing or not valid for username [" + username + "]: " + userAccount);
            this.sendReply(session, 530, "login.userAccountNotValid", this.list(username));
            return false;
        }
        String home = userAccount.getHomeDirectory();
        if (!this.getFileSystem().isDirectory(home)) {
            this.LOG.error("Home directory configured for username [" + username + "] is not valid: " + home);
            this.sendReply(session, 530, "login.homeDirectoryNotValid", this.list(username, home));
            return false;
        }
        return true;
    }

    protected void login(UserAccount userAccount, Session session, int replyCode, String replyMessageKey) {
        this.sendReply(session, replyCode, replyMessageKey);
        session.setAttribute("userAccount", userAccount);
        session.setAttribute("currentDirectory", userAccount.getHomeDirectory());
    }

    protected List list(Object item) {
        return Collections.singletonList(item);
    }

    protected List list(Object item1, Object item2) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(item1);
        list.add(item2);
        return list;
    }

    protected boolean notNullOrEmpty(String string) {
        return string != null && string.length() > 0;
    }

    protected String defaultIfNullOrEmpty(String string, String defaultString) {
        return this.notNullOrEmpty(string) ? string : defaultString;
    }
}

