/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.test;

import java.util.concurrent.TimeUnit;

public class Retries {
    public static void tryWaitForSuccess(Runnable runnable, int maxAttempts, long retryInterval, TimeUnit retryIntervalUnits) {
        int attempts = 0;
        Object lastThrown = new AssertionError((Object)"fail");
        while (attempts++ < maxAttempts) {
            try {
                runnable.run();
                return;
            }
            catch (Error throwable) {
                lastThrown = throwable;
                if (attempts >= maxAttempts) continue;
                try {
                    retryIntervalUnits.sleep(retryInterval);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie.getMessage(), ie);
                }
            }
        }
        throw lastThrown;
    }

    public static void tryWaitForSuccess(Runnable runnable) {
        Retries.tryWaitForSuccess(runnable, 50, 100L, TimeUnit.MILLISECONDS);
    }
}

