/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.filters.LogFilter;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.server.unification.PortUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerInitializer
extends PortUnificationHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MockServerMatcher mockServerMatcher;
    private final boolean secure;
    private final MockServer mockServer;

    public MockServerInitializer(MockServerMatcher mockServerMatcher, MockServer mockServer, boolean secure) {
        this.mockServerMatcher = mockServerMatcher;
        this.secure = secure;
        this.mockServer = mockServer;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, ChannelPipeline pipeline) {
        if (this.logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.logger)});
        }
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.secure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHandler(this.mockServer, this.mockServerMatcher, (LogFilter)ctx.channel().attr(MockServer.LOG_FILTER).get())});
    }
}

