/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.mockserver.cli.Main;
import org.mockserver.client.MockServerClient;
import org.mockserver.maven.InstanceHolder;
import org.mockserver.maven.MockServerAbstractMojo;
import org.mockserver.maven.ProcessBuildFactory;

@Mojo(name="runForked", requiresProject=false)
public class MockServerRunForkedMojo
extends MockServerAbstractMojo {
    @Parameter(property="mockserver.jvmOptions")
    protected String jvmOptions;
    @Component
    protected RepositorySystem repositorySystem;
    private ProcessBuildFactory processBuildFactory = new ProcessBuildFactory();
    private MockServerClient mockServerClient = this.getServerPorts() != null && this.getServerPorts().length > 0 ? new MockServerClient("localhost", this.getServerPorts()[0].intValue()) : null;

    private static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            this.getLocalMockServerInstance().stop(this.getServerPorts(), true);
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Exception while waiting for existing mock server JVM to stop", e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:runForked about to start MockServer on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "")));
            }
            ArrayList<String> arguments = new ArrayList<String>(Collections.singletonList(this.getJavaBin()));
            arguments.add("-Dfile.encoding=UTF-8");
            if (StringUtils.isNotBlank((CharSequence)this.jvmOptions)) {
                arguments.add(this.jvmOptions);
            }
            arguments.add("-cp");
            StringBuilder classPath = new StringBuilder(this.resolvePathForJarWithDependencies());
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                for (Dependency dependency : this.dependencies) {
                    classPath.append(System.getProperty("path.separator"));
                    classPath.append(this.resolvePathForDependencyJar(dependency));
                }
            }
            arguments.add(classPath.toString());
            arguments.add(Main.class.getName());
            if (this.getServerPorts() != null) {
                arguments.add("-serverPort");
                arguments.add("" + Joiner.on((String)",").join((Object[])this.getServerPorts()));
                MockServerAbstractMojo.mockServerPort(this.getServerPorts());
            }
            if (this.proxyRemotePort != -1) {
                arguments.add("-proxyRemotePort");
                arguments.add("" + this.proxyRemotePort);
            }
            if (!Strings.isNullOrEmpty((String)this.proxyRemoteHost)) {
                arguments.add("-proxyRemoteHost");
                arguments.add("" + this.proxyRemoteHost);
            }
            if (!Strings.isNullOrEmpty((String)this.logLevel)) {
                arguments.add("-logLevel");
                arguments.add("" + this.logLevel);
            }
            this.getLog().info((CharSequence)" ");
            String message = Joiner.on((String)" ").join(arguments);
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)message.length(), (String)"-"));
            this.getLog().info((CharSequence)message);
            this.getLog().info((CharSequence)StringUtils.rightPad((String)"", (int)message.length(), (String)"-"));
            this.getLog().info((CharSequence)" ");
            ProcessBuilder processBuilder = this.processBuildFactory.create(arguments);
            if (this.pipeLogToConsole) {
                processBuilder.inheritIO();
            }
            try {
                processBuilder.start();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Exception while starting MockServer", (Throwable)e);
            }
            if (this.getServerPorts() != null && this.getServerPorts().length > 0) {
                boolean hasStarted;
                if (this.mockServerClient == null) {
                    this.mockServerClient = new MockServerClient("localhost", this.getServerPorts()[0].intValue());
                }
                if (hasStarted = this.mockServerClient.hasStarted(150, 500L, TimeUnit.MILLISECONDS)) {
                    this.getLog().info((CharSequence)("mockserver:runForked MockServer is running on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "")));
                } else {
                    this.getLog().info((CharSequence)("mockserver:runForked Timed out waiting for MockServer to run on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "")));
                }
            }
            InstanceHolder.runInitialization(this.getServerPorts(), this.createInitializerClass(), this.createInitializerJson());
        }
    }

    @VisibleForTesting
    String getJavaBin() {
        String javaBinary = "java";
        File javaHomeDirectory = new File(System.getProperty("java.home"));
        for (String javaExecutable : new String[]{"java", "java.exe"}) {
            File javaExeLocation = new File(javaHomeDirectory, MockServerRunForkedMojo.fileSeparators("bin/" + javaExecutable));
            if (!javaExeLocation.exists() || !javaExeLocation.isFile()) continue;
            javaBinary = javaExeLocation.getAbsolutePath();
            break;
        }
        return javaBinary;
    }

    private String resolvePathForDependencyJar(Dependency dependency) {
        String path = "";
        Artifact dependencyArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(dependencyArtifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        if (this.session != null && this.session.getRequest() != null) {
            request.setServers(this.session.getRequest().getServers());
            request.setMirrors(this.session.getRequest().getMirrors());
            request.setProxies(this.session.getRequest().getProxies());
            request.setLocalRepository(this.session.getLocalRepository());
            request.setRemoteRepositories(this.session.getRequest().getRemoteRepositories());
        }
        this.repositorySystem.resolve(request);
        if (dependencyArtifact != null && dependencyArtifact.getFile() != null) {
            path = dependencyArtifact.getFile().getAbsolutePath();
        }
        return path;
    }

    private String resolvePathForJarWithDependencies() {
        Dependency dependency = new Dependency();
        dependency.setGroupId("org.mock-server");
        dependency.setArtifactId("mockserver-netty-no-dependencies");
        dependency.setVersion(this.getVersion());
        dependency.setType("jar");
        return this.resolvePathForDependencyJar(dependency);
    }

    @VisibleForTesting
    String getVersion() {
        String version = "5.5.4";
        try {
            Properties p = new Properties();
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/org.mock-server/mockserver-maven-plugin/pom.properties");
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "5.5.4");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLog().info((CharSequence)("Using org.mock-server:mockserver-netty-no-dependencies:" + version));
        return version;
    }
}

