/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.initialize.ExpectationInitializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.maven.MockServerAbstractMojo;
import org.mockserver.mock.Expectation;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.netty.MockServer;
import org.mockserver.serialization.ExpectationSerializer;

public class InstanceHolder
extends ObjectWithReflectiveEqualsHashCodeToString {
    private MockServer mockServer;

    public static void runInitialization(Integer[] mockServerPorts, ExpectationInitializer expectationClassInitializer, String expectationJsonInitializer) {
        if (mockServerPorts != null && mockServerPorts.length > 0) {
            if (expectationClassInitializer != null) {
                expectationClassInitializer.initializeExpectations(new MockServerClient("127.0.0.1", mockServerPorts[0].intValue()));
            }
            if (StringUtils.isNotBlank((CharSequence)expectationJsonInitializer)) {
                Expectation[] expectations = new ExpectationSerializer(new MockServerLogger()).deserializeArray(expectationJsonInitializer, false);
                new MockServerClient("127.0.0.1", mockServerPorts[0].intValue()).sendExpectation(expectations);
            }
        }
    }

    public void start(Integer[] mockServerPorts, Integer proxyRemotePort, String proxyRemoteHost, String logLevel, ExpectationInitializer expectationClassInitializer, String expectationJsonInitializer) {
        if (this.mockServer == null || !this.mockServer.isRunning()) {
            if (logLevel != null) {
                ConfigurationProperties.logLevel((String)logLevel);
            }
            if (mockServerPorts != null && mockServerPorts.length > 0) {
                if (proxyRemotePort != null && proxyRemotePort != -1) {
                    if (Strings.isNullOrEmpty((String)proxyRemoteHost)) {
                        proxyRemoteHost = "localhost";
                    }
                    this.mockServer = new MockServer(proxyRemotePort, proxyRemoteHost, mockServerPorts);
                } else {
                    this.mockServer = new MockServer(mockServerPorts);
                }
                MockServerAbstractMojo.mockServerPort(this.mockServer.getLocalPort());
            }
        } else {
            throw new IllegalStateException("MockServer is already running!");
        }
        InstanceHolder.runInitialization(mockServerPorts, expectationClassInitializer, expectationJsonInitializer);
    }

    public void stop(Integer[] mockServerPorts, boolean ignoreFailure) {
        block3: {
            if (mockServerPorts != null && mockServerPorts.length > 0) {
                try {
                    ((MockServerClient)new MockServerClient("127.0.0.1", mockServerPorts[0].intValue()).stop(ignoreFailure).get()).hasStopped();
                }
                catch (Throwable throwable) {
                    if (ignoreFailure) break block3;
                    throw new RuntimeException(throwable.getMessage(), throwable);
                }
            }
        }
    }

    public void stop() {
        if (this.mockServer != null && this.mockServer.isRunning()) {
            this.mockServer.stop();
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

