/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.initialize.ExpectationInitializer;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerBuilder;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.ProxyBuilder;

public class InstanceHolder
extends ObjectWithReflectiveEqualsHashCodeToString {
    @VisibleForTesting
    static Map<Integer, MockServerClient> mockServerClients = new ConcurrentHashMap<Integer, MockServerClient>();
    @VisibleForTesting
    static Map<Integer, ProxyClient> proxyClients = new ConcurrentHashMap<Integer, ProxyClient>();
    private ProxyBuilder proxyBuilder = new ProxyBuilder();
    private MockServerBuilder mockServerBuilder = new MockServerBuilder();
    private Proxy proxy;
    private MockServer mockServer;

    public static void runInitializationClass(int mockServerPort, ExpectationInitializer expectationInitializer) {
        if (mockServerPort != -1 && expectationInitializer != null) {
            expectationInitializer.initializeExpectations(InstanceHolder.getMockServerClient(mockServerPort));
        }
    }

    private static ProxyClient getProxyClient(int proxyPort) {
        if (!proxyClients.containsKey(proxyPort)) {
            proxyClients.put(proxyPort, new ProxyClient("127.0.0.1", proxyPort));
        }
        return proxyClients.get(proxyPort);
    }

    private static MockServerClient getMockServerClient(int mockServerPort) {
        if (!mockServerClients.containsKey(mockServerPort)) {
            mockServerClients.put(mockServerPort, new MockServerClient("127.0.0.1", mockServerPort));
        }
        return mockServerClients.get(mockServerPort);
    }

    public void start(int mockServerPort, int proxyPort, ExpectationInitializer expectationInitializer) {
        if (this.mockServer == null || !this.mockServer.isRunning()) {
            if (mockServerPort != -1) {
                this.mockServer = this.mockServerBuilder.withHTTPPort(new Integer[]{mockServerPort}).build();
            }
        } else {
            throw new IllegalStateException("MockServer is already running!");
        }
        InstanceHolder.runInitializationClass(mockServerPort, expectationInitializer);
        if (this.proxy == null || !this.proxy.isRunning()) {
            if (proxyPort != -1) {
                this.proxy = this.proxyBuilder.withLocalPort(Integer.valueOf(proxyPort)).build();
            }
        } else {
            throw new IllegalStateException("Proxy is already running!");
        }
    }

    public void stop(int mockServerPort, int proxyPort, boolean ignoreFailure) {
        if (mockServerPort != -1) {
            InstanceHolder.getMockServerClient(mockServerPort).stop(ignoreFailure);
        }
        if (proxyPort != -1) {
            InstanceHolder.getProxyClient(proxyPort).stop(ignoreFailure);
        }
    }

    public void stop() {
        if (this.mockServer != null && this.mockServer.isRunning()) {
            this.mockServer.stop();
        }
        if (this.proxy != null && this.proxy.isRunning()) {
            this.proxy.stop();
        }
    }
}

