/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.awt.Desktop;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.Version;
import org.mockserver.client.ClientException;
import org.mockserver.client.ForwardChainExpectation;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.client.SocketConnectionException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.OpenAPIExpectation;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.PortBinding;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.RetrieveType;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.LogEventRequestAndResponseSerializer;
import org.mockserver.serialization.OpenAPIExpectationSerializer;
import org.mockserver.serialization.PortBindingSerializer;
import org.mockserver.serialization.RequestDefinitionSerializer;
import org.mockserver.serialization.VerificationSequenceSerializer;
import org.mockserver.serialization.VerificationSerializer;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.stop.Stoppable;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.event.Level;

public class MockServerClient
implements Stoppable {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(MockServerClient.class);
    private static final Map<Integer, MockServerEventBus> EVENT_BUS_MAP = new ConcurrentHashMap<Integer, MockServerEventBus>();
    private final EventLoopGroup eventLoopGroup = new NioEventLoopGroup(5, (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-eventLoop"));
    private final String host;
    private final String contextPath;
    private final Class<MockServerClient> clientClass = MockServerClient.class;
    protected CompletableFuture<Integer> portFuture;
    private Boolean secure;
    private Integer port;
    private NettyHttpClient nettyHttpClient = new NettyHttpClient(MOCK_SERVER_LOGGER, this.eventLoopGroup, null, false, new NettySslContextFactory(MOCK_SERVER_LOGGER));
    private HttpRequest requestOverride;
    private RequestDefinitionSerializer requestDefinitionSerializer = new RequestDefinitionSerializer(MOCK_SERVER_LOGGER);
    private LogEventRequestAndResponseSerializer httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer(MOCK_SERVER_LOGGER);
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer(MOCK_SERVER_LOGGER);
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer(MOCK_SERVER_LOGGER);
    private OpenAPIExpectationSerializer openAPIExpectationSerializer = new OpenAPIExpectationSerializer(MOCK_SERVER_LOGGER);
    private VerificationSerializer verificationSerializer = new VerificationSerializer(MOCK_SERVER_LOGGER);
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer(MOCK_SERVER_LOGGER);

    public MockServerClient(CompletableFuture<Integer> portFuture) {
        this.host = "127.0.0.1";
        this.portFuture = portFuture;
        this.contextPath = "";
    }

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    public MockServerClient setRequestOverride(HttpRequest requestOverride) {
        if (requestOverride == null) {
            throw new IllegalArgumentException("Request with default properties can not be null");
        }
        this.requestOverride = requestOverride;
        return this;
    }

    private MockServerEventBus getMockServerEventBus() {
        if (EVENT_BUS_MAP.get(this.port()) == null) {
            EVENT_BUS_MAP.put(this.port(), new MockServerEventBus());
        }
        return EVENT_BUS_MAP.get(this.port());
    }

    private void removeMockServerEventBus() {
        EVENT_BUS_MAP.remove(this.port());
    }

    public boolean isSecure() {
        return this.secure != null ? this.secure : false;
    }

    public MockServerClient withSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    private int port() {
        if (this.port == null) {
            try {
                this.port = this.portFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.port;
    }

    public InetSocketAddress remoteAddress() {
        return new InetSocketAddress(this.host, this.port());
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Integer getPort() {
        return this.port();
    }

    private String calculatePath(String path) {
        String cleanedPath = "/mockserver/" + path;
        if (StringUtils.isNotBlank((CharSequence)this.contextPath)) {
            cleanedPath = (!this.contextPath.startsWith("/") ? "/" : "") + this.contextPath + (!this.contextPath.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    private HttpResponse sendRequest(HttpRequest request, boolean ignoreErrors) {
        try {
            HttpResponse response;
            if (!request.containsHeader(HttpHeaderNames.CONTENT_TYPE.toString()) && request.getBody() != null && StringUtils.isNotBlank((CharSequence)request.getBody().getContentType())) {
                request.withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{request.getBody().getContentType()});
            }
            if (this.secure != null) {
                request.withSecure(this.secure);
            }
            if (this.requestOverride != null) {
                request = request.update(this.requestOverride);
            }
            if ((response = this.nettyHttpClient.sendRequest(request.withHeader(HttpHeaderNames.HOST.toString(), new String[]{this.host + ":" + this.port()}), ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS, ignoreErrors)) != null) {
                if (response.getStatusCode() != null && response.getStatusCode().intValue() == HttpResponseStatus.BAD_REQUEST.code()) {
                    throw new IllegalArgumentException(response.getBodyAsString());
                }
                String serverVersion = response.getFirstHeader("version");
                String clientVersion = Version.getVersion();
                if (!Version.matchesMajorMinorVersion((String)serverVersion)) {
                    throw new ClientException("Client version \"" + clientVersion + "\" major and minor versions do not match server version \"" + serverVersion + "\"");
                }
            }
            return response;
        }
        catch (RuntimeException rex) {
            if (StringUtils.isNotBlank((CharSequence)rex.getMessage()) && (rex.getMessage().contains("executor not accepting a task") || rex.getMessage().contains("loop shut down"))) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " has already been closed, please create new " + this.getClass().getSimpleName() + " instance");
            }
            throw rex;
        }
    }

    private HttpResponse sendRequest(HttpRequest request) {
        return this.sendRequest(request, false);
    }

    public MockServerClient openUI() {
        return this.openUI(TimeUnit.SECONDS, 1L);
    }

    public MockServerClient openUI(TimeUnit timeUnit, long pause) {
        try {
            Desktop desktop = Desktop.getDesktop();
            if (desktop != null) {
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(new URI("http" + (Boolean.TRUE.equals(this.secure) ? "s" : "") + "://" + this.host + ":" + this.port() + "/mockserver/dashboard"));
                    timeUnit.sleep(pause);
                } else if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("browse to URL not supported by the desktop instance from JVM"));
                }
            } else if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("unable to obtain the desktop instance from JVM"));
            }
        }
        catch (Throwable throwable) {
            if (MockServerLogger.isEnabled((Level)Level.ERROR)) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while attempting to launch UI" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : "")).setThrowable(throwable));
            }
            throw new ClientException("exception while attempting to launch UI" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : ""));
        }
        return this;
    }

    @Deprecated
    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), true);
            if (httpResponse != null && httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts <= 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("exception while checking if MockServer is running - " + sce.getMessage() + " if MockServer was stopped this exception is expected").setThrowable(sce));
            }
            return false;
        }
    }

    public boolean hasStopped() {
        return this.hasStopped(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStopped(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), true);
            if (httpResponse != null && httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                if (attempts <= 0) {
                    return false;
                }
                try {
                    timeUnit.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.hasStopped(attempts - 1, timeout, timeUnit);
            }
            return true;
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            return true;
        }
    }

    public boolean hasStarted() {
        return this.hasStarted(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStarted(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts <= 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            if (attempts <= 0) {
                if (MockServerLogger.isEnabled((Level)Level.DEBUG)) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while checking if MockServer has started - " + sce.getMessage()).setThrowable(sce));
                }
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
    }

    public List<Integer> bind(Integer ... ports) {
        String boundPorts = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("bind")).withBody(this.portBindingSerializer.serialize(PortBinding.portBinding((Integer[])ports)), StandardCharsets.UTF_8)).getBodyAsString();
        return this.portBindingSerializer.deserialize(boundPorts).getPorts();
    }

    public Future<MockServerClient> stopAsync() {
        return this.stop(true);
    }

    public void stop() {
        block2: {
            try {
                this.stopAsync().get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled((Level)Level.DEBUG)) break block2;
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while stopping - " + throwable.getMessage()).setThrowable(throwable));
            }
        }
    }

    public Future<MockServerClient> stop(boolean ignoreFailure) {
        this.getMockServerEventBus().publish(MockServerEventBus.EventType.STOP);
        this.removeMockServerEventBus();
        CompletableFuture<MockServerClient> stopFuture = new CompletableFuture<MockServerClient>();
        new Scheduler.SchedulerThreadFactory("ClientStop").newThread(() -> {
            block7: {
                try {
                    this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                    if (!this.hasStopped()) {
                        for (int i = 0; !this.hasStopped() && i < 50; ++i) {
                            TimeUnit.MILLISECONDS.sleep(5L);
                        }
                    }
                }
                catch (RejectedExecutionException ree) {
                    if (!ignoreFailure && MockServerLogger.isEnabled((Level)Level.TRACE)) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("request rejected while closing down, logging in case due other error " + ree).setThrowable((Throwable)ree));
                    }
                }
                catch (Exception e) {
                    if (ignoreFailure || !MockServerLogger.isEnabled((Level)Level.WARN)) break block7;
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("failed to send stop request to MockServer " + e.getMessage()));
                }
            }
            if (!this.eventLoopGroup.isShuttingDown()) {
                this.eventLoopGroup.shutdownGracefully();
            }
            stopFuture.complete(this.clientClass.cast(this));
        }).start();
        return stopFuture;
    }

    public void close() {
        this.stop();
    }

    public MockServerClient reset() {
        this.getMockServerEventBus().publish(MockServerEventBus.EventType.RESET);
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition ... requestDefinitions) throws AssertionError {
        if (requestDefinitions == null || requestDefinitions.length == 0 || requestDefinitions[0] == null) {
            throw new IllegalArgumentException("verify(RequestDefinition...) requires a non-null non-empty array of RequestDefinition objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(requestDefinitions);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition requestDefinition, VerificationTimes times) throws AssertionError {
        if (requestDefinition == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null RequestDefinition object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(requestDefinition).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        Verification verification = Verification.verification().withRequest((RequestDefinition)HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public RequestDefinition[] retrieveRecordedRequests(RequestDefinition requestDefinition) {
        String recordedRequests = this.retrieveRecordedRequests(requestDefinition, Format.JSON);
        if (StringUtils.isNotEmpty((CharSequence)recordedRequests) && !recordedRequests.equals("[]")) {
            return this.requestDefinitionSerializer.deserializeArray(recordedRequests);
        }
        return new RequestDefinition[0];
    }

    public String retrieveRecordedRequests(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUESTS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public LogEventRequestAndResponse[] retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition) {
        String recordedRequests = this.retrieveRecordedRequestsAndResponses(requestDefinition, Format.JSON);
        if (StringUtils.isNotEmpty((CharSequence)recordedRequests) && !recordedRequests.equals("[]")) {
            return this.httpRequestResponseSerializer.deserializeArray(recordedRequests);
        }
        return new LogEventRequestAndResponse[0];
    }

    public String retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUEST_RESPONSES.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public Expectation[] retrieveRecordedExpectations(RequestDefinition requestDefinition) {
        String recordedExpectations = this.retrieveRecordedExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)recordedExpectations) && !recordedExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(recordedExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveRecordedExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.RECORDED_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String retrieveLogMessages(RequestDefinition requestDefinition) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.LOGS.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String[] retrieveLogMessagesArray(RequestDefinition requestDefinition) {
        return this.retrieveLogMessages(requestDefinition).split(HttpState.LOG_SEPARATOR);
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition) {
        return this.when(requestDefinition, Times.unlimited());
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times) {
        return new ForwardChainExpectation(MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, TimeToLive.unlimited(), Integer.valueOf(0)));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, Integer.valueOf(0)));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive, Integer priority) {
        return new ForwardChainExpectation(MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, priority));
    }

    public Expectation[] upsert(OpenAPIExpectation ... openAPIExpectations) {
        if (openAPIExpectations != null) {
            HttpResponse httpResponse = null;
            if (openAPIExpectations.length == 1) {
                httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("openapi")).withBody(this.openAPIExpectationSerializer.serialize(openAPIExpectations[0]), StandardCharsets.UTF_8));
                if (httpResponse != null && httpResponse.getStatusCode() != 201) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted OpenAPI expectation:{}", (Object[])new Object[]{httpResponse.getBody(), openAPIExpectations[0]}));
                }
            } else if (openAPIExpectations.length > 1 && (httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("openapi")).withBody(this.openAPIExpectationSerializer.serialize(openAPIExpectations), StandardCharsets.UTF_8))) != null && httpResponse.getStatusCode() != 201) {
                throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted OpenAPI expectations:{}", (Object[])new Object[]{httpResponse.getBody(), openAPIExpectations}));
            }
            if (httpResponse != null && StringUtils.isNotBlank((CharSequence)httpResponse.getBodyAsString())) {
                return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString(), true);
            }
        }
        return new Expectation[0];
    }

    public Expectation[] upsert(Expectation ... expectations) {
        if (expectations != null) {
            HttpResponse httpResponse = null;
            if (expectations.length == 1) {
                httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations[0]), StandardCharsets.UTF_8));
                if (httpResponse != null && httpResponse.getStatusCode() != 201) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectation:{}", (Object[])new Object[]{httpResponse.getBody(), expectations[0]}));
                }
            } else if (expectations.length > 1 && (httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations), StandardCharsets.UTF_8))) != null && httpResponse.getStatusCode() != 201) {
                throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectations:{}", (Object[])new Object[]{httpResponse.getBody(), expectations}));
            }
            if (httpResponse != null && StringUtils.isNotBlank((CharSequence)httpResponse.getBodyAsString())) {
                return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString(), true);
            }
        }
        return new Expectation[0];
    }

    @Deprecated
    public Expectation[] sendExpectation(Expectation ... expectations) {
        return this.upsert(expectations);
    }

    public Expectation[] retrieveActiveExpectations(RequestDefinition requestDefinition) {
        String activeExpectations = this.retrieveActiveExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)activeExpectations) && !activeExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(activeExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveActiveExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.ACTIVE_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }
}

