/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v2_2.station_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geojson.MultiPolygon;
import org.mobilitydata.gbfs.v2_2.station_information.GBFSRentalUris;
import org.mobilitydata.gbfs.v2_2.station_information.GBFSVehicleCapacity;
import org.mobilitydata.gbfs.v2_2.station_information.GBFSVehicleTypeCapacity;
import org.mobilitydata.gbfs.v2_2.station_information.RentalMethod;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"station_id", "name", "short_name", "lat", "lon", "address", "cross_street", "region_id", "post_code", "rental_methods", "is_virtual_station", "station_area", "capacity", "vehicle_capacity", "is_valet_station", "rental_uris", "vehicle_type_capacity"})
public class GBFSStation
implements Serializable {
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier of a station.")
    private String stationId;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Public name of the station.")
    private String name;
    @JsonProperty(value="short_name")
    @JsonPropertyDescription(value="Short name or other type of identifier.")
    private String shortName;
    @JsonProperty(value="lat")
    @JsonPropertyDescription(value="The latitude of the station.")
    private Double lat;
    @JsonProperty(value="lon")
    @JsonPropertyDescription(value="The longitude fo the station.")
    private Double lon;
    @JsonProperty(value="address")
    @JsonPropertyDescription(value="Address where station is located.")
    private String address;
    @JsonProperty(value="cross_street")
    @JsonPropertyDescription(value="Cross street or landmark where the station is located.")
    private String crossStreet;
    @JsonProperty(value="region_id")
    @JsonPropertyDescription(value="Identifier of the region where the station is located.")
    private String regionId;
    @JsonProperty(value="post_code")
    @JsonPropertyDescription(value="Postal code where station is located.")
    private String postCode;
    @JsonProperty(value="rental_methods")
    @JsonPropertyDescription(value="Payment methods accepted at this station.")
    private List<RentalMethod> rentalMethods;
    @JsonProperty(value="is_virtual_station")
    @JsonPropertyDescription(value="Is this station a location with or without physical infrastructure? (added in v2.1-RC)")
    private Boolean isVirtualStation;
    @JsonProperty(value="station_area")
    @JsonPropertyDescription(value="A multipolygon that describes the area of a virtual station (added in v2.1-RC).")
    private MultiPolygon stationArea;
    @JsonProperty(value="capacity")
    @JsonPropertyDescription(value="Number of total docking points installed at this station, both available and unavailable.")
    private Integer capacity;
    @JsonProperty(value="vehicle_capacity")
    @JsonPropertyDescription(value="An object where each key is a vehicle_type_id and the value is a number presenting the total number of vehicles of this type that can park within the station_area (added in v2.1-RC).")
    private GBFSVehicleCapacity vehicleCapacity;
    @JsonProperty(value="is_valet_station")
    @JsonPropertyDescription(value="Are valet services provided at this station? (added in v2.1-RC)")
    private Boolean isValetStation;
    @JsonProperty(value="rental_uris")
    @JsonPropertyDescription(value="Contains rental uris for Android, iOS, and web in the android, ios, and web fields (added in v1.1).")
    private GBFSRentalUris rentalUris;
    @JsonProperty(value="vehicle_type_capacity")
    @JsonPropertyDescription(value="An object where each key is a vehicle_type_id and the value is a number representing the total docking points installed at this station for each vehicle type (added in v2.1-RC).")
    private GBFSVehicleTypeCapacity vehicleTypeCapacity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -6127092361081364838L;

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public GBFSStation withStationId(String stationId) {
        this.stationId = stationId;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GBFSStation withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="short_name")
    public String getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public GBFSStation withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty(value="lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty(value="lat")
    public void setLat(Double lat) {
        this.lat = lat;
    }

    public GBFSStation withLat(Double lat) {
        this.lat = lat;
        return this;
    }

    @JsonProperty(value="lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty(value="lon")
    public void setLon(Double lon) {
        this.lon = lon;
    }

    public GBFSStation withLon(Double lon) {
        this.lon = lon;
        return this;
    }

    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(String address) {
        this.address = address;
    }

    public GBFSStation withAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="cross_street")
    public String getCrossStreet() {
        return this.crossStreet;
    }

    @JsonProperty(value="cross_street")
    public void setCrossStreet(String crossStreet) {
        this.crossStreet = crossStreet;
    }

    public GBFSStation withCrossStreet(String crossStreet) {
        this.crossStreet = crossStreet;
        return this;
    }

    @JsonProperty(value="region_id")
    public String getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="region_id")
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public GBFSStation withRegionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    @JsonProperty(value="post_code")
    public String getPostCode() {
        return this.postCode;
    }

    @JsonProperty(value="post_code")
    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public GBFSStation withPostCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @JsonProperty(value="rental_methods")
    public List<RentalMethod> getRentalMethods() {
        return this.rentalMethods;
    }

    @JsonProperty(value="rental_methods")
    public void setRentalMethods(List<RentalMethod> rentalMethods) {
        this.rentalMethods = rentalMethods;
    }

    public GBFSStation withRentalMethods(List<RentalMethod> rentalMethods) {
        this.rentalMethods = rentalMethods;
        return this;
    }

    @JsonProperty(value="is_virtual_station")
    public Boolean getIsVirtualStation() {
        return this.isVirtualStation;
    }

    @JsonProperty(value="is_virtual_station")
    public void setIsVirtualStation(Boolean isVirtualStation) {
        this.isVirtualStation = isVirtualStation;
    }

    public GBFSStation withIsVirtualStation(Boolean isVirtualStation) {
        this.isVirtualStation = isVirtualStation;
        return this;
    }

    @JsonProperty(value="station_area")
    public MultiPolygon getStationArea() {
        return this.stationArea;
    }

    @JsonProperty(value="station_area")
    public void setStationArea(MultiPolygon stationArea) {
        this.stationArea = stationArea;
    }

    public GBFSStation withStationArea(MultiPolygon stationArea) {
        this.stationArea = stationArea;
        return this;
    }

    @JsonProperty(value="capacity")
    public Integer getCapacity() {
        return this.capacity;
    }

    @JsonProperty(value="capacity")
    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public GBFSStation withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @JsonProperty(value="vehicle_capacity")
    public GBFSVehicleCapacity getVehicleCapacity() {
        return this.vehicleCapacity;
    }

    @JsonProperty(value="vehicle_capacity")
    public void setVehicleCapacity(GBFSVehicleCapacity vehicleCapacity) {
        this.vehicleCapacity = vehicleCapacity;
    }

    public GBFSStation withVehicleCapacity(GBFSVehicleCapacity vehicleCapacity) {
        this.vehicleCapacity = vehicleCapacity;
        return this;
    }

    @JsonProperty(value="is_valet_station")
    public Boolean getIsValetStation() {
        return this.isValetStation;
    }

    @JsonProperty(value="is_valet_station")
    public void setIsValetStation(Boolean isValetStation) {
        this.isValetStation = isValetStation;
    }

    public GBFSStation withIsValetStation(Boolean isValetStation) {
        this.isValetStation = isValetStation;
        return this;
    }

    @JsonProperty(value="rental_uris")
    public GBFSRentalUris getRentalUris() {
        return this.rentalUris;
    }

    @JsonProperty(value="rental_uris")
    public void setRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
    }

    public GBFSStation withRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
        return this;
    }

    @JsonProperty(value="vehicle_type_capacity")
    public GBFSVehicleTypeCapacity getVehicleTypeCapacity() {
        return this.vehicleTypeCapacity;
    }

    @JsonProperty(value="vehicle_type_capacity")
    public void setVehicleTypeCapacity(GBFSVehicleTypeCapacity vehicleTypeCapacity) {
        this.vehicleTypeCapacity = vehicleTypeCapacity;
    }

    public GBFSStation withVehicleTypeCapacity(GBFSVehicleTypeCapacity vehicleTypeCapacity) {
        this.vehicleTypeCapacity = vehicleTypeCapacity;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSStation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSStation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(this.shortName == null ? "<null>" : this.shortName);
        sb.append(',');
        sb.append("lat");
        sb.append('=');
        sb.append(this.lat == null ? "<null>" : this.lat);
        sb.append(',');
        sb.append("lon");
        sb.append('=');
        sb.append(this.lon == null ? "<null>" : this.lon);
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(this.address == null ? "<null>" : this.address);
        sb.append(',');
        sb.append("crossStreet");
        sb.append('=');
        sb.append(this.crossStreet == null ? "<null>" : this.crossStreet);
        sb.append(',');
        sb.append("regionId");
        sb.append('=');
        sb.append(this.regionId == null ? "<null>" : this.regionId);
        sb.append(',');
        sb.append("postCode");
        sb.append('=');
        sb.append(this.postCode == null ? "<null>" : this.postCode);
        sb.append(',');
        sb.append("rentalMethods");
        sb.append('=');
        sb.append(this.rentalMethods == null ? "<null>" : this.rentalMethods);
        sb.append(',');
        sb.append("isVirtualStation");
        sb.append('=');
        sb.append(this.isVirtualStation == null ? "<null>" : this.isVirtualStation);
        sb.append(',');
        sb.append("stationArea");
        sb.append('=');
        sb.append((Object)(this.stationArea == null ? "<null>" : this.stationArea));
        sb.append(',');
        sb.append("capacity");
        sb.append('=');
        sb.append(this.capacity == null ? "<null>" : this.capacity);
        sb.append(',');
        sb.append("vehicleCapacity");
        sb.append('=');
        sb.append(this.vehicleCapacity == null ? "<null>" : this.vehicleCapacity);
        sb.append(',');
        sb.append("isValetStation");
        sb.append('=');
        sb.append(this.isValetStation == null ? "<null>" : this.isValetStation);
        sb.append(',');
        sb.append("rentalUris");
        sb.append('=');
        sb.append(this.rentalUris == null ? "<null>" : this.rentalUris);
        sb.append(',');
        sb.append("vehicleTypeCapacity");
        sb.append('=');
        sb.append(this.vehicleTypeCapacity == null ? "<null>" : this.vehicleTypeCapacity);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.address == null ? 0 : this.address.hashCode());
        result = result * 31 + (this.rentalUris == null ? 0 : this.rentalUris.hashCode());
        result = result * 31 + (this.lon == null ? 0 : this.lon.hashCode());
        result = result * 31 + (this.capacity == null ? 0 : this.capacity.hashCode());
        result = result * 31 + (this.isVirtualStation == null ? 0 : this.isVirtualStation.hashCode());
        result = result * 31 + (this.vehicleCapacity == null ? 0 : this.vehicleCapacity.hashCode());
        result = result * 31 + (this.regionId == null ? 0 : this.regionId.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.postCode == null ? 0 : this.postCode.hashCode());
        result = result * 31 + (this.rentalMethods == null ? 0 : this.rentalMethods.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = result * 31 + (this.crossStreet == null ? 0 : this.crossStreet.hashCode());
        result = result * 31 + (this.vehicleTypeCapacity == null ? 0 : this.vehicleTypeCapacity.hashCode());
        result = result * 31 + (this.lat == null ? 0 : this.lat.hashCode());
        result = result * 31 + (this.stationArea == null ? 0 : this.stationArea.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        result = result * 31 + (this.isValetStation == null ? 0 : this.isValetStation.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSStation)) {
            return false;
        }
        GBFSStation rhs = (GBFSStation)other;
        return (this.address == rhs.address || this.address != null && this.address.equals(rhs.address)) && (this.rentalUris == rhs.rentalUris || this.rentalUris != null && this.rentalUris.equals(rhs.rentalUris)) && (this.lon == rhs.lon || this.lon != null && this.lon.equals(rhs.lon)) && (this.capacity == rhs.capacity || this.capacity != null && this.capacity.equals(rhs.capacity)) && (this.isVirtualStation == rhs.isVirtualStation || this.isVirtualStation != null && this.isVirtualStation.equals(rhs.isVirtualStation)) && (this.vehicleCapacity == rhs.vehicleCapacity || this.vehicleCapacity != null && this.vehicleCapacity.equals(rhs.vehicleCapacity)) && (this.regionId == rhs.regionId || this.regionId != null && this.regionId.equals(rhs.regionId)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.postCode == rhs.postCode || this.postCode != null && this.postCode.equals(rhs.postCode)) && (this.rentalMethods == rhs.rentalMethods || this.rentalMethods != null && this.rentalMethods.equals(rhs.rentalMethods)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.shortName == rhs.shortName || this.shortName != null && this.shortName.equals(rhs.shortName)) && (this.crossStreet == rhs.crossStreet || this.crossStreet != null && this.crossStreet.equals(rhs.crossStreet)) && (this.vehicleTypeCapacity == rhs.vehicleTypeCapacity || this.vehicleTypeCapacity != null && this.vehicleTypeCapacity.equals(rhs.vehicleTypeCapacity)) && (this.lat == rhs.lat || this.lat != null && this.lat.equals(rhs.lat)) && (this.stationArea == rhs.stationArea || this.stationArea != null && this.stationArea.equals((Object)rhs.stationArea)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId)) && (this.isValetStation == rhs.isValetStation || this.isValetStation != null && this.isValetStation.equals(rhs.isValetStation));
    }
}

