/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v3_0.system_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"brand_last_modified", "brand_terms_url", "brand_image_url", "brand_image_url_dark", "color"})
public class GBFSBrandAssets
implements Serializable {
    @JsonProperty(value="brand_last_modified")
    @JsonPropertyDescription(value="Date that indicates the last time any included brand assets were updated (added in v2.3-RC).")
    private String brandLastModified;
    @JsonProperty(value="brand_terms_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the location of a page that defines the license terms of brand icons, colors or other trademark information (added in v2.3-RC).")
    private String brandTermsUrl;
    @JsonProperty(value="brand_image_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the location of a graphic file representing the brand for the service (added in v2.3-RC). ")
    private String brandImageUrl;
    @JsonProperty(value="brand_image_url_dark")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the location of a graphic file representing the brand for the service for use in dark mode (added in v2.3-RC).")
    private String brandImageUrlDark;
    @JsonProperty(value="color")
    @JsonPropertyDescription(value="Color used to represent the brand for the service (added in v2.3-RC)")
    private String color;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 7364569623631319829L;

    @JsonProperty(value="brand_last_modified")
    public String getBrandLastModified() {
        return this.brandLastModified;
    }

    @JsonProperty(value="brand_last_modified")
    public void setBrandLastModified(String brandLastModified) {
        this.brandLastModified = brandLastModified;
    }

    public GBFSBrandAssets withBrandLastModified(String brandLastModified) {
        this.brandLastModified = brandLastModified;
        return this;
    }

    @JsonProperty(value="brand_terms_url")
    public String getBrandTermsUrl() {
        return this.brandTermsUrl;
    }

    @JsonProperty(value="brand_terms_url")
    public void setBrandTermsUrl(String brandTermsUrl) {
        this.brandTermsUrl = brandTermsUrl;
    }

    public GBFSBrandAssets withBrandTermsUrl(String brandTermsUrl) {
        this.brandTermsUrl = brandTermsUrl;
        return this;
    }

    @JsonProperty(value="brand_image_url")
    public String getBrandImageUrl() {
        return this.brandImageUrl;
    }

    @JsonProperty(value="brand_image_url")
    public void setBrandImageUrl(String brandImageUrl) {
        this.brandImageUrl = brandImageUrl;
    }

    public GBFSBrandAssets withBrandImageUrl(String brandImageUrl) {
        this.brandImageUrl = brandImageUrl;
        return this;
    }

    @JsonProperty(value="brand_image_url_dark")
    public String getBrandImageUrlDark() {
        return this.brandImageUrlDark;
    }

    @JsonProperty(value="brand_image_url_dark")
    public void setBrandImageUrlDark(String brandImageUrlDark) {
        this.brandImageUrlDark = brandImageUrlDark;
    }

    public GBFSBrandAssets withBrandImageUrlDark(String brandImageUrlDark) {
        this.brandImageUrlDark = brandImageUrlDark;
        return this;
    }

    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    public void setColor(String color) {
        this.color = color;
    }

    public GBFSBrandAssets withColor(String color) {
        this.color = color;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSBrandAssets withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSBrandAssets.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("brandLastModified");
        sb.append('=');
        sb.append(this.brandLastModified == null ? "<null>" : this.brandLastModified);
        sb.append(',');
        sb.append("brandTermsUrl");
        sb.append('=');
        sb.append(this.brandTermsUrl == null ? "<null>" : this.brandTermsUrl);
        sb.append(',');
        sb.append("brandImageUrl");
        sb.append('=');
        sb.append(this.brandImageUrl == null ? "<null>" : this.brandImageUrl);
        sb.append(',');
        sb.append("brandImageUrlDark");
        sb.append('=');
        sb.append(this.brandImageUrlDark == null ? "<null>" : this.brandImageUrlDark);
        sb.append(',');
        sb.append("color");
        sb.append('=');
        sb.append(this.color == null ? "<null>" : this.color);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.brandImageUrlDark == null ? 0 : this.brandImageUrlDark.hashCode());
        result = result * 31 + (this.brandTermsUrl == null ? 0 : this.brandTermsUrl.hashCode());
        result = result * 31 + (this.color == null ? 0 : this.color.hashCode());
        result = result * 31 + (this.brandImageUrl == null ? 0 : this.brandImageUrl.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.brandLastModified == null ? 0 : this.brandLastModified.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSBrandAssets)) {
            return false;
        }
        GBFSBrandAssets rhs = (GBFSBrandAssets)other;
        return (this.brandImageUrlDark == rhs.brandImageUrlDark || this.brandImageUrlDark != null && this.brandImageUrlDark.equals(rhs.brandImageUrlDark)) && (this.brandTermsUrl == rhs.brandTermsUrl || this.brandTermsUrl != null && this.brandTermsUrl.equals(rhs.brandTermsUrl)) && (this.color == rhs.color || this.color != null && this.color.equals(rhs.color)) && (this.brandImageUrl == rhs.brandImageUrl || this.brandImageUrl != null && this.brandImageUrl.equals(rhs.brandImageUrl)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.brandLastModified == rhs.brandLastModified || this.brandLastModified != null && this.brandLastModified.equals(rhs.brandLastModified));
    }
}

