/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v3_0.station_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geojson.MultiPolygon;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSName;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSRentalUris;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSShortName;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSVehicleDocksCapacity;
import org.mobilitydata.gbfs.v3_0.station_information.GBFSVehicleTypesCapacity;
import org.mobilitydata.gbfs.v3_0.station_information.RentalMethod;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"station_id", "name", "short_name", "lat", "lon", "address", "cross_street", "region_id", "post_code", "station_opening_hours", "rental_methods", "is_virtual_station", "station_area", "parking_type", "parking_hoop", "contact_phone", "capacity", "vehicle_types_capacity", "vehicle_docks_capacity", "is_valet_station", "is_charging_station", "rental_uris"})
public class GBFSStation
implements Serializable {
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier of a station.")
    private String stationId;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Public name of the station.")
    private List<GBFSName> name;
    @JsonProperty(value="short_name")
    @JsonPropertyDescription(value="Short name or other type of identifier.")
    private List<GBFSShortName> shortName;
    @JsonProperty(value="lat")
    @JsonPropertyDescription(value="The latitude of the station.")
    private Double lat;
    @JsonProperty(value="lon")
    @JsonPropertyDescription(value="The longitude fo the station.")
    private Double lon;
    @JsonProperty(value="address")
    @JsonPropertyDescription(value="Address where station is located.")
    private String address;
    @JsonProperty(value="cross_street")
    @JsonPropertyDescription(value="Cross street or landmark where the station is located.")
    private String crossStreet;
    @JsonProperty(value="region_id")
    @JsonPropertyDescription(value="Identifier of the region where the station is located.")
    private String regionId;
    @JsonProperty(value="post_code")
    @JsonPropertyDescription(value="Postal code where station is located.")
    private String postCode;
    @JsonProperty(value="station_opening_hours")
    @JsonPropertyDescription(value="Hours of operation for the station in OSM opening_hours format.")
    private String stationOpeningHours;
    @JsonProperty(value="rental_methods")
    @JsonPropertyDescription(value="Payment methods accepted at this station.")
    private List<RentalMethod> rentalMethods;
    @JsonProperty(value="is_virtual_station")
    @JsonPropertyDescription(value="Is this station a location with or without physical infrastructure? (added in v2.1-RC)")
    private Boolean isVirtualStation;
    @JsonProperty(value="station_area")
    @JsonPropertyDescription(value="A multipolygon that describes the area of a virtual station (added in v2.1-RC).")
    private MultiPolygon stationArea;
    @JsonProperty(value="parking_type")
    @JsonPropertyDescription(value="Type of parking station. Added in v2.3")
    private ParkingType parkingType;
    @JsonProperty(value="parking_hoop")
    @JsonPropertyDescription(value="Are parking hoops present at this station? Added in v2.3")
    private Boolean parkingHoop;
    @JsonProperty(value="contact_phone")
    @JsonPropertyDescription(value="Contact phone of the station. Added in v2.3")
    private String contactPhone;
    @JsonProperty(value="capacity")
    @JsonPropertyDescription(value="Number of total docking points installed at this station, both available and unavailable.")
    private Integer capacity;
    @JsonProperty(value="vehicle_types_capacity")
    @JsonPropertyDescription(value="This field's value is an array of objects containing the keys vehicle_type_ids and count defined below. These objects are used to model the parking capacity of virtual stations (defined using the is_virtual_station field) for each vehicle type that can be returned to this station.")
    private List<GBFSVehicleTypesCapacity> vehicleTypesCapacity;
    @JsonProperty(value="vehicle_docks_capacity")
    @JsonPropertyDescription(value="This field's value is an array of objects containing the keys vehicle_type_ids and count defined below. These objects are used to model the total docking capacity of a station, both available and unavailable, for each type of vehicle that may dock at this station.")
    private List<GBFSVehicleDocksCapacity> vehicleDocksCapacity;
    @JsonProperty(value="is_valet_station")
    @JsonPropertyDescription(value="Are valet services provided at this station? (added in v2.1-RC)")
    private Boolean isValetStation;
    @JsonProperty(value="is_charging_station")
    @JsonPropertyDescription(value="Does the station support charging of electric vehicles? (added in v2.3-RC)")
    private Boolean isChargingStation;
    @JsonProperty(value="rental_uris")
    @JsonPropertyDescription(value="Contains rental uris for Android, iOS, and web in the android, ios, and web fields (added in v1.1).")
    private GBFSRentalUris rentalUris;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 5101169017677249996L;

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public GBFSStation withStationId(String stationId) {
        this.stationId = stationId;
        return this;
    }

    @JsonProperty(value="name")
    public List<GBFSName> getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(List<GBFSName> name) {
        this.name = name;
    }

    public GBFSStation withName(List<GBFSName> name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="short_name")
    public List<GBFSShortName> getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName(List<GBFSShortName> shortName) {
        this.shortName = shortName;
    }

    public GBFSStation withShortName(List<GBFSShortName> shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty(value="lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty(value="lat")
    public void setLat(Double lat) {
        this.lat = lat;
    }

    public GBFSStation withLat(Double lat) {
        this.lat = lat;
        return this;
    }

    @JsonProperty(value="lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty(value="lon")
    public void setLon(Double lon) {
        this.lon = lon;
    }

    public GBFSStation withLon(Double lon) {
        this.lon = lon;
        return this;
    }

    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(String address) {
        this.address = address;
    }

    public GBFSStation withAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="cross_street")
    public String getCrossStreet() {
        return this.crossStreet;
    }

    @JsonProperty(value="cross_street")
    public void setCrossStreet(String crossStreet) {
        this.crossStreet = crossStreet;
    }

    public GBFSStation withCrossStreet(String crossStreet) {
        this.crossStreet = crossStreet;
        return this;
    }

    @JsonProperty(value="region_id")
    public String getRegionId() {
        return this.regionId;
    }

    @JsonProperty(value="region_id")
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public GBFSStation withRegionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    @JsonProperty(value="post_code")
    public String getPostCode() {
        return this.postCode;
    }

    @JsonProperty(value="post_code")
    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public GBFSStation withPostCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @JsonProperty(value="station_opening_hours")
    public String getStationOpeningHours() {
        return this.stationOpeningHours;
    }

    @JsonProperty(value="station_opening_hours")
    public void setStationOpeningHours(String stationOpeningHours) {
        this.stationOpeningHours = stationOpeningHours;
    }

    public GBFSStation withStationOpeningHours(String stationOpeningHours) {
        this.stationOpeningHours = stationOpeningHours;
        return this;
    }

    @JsonProperty(value="rental_methods")
    public List<RentalMethod> getRentalMethods() {
        return this.rentalMethods;
    }

    @JsonProperty(value="rental_methods")
    public void setRentalMethods(List<RentalMethod> rentalMethods) {
        this.rentalMethods = rentalMethods;
    }

    public GBFSStation withRentalMethods(List<RentalMethod> rentalMethods) {
        this.rentalMethods = rentalMethods;
        return this;
    }

    @JsonProperty(value="is_virtual_station")
    public Boolean getIsVirtualStation() {
        return this.isVirtualStation;
    }

    @JsonProperty(value="is_virtual_station")
    public void setIsVirtualStation(Boolean isVirtualStation) {
        this.isVirtualStation = isVirtualStation;
    }

    public GBFSStation withIsVirtualStation(Boolean isVirtualStation) {
        this.isVirtualStation = isVirtualStation;
        return this;
    }

    @JsonProperty(value="station_area")
    public MultiPolygon getStationArea() {
        return this.stationArea;
    }

    @JsonProperty(value="station_area")
    public void setStationArea(MultiPolygon stationArea) {
        this.stationArea = stationArea;
    }

    public GBFSStation withStationArea(MultiPolygon stationArea) {
        this.stationArea = stationArea;
        return this;
    }

    @JsonProperty(value="parking_type")
    public ParkingType getParkingType() {
        return this.parkingType;
    }

    @JsonProperty(value="parking_type")
    public void setParkingType(ParkingType parkingType) {
        this.parkingType = parkingType;
    }

    public GBFSStation withParkingType(ParkingType parkingType) {
        this.parkingType = parkingType;
        return this;
    }

    @JsonProperty(value="parking_hoop")
    public Boolean getParkingHoop() {
        return this.parkingHoop;
    }

    @JsonProperty(value="parking_hoop")
    public void setParkingHoop(Boolean parkingHoop) {
        this.parkingHoop = parkingHoop;
    }

    public GBFSStation withParkingHoop(Boolean parkingHoop) {
        this.parkingHoop = parkingHoop;
        return this;
    }

    @JsonProperty(value="contact_phone")
    public String getContactPhone() {
        return this.contactPhone;
    }

    @JsonProperty(value="contact_phone")
    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public GBFSStation withContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
        return this;
    }

    @JsonProperty(value="capacity")
    public Integer getCapacity() {
        return this.capacity;
    }

    @JsonProperty(value="capacity")
    public void setCapacity(Integer capacity) {
        this.capacity = capacity;
    }

    public GBFSStation withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    @JsonProperty(value="vehicle_types_capacity")
    public List<GBFSVehicleTypesCapacity> getVehicleTypesCapacity() {
        return this.vehicleTypesCapacity;
    }

    @JsonProperty(value="vehicle_types_capacity")
    public void setVehicleTypesCapacity(List<GBFSVehicleTypesCapacity> vehicleTypesCapacity) {
        this.vehicleTypesCapacity = vehicleTypesCapacity;
    }

    public GBFSStation withVehicleTypesCapacity(List<GBFSVehicleTypesCapacity> vehicleTypesCapacity) {
        this.vehicleTypesCapacity = vehicleTypesCapacity;
        return this;
    }

    @JsonProperty(value="vehicle_docks_capacity")
    public List<GBFSVehicleDocksCapacity> getVehicleDocksCapacity() {
        return this.vehicleDocksCapacity;
    }

    @JsonProperty(value="vehicle_docks_capacity")
    public void setVehicleDocksCapacity(List<GBFSVehicleDocksCapacity> vehicleDocksCapacity) {
        this.vehicleDocksCapacity = vehicleDocksCapacity;
    }

    public GBFSStation withVehicleDocksCapacity(List<GBFSVehicleDocksCapacity> vehicleDocksCapacity) {
        this.vehicleDocksCapacity = vehicleDocksCapacity;
        return this;
    }

    @JsonProperty(value="is_valet_station")
    public Boolean getIsValetStation() {
        return this.isValetStation;
    }

    @JsonProperty(value="is_valet_station")
    public void setIsValetStation(Boolean isValetStation) {
        this.isValetStation = isValetStation;
    }

    public GBFSStation withIsValetStation(Boolean isValetStation) {
        this.isValetStation = isValetStation;
        return this;
    }

    @JsonProperty(value="is_charging_station")
    public Boolean getIsChargingStation() {
        return this.isChargingStation;
    }

    @JsonProperty(value="is_charging_station")
    public void setIsChargingStation(Boolean isChargingStation) {
        this.isChargingStation = isChargingStation;
    }

    public GBFSStation withIsChargingStation(Boolean isChargingStation) {
        this.isChargingStation = isChargingStation;
        return this;
    }

    @JsonProperty(value="rental_uris")
    public GBFSRentalUris getRentalUris() {
        return this.rentalUris;
    }

    @JsonProperty(value="rental_uris")
    public void setRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
    }

    public GBFSStation withRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSStation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSStation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(this.shortName == null ? "<null>" : this.shortName);
        sb.append(',');
        sb.append("lat");
        sb.append('=');
        sb.append(this.lat == null ? "<null>" : this.lat);
        sb.append(',');
        sb.append("lon");
        sb.append('=');
        sb.append(this.lon == null ? "<null>" : this.lon);
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(this.address == null ? "<null>" : this.address);
        sb.append(',');
        sb.append("crossStreet");
        sb.append('=');
        sb.append(this.crossStreet == null ? "<null>" : this.crossStreet);
        sb.append(',');
        sb.append("regionId");
        sb.append('=');
        sb.append(this.regionId == null ? "<null>" : this.regionId);
        sb.append(',');
        sb.append("postCode");
        sb.append('=');
        sb.append(this.postCode == null ? "<null>" : this.postCode);
        sb.append(',');
        sb.append("stationOpeningHours");
        sb.append('=');
        sb.append(this.stationOpeningHours == null ? "<null>" : this.stationOpeningHours);
        sb.append(',');
        sb.append("rentalMethods");
        sb.append('=');
        sb.append(this.rentalMethods == null ? "<null>" : this.rentalMethods);
        sb.append(',');
        sb.append("isVirtualStation");
        sb.append('=');
        sb.append(this.isVirtualStation == null ? "<null>" : this.isVirtualStation);
        sb.append(',');
        sb.append("stationArea");
        sb.append('=');
        sb.append((Object)(this.stationArea == null ? "<null>" : this.stationArea));
        sb.append(',');
        sb.append("parkingType");
        sb.append('=');
        sb.append(this.parkingType == null ? "<null>" : this.parkingType);
        sb.append(',');
        sb.append("parkingHoop");
        sb.append('=');
        sb.append(this.parkingHoop == null ? "<null>" : this.parkingHoop);
        sb.append(',');
        sb.append("contactPhone");
        sb.append('=');
        sb.append(this.contactPhone == null ? "<null>" : this.contactPhone);
        sb.append(',');
        sb.append("capacity");
        sb.append('=');
        sb.append(this.capacity == null ? "<null>" : this.capacity);
        sb.append(',');
        sb.append("vehicleTypesCapacity");
        sb.append('=');
        sb.append(this.vehicleTypesCapacity == null ? "<null>" : this.vehicleTypesCapacity);
        sb.append(',');
        sb.append("vehicleDocksCapacity");
        sb.append('=');
        sb.append(this.vehicleDocksCapacity == null ? "<null>" : this.vehicleDocksCapacity);
        sb.append(',');
        sb.append("isValetStation");
        sb.append('=');
        sb.append(this.isValetStation == null ? "<null>" : this.isValetStation);
        sb.append(',');
        sb.append("isChargingStation");
        sb.append('=');
        sb.append(this.isChargingStation == null ? "<null>" : this.isChargingStation);
        sb.append(',');
        sb.append("rentalUris");
        sb.append('=');
        sb.append(this.rentalUris == null ? "<null>" : this.rentalUris);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.parkingType == null ? 0 : this.parkingType.hashCode());
        result = result * 31 + (this.vehicleTypesCapacity == null ? 0 : this.vehicleTypesCapacity.hashCode());
        result = result * 31 + (this.address == null ? 0 : this.address.hashCode());
        result = result * 31 + (this.stationOpeningHours == null ? 0 : this.stationOpeningHours.hashCode());
        result = result * 31 + (this.rentalUris == null ? 0 : this.rentalUris.hashCode());
        result = result * 31 + (this.lon == null ? 0 : this.lon.hashCode());
        result = result * 31 + (this.parkingHoop == null ? 0 : this.parkingHoop.hashCode());
        result = result * 31 + (this.vehicleDocksCapacity == null ? 0 : this.vehicleDocksCapacity.hashCode());
        result = result * 31 + (this.capacity == null ? 0 : this.capacity.hashCode());
        result = result * 31 + (this.isVirtualStation == null ? 0 : this.isVirtualStation.hashCode());
        result = result * 31 + (this.regionId == null ? 0 : this.regionId.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.postCode == null ? 0 : this.postCode.hashCode());
        result = result * 31 + (this.isChargingStation == null ? 0 : this.isChargingStation.hashCode());
        result = result * 31 + (this.rentalMethods == null ? 0 : this.rentalMethods.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = result * 31 + (this.crossStreet == null ? 0 : this.crossStreet.hashCode());
        result = result * 31 + (this.contactPhone == null ? 0 : this.contactPhone.hashCode());
        result = result * 31 + (this.lat == null ? 0 : this.lat.hashCode());
        result = result * 31 + (this.stationArea == null ? 0 : this.stationArea.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        result = result * 31 + (this.isValetStation == null ? 0 : this.isValetStation.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSStation)) {
            return false;
        }
        GBFSStation rhs = (GBFSStation)other;
        return (this.parkingType == rhs.parkingType || this.parkingType != null && this.parkingType.equals((Object)rhs.parkingType)) && (this.vehicleTypesCapacity == rhs.vehicleTypesCapacity || this.vehicleTypesCapacity != null && this.vehicleTypesCapacity.equals(rhs.vehicleTypesCapacity)) && (this.address == rhs.address || this.address != null && this.address.equals(rhs.address)) && (this.stationOpeningHours == rhs.stationOpeningHours || this.stationOpeningHours != null && this.stationOpeningHours.equals(rhs.stationOpeningHours)) && (this.rentalUris == rhs.rentalUris || this.rentalUris != null && this.rentalUris.equals(rhs.rentalUris)) && (this.lon == rhs.lon || this.lon != null && this.lon.equals(rhs.lon)) && (this.parkingHoop == rhs.parkingHoop || this.parkingHoop != null && this.parkingHoop.equals(rhs.parkingHoop)) && (this.vehicleDocksCapacity == rhs.vehicleDocksCapacity || this.vehicleDocksCapacity != null && this.vehicleDocksCapacity.equals(rhs.vehicleDocksCapacity)) && (this.capacity == rhs.capacity || this.capacity != null && this.capacity.equals(rhs.capacity)) && (this.isVirtualStation == rhs.isVirtualStation || this.isVirtualStation != null && this.isVirtualStation.equals(rhs.isVirtualStation)) && (this.regionId == rhs.regionId || this.regionId != null && this.regionId.equals(rhs.regionId)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.postCode == rhs.postCode || this.postCode != null && this.postCode.equals(rhs.postCode)) && (this.isChargingStation == rhs.isChargingStation || this.isChargingStation != null && this.isChargingStation.equals(rhs.isChargingStation)) && (this.rentalMethods == rhs.rentalMethods || this.rentalMethods != null && this.rentalMethods.equals(rhs.rentalMethods)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.shortName == rhs.shortName || this.shortName != null && this.shortName.equals(rhs.shortName)) && (this.crossStreet == rhs.crossStreet || this.crossStreet != null && this.crossStreet.equals(rhs.crossStreet)) && (this.contactPhone == rhs.contactPhone || this.contactPhone != null && this.contactPhone.equals(rhs.contactPhone)) && (this.lat == rhs.lat || this.lat != null && this.lat.equals(rhs.lat)) && (this.stationArea == rhs.stationArea || this.stationArea != null && this.stationArea.equals((Object)rhs.stationArea)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId)) && (this.isValetStation == rhs.isValetStation || this.isValetStation != null && this.isValetStation.equals(rhs.isValetStation));
    }

    public static enum ParkingType {
        PARKING_LOT("parking_lot"),
        STREET_PARKING("street_parking"),
        UNDERGROUND_PARKING("underground_parking"),
        SIDEWALK_PARKING("sidewalk_parking"),
        OTHER("other");

        private final String value;
        private static final Map<String, ParkingType> CONSTANTS;

        private ParkingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ParkingType fromValue(String value) {
            ParkingType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ParkingType>();
            for (ParkingType c : ParkingType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

