/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xcap.client.uri;

import org.mobicents.xcap.client.uri.encoding.UriComponentEncoder;

public class ElementSelectorBuilder {
    private final StringBuilder elementSelectorSteps = new StringBuilder();
    private static final char SEPARATOR = '/';

    public ElementSelectorBuilder appendStepByName(String name) {
        this.elementSelectorSteps.append('/');
        this.elementSelectorSteps.append(name);
        return this;
    }

    public ElementSelectorBuilder appendStepByAttr(String name, String attrName, String attrValue) {
        this.elementSelectorSteps.append('/');
        this.elementSelectorSteps.append(name).append("[@").append(attrName).append("=\"").append(attrValue).append("\"]");
        return this;
    }

    public ElementSelectorBuilder appendStepByPos(String name, int pos) {
        this.elementSelectorSteps.append('/');
        this.elementSelectorSteps.append(name).append('[').append(pos).append(']');
        return this;
    }

    public ElementSelectorBuilder appendStepByPosAttr(String name, int pos, String attrName, String attrValue) {
        this.elementSelectorSteps.append('/');
        this.elementSelectorSteps.append(name).append('[').append(pos).append("][@").append(attrName).append("=\"").append(attrValue).append("\"]");
        return this;
    }

    public String toString() {
        return this.elementSelectorSteps.toString();
    }

    public String toPercentEncodedString() {
        return UriComponentEncoder.encodePath(this.toString());
    }
}

