/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.xcap.client.uri;

import org.mobicents.xcap.client.uri.enconding.UriComponentEncoder;

public class DocumentSelectorBuilder {
    private static final char PATH_SEPARATOR = '/';
    private static final String USER_DOC_PARENT = "users";
    private static final String GLOBAL_DOC_PARENT = "global";
    private final StringBuilder documentSelector = new StringBuilder();

    public DocumentSelectorBuilder appendPathSegment(String pathSegment) {
        this.documentSelector.append('/');
        this.documentSelector.append(pathSegment);
        return this;
    }

    public static DocumentSelectorBuilder getUserDocumentSelectorBuilder(String auid, String user, String documentName) {
        return new DocumentSelectorBuilder().appendPathSegment(auid).appendPathSegment(USER_DOC_PARENT).appendPathSegment(user).appendPathSegment(documentName);
    }

    public static DocumentSelectorBuilder getGlobalDocumentSelectorBuilder(String auid, String documentName) {
        return new DocumentSelectorBuilder().appendPathSegment(auid).appendPathSegment(GLOBAL_DOC_PARENT).appendPathSegment(documentName);
    }

    public String toString() {
        return this.documentSelector.toString();
    }

    public String toPercentEncodedString() {
        return UriComponentEncoder.encodeQuery(this.toString());
    }
}

