/* jslint node: true, browser: true */
/* global angular: true */

'use strict';

// Declare app level module which depends on views, and components
var olyMod = angular.module('mcWebRTC', [
  'ngRoute',
  'ngResource',
  'ngAnimate',
  //'ui.bootstrap.dropdown',
  'mgcrea.ngStrap.tooltip',
  'mgcrea.ngStrap.popover',
  'mgcrea.ngStrap.dropdown',
  'mgcrea.ngStrap.alert',
  'webcam',
  'angularMoment',
  'ngEmoticons',
  'FBAngular',
  'mcWebRTC.filters',
  'mcWebRTC.services',
  'mcWebRTC.directives',
  'mcWebRTC.controllers'
]);

olyMod.config(['$routeProvider', /*'$locationProvider',*/ function($routeProvider, $locationProvider) {
  $routeProvider.
    when('/', {templateUrl: 'modules/sign-in.html', controller: 'SignInCtrl'}).
    when('/home', {templateUrl: 'modules/home.html', controller: 'HomeCtrl'}).
    otherwise({redirectTo: '/'});
}]);
angular.module('mcWebRTC').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('modules/home.html',
    "<div id=\"wrapper\">\n" +
    "\n" +
    "  <!-- Sidebar -->\n" +
    "  <div id=\"sidebar-wrapper\">\n" +
    "    <ul class=\"sidebar-nav\">\n" +
    "\n" +
    "      <div id=\"company-logo\">\n" +
    "        <img src=\"resources/images/v2/restcomm-web-rtc-demo-logo.svg\" style=\"margin: -5px -15px 10px; width: 285px;\">\n" +
    "        <span class=\"pull-right version-banner\" style=\"margin-right: 12px; margin-top: -14px;\">v{{ clientVersion }}</span>\n" +
    "      </div>\n" +
    "\n" +
    "      <div class=\"user-avatar\" ng-class=\"imAlive ? 'user-online' : 'user-offline'\" ng-show=\"!contact.icon\" title=\"{{ imAlive ? 'Online' : 'Connectivity Issues' }}\">\n" +
    "        <div>\n" +
    "          {{ loggedUser | limitTo : 1 | uppercase }}\n" +
    "        </div>\n" +
    "      </div>\n" +
    "      <h4 id=\"user-name\">{{ loggedUser }}\n" +
    "        <a href=\"\" ng-click=\"signOut()\" title=\"Sign Out\">\n" +
    "          <i class=\"fa fa-sign-out\" style=\"font-size: 17px; margin-left: 10px;\"></i>\n" +
    "        </a>\n" +
    "      </h4>\n" +
    "      <div class=\"nav-menu\" id=\"icons-settings\">\n" +
    "        <a href=\"\" class=\"action-disabled\" style=\"margin-left: 10px;\"><img src=\"resources/images/v2/mp-icon-profile.png\"></a>\n" +
    "        <a href=\"\" class=\"action-disabled\"><img src=\"resources/images/v2/mp-icon-preferences.png\"></a>\n" +
    "        <a href=\"\" class=\"action-disabled\"><img src=\"resources/images/v2/mp-icon-mentions.png\"></a>\n" +
    "        <a href=\"\" class=\"action-disabled\"><img src=\"resources/images/v2/mp-icon-favorites.png\"></a>\n" +
    "        <a href=\"\" class=\"action-disabled\"><img src=\"resources/images/v2/mp-icon-files.png\"></a>\n" +
    "        <a href=\"\" ng-click=\"!editingContact && toggleSidebar('addContact')\" title=\"Add Contact\"><img src=\"resources/images/v2/mp-icon-add.png\"></a>\n" +
    "      </div>\n" +
    "\n" +
    "      <div class=\"sidebar-brand\">\n" +
    "        <a href=\"\" ng-click=\"hideContacts = !hideContacts\">Contacts <span class=\"pull-right\" ng-show=\"hideContacts\">+</span><span class=\"pull-right\" ng-show=\"!hideContacts\">-</span></a>\n" +
    "      </div>\n" +
    "\n" +
    "      <div id=\"sidebar-content\" ng-class=\"{ 'in-action': sidebarAction }\">\n" +
    "        <div class=\"sidebar-rooms\" ng-show=\"!sidebarAction && hasRooms\">\n" +
    "          <li class=\"sidebar-brand\">\n" +
    "            <a href=\"\">\n" +
    "              Rooms  <span class=\"pull-right\">+</span>\n" +
    "            </a>\n" +
    "          </li>\n" +
    "\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-1\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">documentation</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-2\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">marketing</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-3\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">general</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-4\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <img id=\"badge\" src=\"resources/images/v2/mp-badge.png\">\n" +
    "            <a href=\"\">restcomm - SDKs</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-5\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">design</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-6\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">sales</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-7\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">random</a>\n" +
    "          </li>\n" +
    "          <li>\n" +
    "            <img id=\"room-icon-8\" class=\"room-icon\" src=\"resources/images/v2/mp-icon-rooms.png\">\n" +
    "            <a href=\"\">core</a>\n" +
    "          </li>\n" +
    "        </div>\n" +
    "\n" +
    "        <div class=\"sidebar-contacts\" ng-show=\"!sidebarAction && hasContacts\">\n" +
    "          <li class=\"contact-container\" ng-repeat=\"contact in contacts\" ng-click=\"selectContact(contact)\" ng-hide=\"hideContacts\" ng-class=\"{selected: ac.address === contact.address}\">\n" +
    "            <div class=\"contact-avatar clickable\" style=\"{{ contact.icon ? '' : ('background-color: ' + getChatColor(contact.address)) + ';' }}\">\n" +
    "              <div ng-show=\"!contact.icon\">\n" +
    "                {{ contact.name | limitTo : 1 | uppercase }}\n" +
    "              </div>\n" +
    "              <i class=\"fa fa-{{ contact.icon }}\" id=\"contact-icon-{{ contact.id }}\" ng-if =\"!contact.photo && contact.icon\" />\n" +
    "            </div>\n" +
    "\n" +
    "            <span class=\"contact-chat-unread-min label label-danger\" ng-show=\"activeChats[contact.id].unread > 0\">{{ activeChats[contact.id].unread }}</span>\n" +
    "            <div class=\"contact-space\">\n" +
    "              <div id=\"contact-space-{{ contact.id }}\">\n" +
    "                <i class=\"fa fa-phone\" style=\"text-indent: 0; margin-left: -18px;\" ng-show=\"(inCall.incomingCallFlag && inCall.callerPhoneNumber === contact.id) || (!inCall.incomingCallFlag && inCall.calleePhoneNumber === contact.address)\"></i>\n" +
    "                {{ contact.name }}\n" +
    "                <span class=\"contact-chat-unread label label-danger\" ng-show=\"activeChats[contact.id].unread > 0\">{{ activeChats[contact.id].unread }}</span>\n" +
    "                <br>\n" +
    "                <div class=\"contact-info\">{{ contact.address }} <a href=\"\" class=\"edit-contact pull-right\" ng-click=\"editContact(contact)\"><i class=\"fa fa-pencil\"></i></a></div>\n" +
    "              </div>\n" +
    "            </div>\n" +
    "          </li>\n" +
    "        </div>\n" +
    "\n" +
    "        <div class=\"sidebar-add-contact\" ng-show=\"sidebarAction === 'addContact'\">\n" +
    "          <h4 class=\"sidebar-action-title\">{{ editingContact ? \"Edit\" : \"Add\" }} Contact</h4>\n" +
    "          <hr>\n" +
    "          <form name=\"addContactForm\">\n" +
    "            <input name =\"ncName\" type=\"text\" class=\"sidebar-input\" placeholder=\"Contact Name\" ng-model=\"newContact.name\">\n" +
    "            <input name =\"ncAddress\" type=\"text\" class=\"sidebar-input\" placeholder=\"Contact Address\" ng-model=\"newContact.address\" required>\n" +
    "            <div class=\"sidebar-action-error\" ng-show=\"addContactForm.ncAddress.$dirty && duplicateContact\">The contact already exists</div>\n" +
    "            <div class=\"sidebar-action-error\" ng-show=\"addContactForm.ncAddress.$dirty && addContactForm.ncAddress.$error.required\">The address is required</div>\n" +
    "            <button type=\"button\" class=\"btn btn-default pull-right sidebar-action-button\" ng-click=\"addContact()\" ng-hide=\"editingContact\" ng-disabled=\"duplicateContact || !addContactForm.$valid\">Add Contact</button>\n" +
    "            <button type=\"button\" class=\"btn btn-default pull-right sidebar-action-button\" ng-click=\"saveEditContact()\" ng-show=\"editingContact\" ng-disabled=\"(addContactForm.ncName.$pristine && addContactForm.ncAddress.$pristine) || duplicateContact || !addContactForm.$valid\">Save Changes</button>\n" +
    "            <button type=\"button\" class=\"btn btn-default pull-right sidebar-action-button\" ng-click=\"cancelEditContact()\">Cancel</button>\n" +
    "            <button type=\"button\" class=\"btn btn-danger pull-right sidebar-action-button\" ng-click=\"preDeleteContact(curContact)\" ng-show=\"editingContact\"><i class=\"fa fa-trash\"></i></button>\n" +
    "            <button type=\"button\" class=\"btn btn-danger pull-right sidebar-action-button\" ng-click=\"deleteContact(curContact)\" ng-show=\"curContact.deleteConfirm\">Confirm Delete</button>\n" +
    "          </form>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "    </ul>\n" +
    "  </div>\n" +
    "  <!-- /#sidebar-wrapper -->\n" +
    "\n" +
    "  <!-- Page Content -->\n" +
    "  <a href=\"\"><img id=\"expand-chat\" src=\"resources/images/v2/mp-arrow-onchat.png\" ng-show=\"ac\"></a>\n" +
    "\n" +
    "  <div id=\"incoming-call\" class=\"incoming-call-wrapper\" ng-show=\"inCall && !inCall.hasRemoteVideo && ac === inCall.contact\">\n" +
    "    <h5 id=\"incoming-call-message\" ng-show=\"inCall.incomingCallFlag && inCall.intStatus !== 'ESTABLISHED'\">Incoming {{ inCall.isVideo ? 'Video' : 'Audio' }} Call</h5>\n" +
    "    <h5 id=\"incoming-call-message\" ng-show=\"inCall && inCall.intStatus === 'ESTABLISHED'\">{{ inCall.contact.name }}</h5>\n" +
    "    <h5 id=\"incoming-call-message\" ng-show=\"inCall && inCall.intStatus !== 'ESTABLISHED' && !inCall.incomingCallFlag\">Calling {{ inCall.contact.name }}</h5>\n" +
    "    <i class=\"fa fa-{{ inCall.contact.icon || 'user-o' }} inc-call-icon\" ng-show=\"!inCall.contact.photo\"></i>\n" +
    "    <img id=\"photo-call\" ng-src=\"resources/images/v2/{{ inCall.contact.photo || 'mp-icon-profile.png' }}\" ng-show=\"inCall.contact.photo\">\n" +
    "    <h5 id=\"name-participant\" ng-show=\"inCall.incomingCallFlag && inCall.intStatus !== 'ESTABLISHED'\">{{ inCall.contact.name }}</h5>\n" +
    "    <h5 id=\"name-participant\" ng-show=\"inCall && inCall.intStatus !== 'ESTABLISHED'\">{{ inCall.intStatus }}</h5>\n" +
    "    <div class=\"incoming-call-actions\" ng-hide=\"inCall.intStatus === 'ESTABLISHED'\">\n" +
    "      <div class=\"incoming-call-action\" ng-show=\"inCall && inCall.isVideo\">\n" +
    "        <a href=\"\" ng-click=\"acceptCall(true)\"><img src=\"resources/images/v2/answer-video-call.png\"></a>\n" +
    "      </div>\n" +
    "      <div class=\"incoming-call-action\" ng-class=\"{'audio-only': !inCall.isVideo}\" ng-show=\"inCall && inCall.incomingCallFlag\">\n" +
    "        <a href=\"\" ng-click=\"acceptCall(false)\"><img src=\"resources/images/v2/answer-audio-call.png\"></a>\n" +
    "      </div>\n" +
    "      <div class=\"incoming-call-action\" ng-class=\"{'audio-only': !inCall.isVideo}\" ng-show=\"inCall && inCall.incomingCallFlag\">\n" +
    "        <a href=\"\" ng-click=\"rejectCall()\"><img src=\"resources/images/v2/decline-call.png\"></a>\n" +
    "      </div>\n" +
    "      <div class=\"incoming-call-action\" style=\"width: 90%;\" ng-show=\"inCall && inCall.intStatus !== 'ESTABLISHED' && !inCall.incomingCallFlag\">\n" +
    "        <a href=\"\" ng-click=\"callHangup()\"><img src=\"resources/images/v2/decline-call.png\"></a>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div class=\"incoming-call-actions\" ng-hide=\"inCall.intStatus === 'ESTABLISHED'\">\n" +
    "      <div class=\"incoming-call-action\" ng-show=\"inCall && inCall.incomingCallFlag && inCall.isVideo\">VIDEO</div>\n" +
    "      <div class=\"incoming-call-action\" ng-class=\"{'audio-only': !inCall.isVideo}\" ng-show=\"inCall && inCall.incomingCallFlag\">AUDIO</div>\n" +
    "      <div class=\"incoming-call-action\" ng-class=\"{'audio-only': !inCall.isVideo}\" ng-show=\"inCall && inCall.incomingCallFlag\">REJECT</div>\n" +
    "      <div class=\"incoming-call-action\" ng-show=\"inCall && inCall.intStatus !== 'ESTABLISHED' && !inCall.incomingCallFlag\" style=\"width: 90%;\">CANCEL</div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div id=\"chat-video-aeria\" class=\"animated\" ng-class=\"videoClass\" ng-show=\"ac\">\n" +
    "    <div id=\"add-participant\" class=\"add-participant\" ng-show=\"false\">\n" +
    "      <img src=\"resources/images/v2/mp-icon-add-participant-chat.png\">\n" +
    "    </div>\n" +
    "\n" +
    "    <h3 id=\"current-call\">Chat with {{ ac.name }} <i ng-show=\"false\" class=\"fa fa-chevron-down\" style=\"font-size: 14px; vertical-align: 3px;\"></i></h3>\n" +
    "\n" +
    "    <div class=\"border-separator\"></div>\n" +
    "\n" +
    "    <div id=\"videos\" class=\"no-select\" ng-show=\"remoteVideo && (ac.id === inCall.callerPhoneNumber || ac.address === inCall.calleePhoneNumber)\" fullscreen=\"remoteVideo && fsVideo\">\n" +
    "      <div id=\"big-video\">\n" +
    "        <div class=\"video-controls-top\">\n" +
    "          {{ inCall.callTimer | secondsToTime:true }}\n" +
    "          <div style=\"float: right;\">\n" +
    "            <i class=\"fa fa-th\" ng-click=\"toggleKeypad()\"></i>\n" +
    "            <i class=\"fa fa-television\"></i>\n" +
    "            <i class=\"fa fa-cog\"></i>\n" +
    "            <a href=\"\" ng-click=\"toggleFullScreen()\"><i class=\"fa fa-expand\"></i></a>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div id=\"keypad\" class=\"keypad\" ng-show=\"showKeypad\">\n" +
    "          <table>\n" +
    "            <tr>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF1\" ng-click=\"playDTMF('1')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">1</td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF2\" ng-click=\"playDTMF('2')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">2<small>A B C</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF3\" ng-click=\"playDTMF('3')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">3<small>D E F</small></td>\n" +
    "            </tr>\n" +
    "            <tr>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF4\" ng-click=\"playDTMF('4')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">4<small>G H I</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF5\" ng-click=\"playDTMF('5')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">5<small>J K L</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF6\" ng-click=\"playDTMF('6')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">6<small>M N O</small></td>\n" +
    "            </tr>\n" +
    "            <tr>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF7\" ng-click=\"playDTMF('7')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">7<small>P Q R S</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF8\" ng-click=\"playDTMF('8')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">8<small>T U V</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF9\" ng-click=\"playDTMF('9')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">9<small>W X Y Z</small></td>\n" +
    "            </tr>\n" +
    "            <tr>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF*\" ng-click=\"playDTMF('*')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">*</td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF0\" ng-click=\"playDTMF('0')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">0<small>+</small></td>\n" +
    "              <td class=\"btn keypad-btn\" id=\"btnDTMF#\" ng-click=\"playDTMF('#')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">#</td>\n" +
    "            </tr>\n" +
    "          </table>\n" +
    "        </div>\n" +
    "        <div class=\"video-controls-bottom video-controls-top\">\n" +
    "          <a href=\"\" class=\"btn control-button\" ng-click=\"localMuteVideo()\" style=\"margin-left: 175px;\">\n" +
    "            <i class=\"fa\" ng-class=\"inCall.localVideoMuted ? 'fa-eye-slash muted' : 'fa-video-camera'\" ></i>\n" +
    "          </a>\n" +
    "          <a href=\"\" class=\"btn control-button\" ng-click=\"callHangup()\">\n" +
    "            <i class=\"fa fa-phone\" style=\"transform: rotate(135deg);\"></i>\n" +
    "          </a>\n" +
    "          <a href=\"\" class=\"btn control-button\" ng-click=\"localMuteAudio()\">\n" +
    "            <i class=\"fa\" ng-class=\"inCall.localAudioMuted ? 'fa-microphone-slash muted' : 'fa-microphone'\"></i>\n" +
    "          </a>\n" +
    "          <img class=\"pull-right telestax-logo-video\" src=\"resources/images/v2/telestax-logo-small-white.png\">\n" +
    "        </div>\n" +
    "        <video\n" +
    "            class=\"remote-video\"\n" +
    "            style=\"{{ isPortrait ? 'height: 100%;' : 'width: 100%;' }};\"\n" +
    "            autoplay=\"autoplay\">\n" +
    "        </video>\n" +
    "      </div>\n" +
    "\n" +
    "      <div id=\"side-videos\">\n" +
    "        <div id=\"video1\" class=\"small-video\">\n" +
    "          <!-- Local Video Window -->\n" +
    "          <webcam\n" +
    "              class=\"block\"\n" +
    "              ng-if=\"loggedUser && requestStream\"\n" +
    "              ng-show=\"inCall.hasRemoteVideo\"\n" +
    "              placeholder=\"resources/images/loading.gif\"\n" +
    "              audio=\"true\"\n" +
    "              video=\"isVideoCall\"\n" +
    "              video-width=\"640\"\n" +
    "              video-height=\"480\"\n" +
    "              video-constraints=\"videoConstraints\"\n" +
    "              on-stream=\"onStream(stream)\"\n" +
    "              on-error=\"onError(err)\"\n" +
    "              on-streaming=\"onStreaming()\"\n" +
    "              style=\"width: 100%; transform: scaleX(-1);\">\n" +
    "          </webcam>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"border-separator\"></div>\n" +
    "\n" +
    "    <div class=\"chat-container\" ng-class=\"{'chat-with-video': (remoteVideo && (ac.id === inCall.callerPhoneNumber || ac.address === inCall.calleePhoneNumber))}\">\n" +
    "      <div class=\"chat-participant-block\" ng-repeat=\"entry in activeChats[ac.id].history\">\n" +
    "        <span class=\"system-message\" ng-if=\"entry.from === 'system'\">\n" +
    "          <i class=\"fa fa-phone call-event\" ng-class=\"{'missed-call': entry.type === 'missed'}\"></i>\n" +
    "          <span class=\"system-message-text\" ng-bind-html=\"entry.text\"></span>\n" +
    "        </span>\n" +
    "        <span ng-if=\"entry.from !== 'system'\">\n" +
    "          <div class=\"avatar\" ng-class=\"activeChats[ac.id].history[$index].direction === 'in' ? 'contact-avatar' : 'user-avatar'\" ng-show=\"!contact.icon\" ng-if=\"$index === 0 || activeChats[ac.id].history[$index].direction !== activeChats[ac.id].history[$index-1].direction\" style=\"\n" +
    "            background-color: {{ activeChats[ac.id].history[$index].direction === 'in' ? getChatColor(ac.address) : '' }};\">\n" +
    "              <div style=\"\">\n" +
    "                {{ (activeChats[ac.id].history[$index].direction === 'in' ? ac.name : loggedUser) | limitTo : 1 | uppercase }}\n" +
    "              </div>\n" +
    "            </div>\n" +
    "          <div class=\"chat-header\" ng-if=\"$index === 0 || activeChats[ac.id].history[$index].direction !== activeChats[ac.id].history[$index-1].direction\">\n" +
    "            <span class=\"chat-name\">{{ activeChats[ac.id].history[$index].direction === 'in' ? ac.name : loggedUser }}</span>\n" +
    "            <span class=\"chat-time\" am-time-ago=\"entry.time\" title=\"{{entry.time | amDateFormat:'ddd, DD MMM YYYY, HH:mm:ss'}}\"></span>\n" +
    "          </div>\n" +
    "          <div class=\"chat-line\" ng-class=\"{'chat-line-margin' : $index >= 1}\" ng-bind-html=\"entry.text | linky:'_blank'\"</div>\n" +
    "        </span>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <div class=\"textbox\" ng-show=\"ac\">\n" +
    "    <input type=\"text\" class=\"textbox-in\" placeholder=\"Write something crazy\" ng-model=\"ac.writeText\" ng-keydown=\"$event.which === 13 && sendMessage(ac)\">\n" +
    "    <div id=\"infoToggler\" class=\"chat chat-hover\" ng-click=\"sendMessage(ac)\">\n" +
    "      <img src=\"resources/images/v2/mp-send-textbox.png\" width=\"25px\" height=\"30px\">\n" +
    "      <img src=\"resources/images/v2/mp-search-textbox.png\" width=\"25px\" height=\"30px\" style=\"display:none\">\n" +
    "    </div>\n" +
    "    <a href=\"\" class=\"\">\n" +
    "      <div id=\"border-emoticons\"></div>\n" +
    "      <img id=\"emoticons\" src=\"resources/images/v2/mp-arrow-textbox.png\">\n" +
    "    </a>\n" +
    "    <div id=\"container-btn\">\n" +
    "      <div id=\"cancel-call-btn\">\n" +
    "        <a href=\"\" class=\"btn-phone btn-cancel\" ng-show=\"inCall && !inCall.incomingCallFlag && (inCall.intStatus === 'CONNECTING...' || inCall.intStatus === 'RINGING...')\" ng-click=\"callHangup()\"><img src=\"resources/images/v2/decline-call.png\"></a>\n" +
    "      </div>\n" +
    "      <div id=\"left-btn\">\n" +
    "        <a href=\"\" class=\"btn-phone\" ng-hide=\"inCall && !inCall.incomingCallFlag && (inCall.intStatus === 'CONNECTING...' || inCall.intStatus === 'RINGING...')\" ng-class=\"{'action-disabled': inCall}\" ng-click=\"callContact(ac.address, false)\"><img src=\"resources/images/v2/btn-icon-phone.png\"></a>\n" +
    "      </div>\n" +
    "      <div>\n" +
    "        <a href=\"\" class=\"btn-cam\" ng-hide=\"inCall && !inCall.incomingCallFlag && (inCall.intStatus === 'CONNECTING...' || inCall.intStatus === 'RINGING...')\" ng-class=\"{'action-disabled': inCall}\" ng-click=\"callContact(ac.address, true)\"><img src=\"resources/images/v2/btn-icon-camera.png\"></a>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "\n" +
    "<!-- Audio Resources -->\n" +
    "<audio id=\"snd_ringing\" loop src=\"resources/audio/ringing.mp3\" type=\"audio/mpeg\"></audio>\n" +
    "<audio id=\"snd_ringback\" loop src=\"resources/audio/ringback.ogg\" type=\"audio/ogg\"></audio>\n" +
    "<audio id=\"snd_message\" src=\"resources/audio/chat_notification.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf0\" title=\"0\" src=\"resources/audio/dtmf0.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf1\" title=\"1\" src=\"resources/audio/dtmf1.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf2\" title=\"2\" src=\"resources/audio/dtmf2.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf3\" title=\"3\" src=\"resources/audio/dtmf3.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf4\" title=\"4\" src=\"resources/audio/dtmf4.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf5\" title=\"5\" src=\"resources/audio/dtmf5.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf6\" title=\"6\" src=\"resources/audio/dtmf6.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf7\" title=\"7\" src=\"resources/audio/dtmf7.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf8\" title=\"8\" src=\"resources/audio/dtmf8.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmf9\" title=\"9\" src=\"resources/audio/dtmf9.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmfs\" title=\"*\" src=\"resources/audio/star.wav\" ></audio>\n" +
    "<audio id=\"snd_dtmfp\" title=\"#\" src=\"resources/audio/pound.wav\" ></audio>\n"
  );


  $templateCache.put('modules/sign-in.html',
    "<div class=\"row\">\n" +
    "  <div class=\"col-md-10 col-md-offset-1\">\n" +
    "    <div class=\"restcomm-logo\">\n" +
    "      <img src=\"resources/images/v2/restcomm-web-rtc-demo-logo.svg\">\n" +
    "      <span class=\"version-banner pull-right\">v{{ clientVersion }}&nbsp;</span>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n" +
    "\n" +
    "<div class=\"row\">\n" +
    "  <div class=\"col-md-12 text-center\">\n" +
    "    <h3 class=\"sign-in-text\">Sign in to your account</h3>    \n" +
    "  </div>\n" +
    "</div>\n" +
    "<div class=\"row\" ng-show=\"predefinedClients && !showLoginOther\">\n" +
    "  <div class=\"col-md-12 col-xs-12 text-center sign-in-users-list\">\n" +
    "    <div class=\"sign-in-users-list-scroll no-select\" ng-click=\"prevUsers()\" ng-class=\"{'sign-in-users-list-scroll-disabled': startUser === 0}\" ng-show=\"predefinedClients.length > maxUsers\"><i class=\"fa fa-chevron-left\"></i></div>\n" +
    "    <div ng-repeat=\"userClient in predefinedClients | orderBy:'login' | startFrom:startUser | limitTo:maxUsers\" class=\"sign-in-user zoomIn animated clickable\" ng-click=\"loginAs(userClient.login)\">\n" +
    "      <img src=\"resources/images/v2/user-blue.svg\">\n" +
    "      <h3>{{ userClient.login }}</h3>\n" +
    "    </div>\n" +
    "    <div class=\"sign-in-users-list-scroll no-select\" ng-click=\"nextUsers()\" ng-class=\"{'sign-in-users-list-scroll-disabled': startUser >= (predefinedClients.length - maxUsers)}\" ng-show=\"predefinedClients.length > maxUsers\"><i class=\"fa fa-chevron-right\" class=\"sign-in-users-list-scroll\"></i></div>\n" +
    "  </div>\n" +
    "  <div class=\"col-md-12 col-xs-12 text-center\">\n" +
    "    &nbsp;<br>\n" +
    "    <a class=\"sign-in-link\" href=\"\" ng-click=\"showLoginOther = true\">Sign in with another account</a>\n" +
    "  </div>\n" +
    "</div>\n" +
    "\n" +
    "<div class=\"row\" ng-if=\"!predefinedClients || showLoginOther\">\n" +
    "  <div class=\"col-md-4 col-md-offset-4 col-sm-6 col-sm-offset-3 col-xs-12\">\n" +
    "  <section class=\"login-form\">\n" +
    "    <form role=\"login\" name=\"loginForm\" shake shakeit=\"shakeit\">\n" +
    "      <div class=\"row\">\n" +
    "        <div class=\"col-xs-12\">\n" +
    "          <input type=\"text\" name=\"username\" placeholder=\"Username\" class=\"form-control input-lg\" ng-model=\"sip.username\" ng-change=\"mirrorUsername()\" required>\n" +
    "        </div>\n" +
    "        <div class=\"col-xs-12\">\n" +
    "          <input type=\"password\" name=\"password\" placeholder=\"Password\" class=\"form-control input-lg\" ng-model=\"sip.password\" required>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "      <button type=\"submit\" ng-click=\"connect()\" ng-disabled=\"loginForm.$invalid\">Sign in</button>\n" +
    "      <section style=\"color: #df3e00;\" ng-show=\"registerFailed\" ng-bind-html=\"loginError\"></section>\n" +
    "      <section>\n" +
    "        <a class=\"sign-in-link\" href=\"/#/numbers/clients\">Forgot password?</a>\n" +
    "      </section>\n" +
    "    </form>\n" +
    "  </section>\n" +
    "  </div>\n" +
    "</div>"
  );


  $templateCache.put('modules/templates/oly-chat-dropdown.html',
    "<ul class=\"dropdown-menu\" role=\"menu\">\n" +
    "  <li><a href=\"\" ng-click=\"callContact(ac.id, true)\"><i class=\"glyphicon glyphicon-facetime-video\"></i> Video Call</a></li>\n" +
    "  <li><a href=\"\" ng-click=\"callContact(ac.id, false)\"><i class=\"glyphicon glyphicon-earphone\"></i> Audio Call</a></li>\n" +
    "  <li><a href=\"\" ng-click=\"fileContact(ac.id)\"><i class=\"glyphicon glyphicon-paperclip\"></i> Send File</a></li>\n" +
    "  <li class=\"divider\"></li>\n" +
    "  <li><a href=\"\" ng-click=\"blockContact(ac.id)\"><i class=\"glyphicon glyphicon-ban-circle\"></i> Block</a></li>\n" +
    "  <li><a href=\"\" ng-click=\"clearChatHistory(ac.id)\"><i class=\"glyphicon glyphicon-erase\"></i> Clear History</a></li>\n" +
    "</ul>\n"
  );


  $templateCache.put('modules/templates/oly-console.html',
    "<div class=\"logs-container\" ng-class=\"{'console-enter': showConsole, 'console-leave': !showConsole}\">\n" +
    "  <button class=\"btn btn-link pull-right\" ng-click=\"showConsole = false\"><i class=\"fa fa-remove\"></i></button>\n" +
    "  <p ng-class=\"log.level|lowercase\" ng-repeat=\"log in logs | orderBy:id:reverse\">{{log.time | amDateFormat:'YYYY-MM-DD HH:mm:ss'}} {{log.message}}</p>\n" +
    "</div>\n"
  );


  $templateCache.put('modules/templates/oly-contact-card.html',
    "<div>\n" +
    "  <button class=\"btn btn-success btn-sm\" ng-click=\"callContact(contact.address, true)\" data-title=\"Video Call\" data-delay=\"500,100\" bs-tooltip><i class=\"fa fa-video-camera fa-2x\"></i></button>\n" +
    "\n" +
    "  <button class=\"btn btn-primary btn-sm\" ng-click=\"callContact(contact.address, false)\" data-title=\"Audio Call\" data-delay=\"500,100\" bs-tooltip><i class=\"fa fa-phone fa-2x\"></i></button>\n" +
    "  <button ng-if=\"isClient(contact)\" class=\"btn btn-default btn-sm\" ng-click=\"chatContact(contact.address)\" data-title=\"Chat\" data-delay=\"500,100\" bs-tooltip><i class=\"fa fa-comments-o fa-2x\"></i></button>\n" +
    "  <button ng-if=\"isClient(contact)\" class=\"btn btn-default btn-sm\" style=\"opacity: 0.2;\" ng-click=\"chatContact(contact.address)\" data-title=\"Email\" data-delay=\"500,100\" bs-tooltip disabled=\"disabled\"><i class=\"fa fa-envelope fa-2x\"></i></button>\n" +
    "  <br>\n" +
    "  <button class=\"btn btn-danger btn-xs pull-right\" style=\"margin: 10px;\" ng-hide=\"contact.deleteConfirm\" ng-click=\"preDeleteContact(contact)\" data-title=\"Delete Contact\" data-delay=\"500,100\" bs-tooltip><i class=\"fa fa-trash\"></i></button>\n" +
    "  <button class=\"btn btn-danger btn-xs pull-right\" style=\"margin: 10px;\" ng-show=\"contact.deleteConfirm\" ng-click=\"deleteContact(contact)\" data-title=\"Delete Contact\" data-delay=\"500,100\" bs-tooltip><i class=\"fa fa-trash\"></i> Delete</button>\n" +
    "</div>"
  );


  $templateCache.put('modules/templates/oly-contacts.html',
    "<div class=\"popover contacts-popover\" style=\"overflow-y: scroll; overflow: auto; max-height: 75%;\" ng-style=\"{'margin-top': contactsMarginTop}\">\n" +
    "  <!-- We need full popover template so we can hide it (disable) when not in call -->\n" +
    "  <div class=\"arrow\" ng-show=\"true || inCall\"></div>\n" +
    "  <!-- <h3 class=\"popover-title\" ng-bind=\"title\" ng-show=\"true || inCall && title\"></h3> -->\n" +
    "  <div class=\"popover-content\" ng-show=\"true || inCall\">\n" +
    "\n" +
    "  <div class=\"contacts animated\" style=\"margin-top: 20px;\" ng-init=\"setMarginTop()\">\n" +
    "    <h3><i class=\"glyphicon glyphicon-list-alt\"></i> <span style=\"color:#555;\">Contacts</span><span style=\"color:#CCC;\">List</span></h3>\n" +
    "    <div class=\"input-group\">\n" +
    "      <input id=\"inputContact\" class=\"form-control\" type=\"text\" ng-model=\"$parent.$parent.$parent.newContact.address\" ng-keyup=\"$event.keyCode == 13 && isValidContact() && addContact()\" placeholder=\"Contact Address\">\n" +
    "      <span class=\"input-group-btn\">\n" +
    "        <button id=\"btnAddContact\" class=\"btn btn-primary\" type=\"button\" ng-click=\"addContact()\" ng-disabled=\"!isValidContact()\">Add</button>\n" +
    "      </span>\n" +
    "    </div>\n" +
    "    <div style=\"margin-top: 2px;\">\n" +
    "      <input id=\"inputContact\" class=\"form-control input-sm\" type=\"text\" ng-model=\"$parent.$parent.$parent.newContact.name\" placeholder=\"Contact Name (optional)\" ng-show=\"$parent.$parent.$parent.newContact.address\" ng-keyup=\"$event.keyCode == 13 && isValidContact() && addContact()\">\n" +
    "    </div>\n" +
    "    <br>\n" +
    "    <dl ng-repeat=\"contact in contacts|filter:$parent.$parent.$parent.newContact.address\">\n" +
    "      <dt><i class=\"fa fa-{{contact.icon}}\"></i> {{contact.name}}</dt>\n" +
    "      <dd><a href=\"\" class=\"contact-entry\" ng-dblclick=\"isClient(contact) ? chatContact(contact.address) : callContact(contact.address, false)\" data-content-template=\"modules/templates/oly-contact-card.html\" title=\"{{contact.name}} // {{contact.address}}\" data-animation=\"am-flip-x\" data-auto-close=\"1\" bs-popover data-container=\"body\" data-placement=\"right\">{{contact.address}}</a>\n" +
    "        <div ng-show=\"contact.isCollapsed\">\n" +
    "          <button ng-if=\"isClient(contact)\" class=\"btn btn-success btn-xs\" ng-click=\"callContact(contact.address, true)\"><i class=\"glyphicon glyphicon-facetime-video\"></i></button>\n" +
    "          <button class=\"btn btn-primary btn-xs\" ng-click=\"callContact(contact.address, false)\"><i class=\"glyphicon glyphicon-earphone\"></i></button>\n" +
    "          <button ng-if=\"isClient(contact)\" class=\"btn btn-default btn-xs\" ng-click=\"chatContact(contact.address)\"><i class=\"glyphicon glyphicon-comment\"></i></button>\n" +
    "        </div>\n" +
    "      </dd>\n" +
    "    </dl>\n" +
    "  </div>\n" +
    "\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('modules/templates/oly-keypad.html',
    "<div class=\"popover\">\n" +
    "  <!-- We need full popover template so we can hide it (disable) when not in call -->\n" +
    "  <div class=\"arrow\" ng-show=\"inCall\"></div>\n" +
    "  <h3 class=\"popover-title\" ng-bind=\"title\" ng-show=\"inCall && title\"></h3>\n" +
    "  <div class=\"popover-content\" ng-show=\"inCall\">\n" +
    "    <table class=\"keypad\">\n" +
    "      <tr>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF1\" ng-click=\"playDTMF('1')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">1</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF2\" ng-click=\"playDTMF('2')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">2</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF3\" ng-click=\"playDTMF('3')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">3</td>\n" +
    "      </tr>\n" +
    "      <tr>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF4\" ng-click=\"playDTMF('4')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">4</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF5\" ng-click=\"playDTMF('5')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">5</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF6\" ng-click=\"playDTMF('6')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">6</td>\n" +
    "      </tr>\n" +
    "      <tr>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF7\" ng-click=\"playDTMF('7')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">7</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF8\" ng-click=\"playDTMF('8')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">8</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF9\" ng-click=\"playDTMF('9')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">9</td>\n" +
    "      </tr>\n" +
    "      <tr>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF*\" ng-click=\"playDTMF('*')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">*</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF0\" ng-click=\"playDTMF('0')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">0</td>\n" +
    "        <td class=\"btn btn-primary\" id=\"btnDTMF#\" ng-click=\"playDTMF('#')\" ng-keydown=\"keypressDTMF($event)\" tabindex=\"0\">#</td>\n" +
    "      </tr>\n" +
    "    </table>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('modules/templates/oly-layouts.html',
    "<div class=\"popover\">\n" +
    "  <!-- We need full popover template so we can hide it (disable) when not in call -->\n" +
    "  <div class=\"arrow\" ng-show=\"true || inCall\"></div>\n" +
    "  <h3 class=\"popover-title\" ng-bind=\"title\" ng-show=\"true || inCall && title\"></h3>\n" +
    "  <div class=\"popover-content\" ng-show=\"true || inCall\">\n" +
    "    <ul class=\"nav nav-pills nav-stacked\">\n" +
    "      <li role=\"presentation\" ng-repeat=\"(id, layout) in layouts\" ng-class=\"{active: id === activeLayout}\"><a href=\"\" ng-click=\"setActiveLayout(id)\">{{layout}}</a></li>\n" +
    "    </ul>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('modules/templates/oly-sidebar.html',
    "<ul class=\"nav nav-sidebar sidemenu\">\n" +
    "  <li ng-show=\"activeLayout === 'FuW'\">\n" +
    "    <a href=\"\" ng-click=\"setActiveLayout('SbS')\"><video ng-show=\"activeLayout === 'FuW'\" id=\"localVideoThumb\" autoplay=\"autoplay\" ng-src=\"{{localVideo}}\" style=\"width: 100%; transform: scaleX(-1);\" muted=\"true\"></video><small>YOU</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "  <!-- Non-popover contacts.. TODO: Check if going back to this...\n" +
    "  <li ng-click=\"toggleContactList();\">\n" +
    "    <a id=\"btnContacts\" href=\"\"><i class=\"glyphicon glyphicon-user\"></i><small>CONTACTS</small></a>\n" +
    "  </li>\n" +
    "  -->\n" +
    "\n" +
    "  <li>\n" +
    "    <a id=\"btnContacts\" href=\"\" data-template=\"modules/templates/oly-contacts.html\" data-animation=\"am-flip-x\" data-auto-close=\"1\" bs-popover data-container=\"body\" data-placement=\"right\"><i class=\"glyphicon glyphicon-user\"></i><small>CONTACTS</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "  <li role=\"presentation\" class=\"divider\"></li>\n" +
    "\n" +
    "  <li id=\"tLayout\">\n" +
    "    <a id=\"btnLayout\" href=\"\" data-template=\"modules/templates/oly-layouts.html\" title=\"Video Layouts\" data-animation=\"am-flip-x\" data-auto-close=\"1\" bs-popover data-container=\"body\" data-placement=\"right\"><i class=\"fa fa-columns\"></i><small>LAYOUT</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "<!--\n" +
    "  <li class=\"disabled\">\n" +
    "    <a id=\"btnLayout\"  href=\"\" onclick=\"return false;\"><span id=\"unreadTxt\" class=\"badge pull-right\" style=\"margin-bottom: -20px; margin-right: -10px; display: none;\">0</span><i class=\"fa fa-columns\"></i><small>LAYOUT</small></a>\n" +
    "  </li>\n" +
    "-->\n" +
    "\n" +
    "  <!-- In the future.. for number calls ?\n" +
    "  <li class=\"disabled\">\n" +
    "    <a id=\"btnCall\" href=\"\"  onclick=\"makeCall(selectedContact); return false;\"><i class=\"glyphicon glyphicon-earphone\" style=\"transform: rotate(100deg);\"></i><small>CALL</small></a>\n" +
    "  </li>\n" +
    "  -->\n" +
    "\n" +
    "  <li class=\"{{inCall ? '' : 'disabled'}}\" id=\"tKeypad\">\n" +
    "    <a id=\"btnKeypad\" href=\"\" data-template=\"modules/templates/oly-keypad.html\" title=\"DTMF Keypad\" data-animation=\"am-flip-x\" data-auto-close=\"1\" bs-popover data-container=\"body\" data-placement=\"right\" ng-keydown=\"keypress($event)\" disabled=\"disabled\"><i class=\"glyphicon glyphicon-th\"></i><small>KEYPAD</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "  <!--\n" +
    "  <li class=\"disabled\">\n" +
    "    <a id=\"btnFile\" href=\"\"  onclick=\"return false;\"><i class=\"glyphicon glyphicon-paperclip\"></i><small>UPLOAD</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "  <li class=\"disabled\" style=\"margin-top: 50px; padding-left: 0; padding-right: 0;\">\n" +
    "    <a id=\"btnHang\" href=\"\"><i class=\"glyphicon glyphicon-phone-alt\"></i><small>HANGUP</small></a>\n" +
    "  </li>\n" +
    "  -->\n" +
    "\n" +
    "  <li style=\"margin-top: 50px; padding-left: 0; padding-right: 0;\">\n" +
    "    <a id=\"btnLogs\" href=\"\" ng-click=\"toggleConsole()\"><i class=\"fa fa-inbox\"></i><small>LOGS</small></a>\n" +
    "  </li>\n" +
    "\n" +
    "  <li class=\"disabled\">\n" +
    "    <a id=\"btnSettings\" href=\"\"><i class=\"fa fa-cog\"></i><small>SETTINGS</small></a>\n" +
    "  </li>\n" +
    "</ul>\n"
  );


  $templateCache.put('modules/templates/popover-html-unsafe-popup.html',
    "<div class=\"popover {{placement}}\" ng-class=\"{ in: isOpen(), fade: animation() }\">\n" +
    "  <div class=\"arrow\"></div>\n" +
    "\n" +
    "  <div class=\"popover-inner\">\n" +
    "      <h3 class=\"popover-title\" ng-bind=\"title\" ng-show=\"title\"></h3>\n" +
    "      <div class=\"popover-content\" bind-html-unsafe=\"content\"></div>\n" +
    "  </div>\n" +
    "</div>\n"
  );

}]);
