/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.maven.plugin.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.mobicents.maven.plugin.eclipse.EclipseWriter;
import org.mobicents.maven.plugin.eclipse.OrArtifactFilter;
import org.mobicents.maven.plugin.utils.PathNormalizer;

public class ClasspathWriter
extends EclipseWriter {
    public ClasspathWriter(MavenProject project, Log logger) {
        super(project, logger);
    }

    public void write(List projects, String repositoryVariableName, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, ArtifactMetadataSource artifactMetadataSource, Set classpathArtifactTypes, List remoteRepositories, boolean resolveTransitiveDependencies, String merge, Set classpathExcludes, boolean includeResourcesDirectory) throws Exception {
        String rootDirectory = PathNormalizer.normalizePath(this.project.getBasedir().toString());
        File classpathFile = new File(rootDirectory, ".classpath");
        FileWriter fileWriter = new FileWriter(classpathFile);
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)fileWriter, "UTF-8", null);
        writer.startElement("classpath");
        LinkedHashSet<String> projectArtifactIds = new LinkedHashSet<String>();
        for (MavenProject project : projects) {
            Artifact projectArtifact = artifactFactory.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, project.getPackaging());
            projectArtifactIds.add(projectArtifact.getId());
        }
        this.writeSourceRoots(this.project, rootDirectory, (XMLWriter)writer, includeResourcesDirectory);
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.project.createArtifacts(artifactFactory, null, null));
        for (MavenProject project : projects) {
            this.writeSourceRoots(project, rootDirectory, (XMLWriter)writer, includeResourcesDirectory);
            Set artifacts = project.createArtifacts(artifactFactory, null, null);
            for (Artifact artifact : artifacts) {
                if (!projectArtifactIds.contains(artifact.getId()) && !project.getGroupId().equals(artifact.getGroupId())) {
                    artifactResolver.resolve(artifact, project.getRemoteArtifactRepositories(), localRepository);
                    allArtifacts.add(artifact);
                    continue;
                }
                allArtifacts.add(artifact);
            }
        }
        for (MavenProject project : projects) {
            Artifact projectArtifact = project.getArtifact();
            if (projectArtifact == null) continue;
            Iterator artifactIterator = allArtifacts.iterator();
            while (artifactIterator.hasNext()) {
                Artifact artifact;
                artifact = (Artifact)artifactIterator.next();
                String projectId = projectArtifact.getArtifactId();
                String projectGroupId = projectArtifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                String groupId = artifact.getGroupId();
                if (!artifactId.equals(projectId) || !groupId.equals(projectGroupId)) continue;
                artifactIterator.remove();
            }
        }
        if (resolveTransitiveDependencies) {
            Artifact rootProjectArtifact = artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getPackaging());
            OrArtifactFilter filter = new OrArtifactFilter();
            filter.add((ArtifactFilter)new ScopeArtifactFilter("compile"));
            filter.add((ArtifactFilter)new ScopeArtifactFilter("provided"));
            filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
            ArtifactResolutionResult result = artifactResolver.resolveTransitively(allArtifacts, rootProjectArtifact, localRepository, remoteRepositories, artifactMetadataSource, (ArtifactFilter)filter);
            allArtifacts.clear();
            allArtifacts.addAll(result.getArtifacts());
        }
        Iterator i = allArtifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (classpathExcludes == null) continue;
            if (classpathExcludes.contains(artifact.getGroupId())) {
                this.logger.info((CharSequence)("Excluding " + artifact + " from .classpath, groupId is excluded"));
                i.remove();
                continue;
            }
            if (classpathExcludes.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) {
                this.logger.info((CharSequence)("Excluding " + artifact + " from .classpath, groupId:artifactId is excluded"));
                i.remove();
                continue;
            }
            if (!classpathExcludes.contains(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())) continue;
            this.logger.info((CharSequence)("Excluding " + artifact + " from .classpath, groupId:artifactId:version is excluded"));
            i.remove();
        }
        ArrayList allArtifactPaths = new ArrayList(allArtifacts);
        Iterator<String> iterator = allArtifactPaths.listIterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (classpathArtifactTypes.contains(artifact.getType())) {
                File artifactFile = artifact.getFile();
                if (artifactFile == null) {
                    artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), localRepository);
                    artifactFile = artifact.getFile();
                }
                if (artifactFile != null) {
                    String path = StringUtils.replace((String)PathNormalizer.normalizePath(artifactFile.toString()), (String)PathNormalizer.normalizePath(localRepository.getBasedir()), (String)repositoryVariableName);
                    iterator.set(path);
                    continue;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        Collections.sort(allArtifactPaths);
        for (String path : allArtifactPaths) {
            if (path.startsWith(repositoryVariableName)) {
                this.writeClasspathEntry((XMLWriter)writer, "var", path);
                continue;
            }
            if (path.startsWith(rootDirectory)) {
                path = StringUtils.replace((String)path, (String)(rootDirectory + '/'), (String)"");
            }
            this.writeClasspathEntry((XMLWriter)writer, "lib", path);
        }
        this.writeClasspathEntry((XMLWriter)writer, "con", "org.eclipse.jdt.launching.JRE_CONTAINER");
        String outputPath = StringUtils.replace((String)PathNormalizer.normalizePath(this.project.getBuild().getOutputDirectory()), (String)rootDirectory, (String)"");
        if (outputPath.startsWith("/")) {
            outputPath = outputPath.substring(1, outputPath.length());
        }
        this.writeClasspathEntry((XMLWriter)writer, "output", outputPath);
        if (StringUtils.isNotBlank((String)merge)) {
            writer.writeMarkup(merge);
        }
        writer.endElement();
        this.logger.info((CharSequence)("Classpath file written --> '" + classpathFile + "'"));
        IOUtil.close((Writer)fileWriter);
    }

    private void writeSourceRoots(MavenProject project, String rootDirectory, XMLWriter writer, boolean includeResourcesDirectory) {
        HashSet<String> sourcePaths = new HashSet<String>();
        Iterator sourceIterator = project.getCompileSourceRoots().iterator();
        while (sourceIterator.hasNext()) {
            String sourceRootPath;
            String sourceRoot = PathNormalizer.normalizePath((String)sourceIterator.next());
            if (!new File(sourceRoot).isDirectory() || !(sourceRootPath = StringUtils.replace((String)sourceRoot, (String)rootDirectory, (String)"")).startsWith("/")) continue;
            sourceRootPath = sourceRootPath.substring(1, sourceRootPath.length());
            sourcePaths.add(sourceRootPath);
        }
        if (includeResourcesDirectory) {
            for (Resource resource : project.getResources()) {
                String resourceSourceRootPath;
                File resourceDirectory = new File(resource.getDirectory());
                if (!resourceDirectory.exists() || !resourceDirectory.isDirectory() || !(resourceSourceRootPath = StringUtils.replace((String)resource.getDirectory(), (String)rootDirectory, (String)"")).startsWith("/")) continue;
                resourceSourceRootPath = resourceSourceRootPath.substring(1, resourceSourceRootPath.length());
                boolean add = true;
                for (String resourcePath : sourcePaths) {
                    if (!resourceSourceRootPath.startsWith(resourcePath)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                for (String resourcePath : sourcePaths) {
                    if (!resourcePath.startsWith(resourceSourceRootPath)) continue;
                    sourcePaths.remove(resourcePath);
                }
                sourcePaths.add(resourceSourceRootPath);
            }
        }
        for (String sourcePath : sourcePaths) {
            this.writeClasspathEntry(writer, "src", sourcePath);
        }
    }

    private void writeClasspathEntry(XMLWriter writer, String kind, String path) {
        writer.startElement("classpathentry");
        writer.addAttribute("kind", kind);
        writer.addAttribute("path", path);
        writer.endElement();
    }
}

