/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mobicents.maven.plugin.eclipse.ClasspathWriter;
import org.mobicents.maven.plugin.eclipse.ProjectWriter;
import org.mobicents.maven.plugin.utils.PathNormalizer;
import org.mobicents.maven.plugin.utils.ProjectUtils;

public class EclipseMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private static final String POM_FILE_NAME = "pom.xml";
    private String[] includes = new String[]{"*/**/pom.xml"};
    private String excludePoms;
    private Set classpathExcludes;
    private MavenProjectBuilder projectBuilder;
    private String repositoryVariableName = "M2_REPO";
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private Set classpathArtifactTypes = new LinkedHashSet<String>(Arrays.asList("jar"));
    private boolean resolveTransitiveDependencies = true;
    private boolean generateProjectsForModules = false;
    private String eclipseProjectName;
    private String classpathMerge;
    private List projects = new ArrayList();
    private static final String MULTI_SOURCE_PLUGIN_ARTIFACT_ID = "andromda-multi-source-plugin";
    private MavenProject rootProject;

    public void execute() throws MojoExecutionException {
        if (!this.project.isExecutionRoot() && !this.generateProjectsForModules) {
            this.getLog().warn((CharSequence)"Skipping module because execution root project didn't configured generateProjectsForModules property as true");
            return;
        }
        try {
            MavenProject rootProject = this.getRootProject();
            ProjectWriter projectWriter = new ProjectWriter(rootProject, this.getLog());
            projectWriter.write(this.eclipseProjectName != null ? this.eclipseProjectName : this.project.getArtifactId());
            Map originalCompileSourceRoots = this.collectProjectCompileSourceRoots();
            List projects = this.collectProjects();
            this.processCompileSourceRoots(projects);
            ClasspathWriter classpathWriter = new ClasspathWriter(rootProject, this.getLog());
            classpathWriter.write(projects, this.repositoryVariableName, this.artifactFactory, this.artifactResolver, this.localRepository, this.artifactMetadataSource, this.classpathArtifactTypes, this.project.getRemoteArtifactRepositories(), this.resolveTransitiveDependencies, this.classpathMerge, this.classpathExcludes);
            for (MavenProject project : projects) {
                project.getCompileSourceRoots().clear();
                project.getCompileSourceRoots().addAll((List)originalCompileSourceRoots.get(project));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new MojoExecutionException("Error creating eclipse configuration", throwable);
        }
    }

    private Map collectProjectCompileSourceRoots() throws Exception {
        LinkedHashMap sourceRoots = new LinkedHashMap();
        for (MavenProject project : this.collectProjects()) {
            sourceRoots.put(project, new ArrayList(project.getCompileSourceRoots()));
        }
        return sourceRoots;
    }

    private List collectProjects() throws Exception {
        if (this.projects.isEmpty()) {
            List poms = this.getPoms();
            ListIterator iterator = poms.listIterator();
            while (iterator.hasNext()) {
                File pom = (File)iterator.next();
                try {
                    MavenProject project = ProjectUtils.getProject(this.projectBuilder, this.session, pom, this.getLog());
                    if (project != null) {
                        this.getLog().info((CharSequence)("found project " + project.getId()));
                        this.projects.add(project);
                        continue;
                    }
                    if (!this.getLog().isWarnEnabled()) continue;
                    this.getLog().warn((CharSequence)("Could not load project from pom: " + pom + " - ignoring"));
                }
                catch (ProjectBuildingException exception) {
                    throw new MojoExecutionException("Error loading " + pom, (Exception)((Object)exception));
                }
            }
        }
        return this.projects;
    }

    private void processCompileSourceRoots(List projects) throws Exception {
        for (MavenProject project : projects) {
            LinkedHashSet<String> compileSourceRoots = new LinkedHashSet<String>(project.getCompileSourceRoots());
            compileSourceRoots.addAll(this.getExtraSourceDirectories(project));
            String testSourceDirectory = project.getBuild().getTestSourceDirectory();
            if (testSourceDirectory != null && testSourceDirectory.trim().length() > 0) {
                compileSourceRoots.add(testSourceDirectory);
            }
            project.getCompileSourceRoots().clear();
            project.getCompileSourceRoots().addAll(compileSourceRoots);
        }
    }

    private List getExtraSourceDirectories(MavenProject project) {
        PluginManagement pluginManagement;
        ArrayList<String> sourceDirectories = new ArrayList<String>();
        Build build = project.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null && !pluginManagement.getPlugins().isEmpty()) {
            int childCount;
            Xpp3Dom directories;
            Xpp3Dom configuration;
            Plugin multiSourcePlugin = null;
            for (Plugin plugin : pluginManagement.getPlugins()) {
                if (!MULTI_SOURCE_PLUGIN_ARTIFACT_ID.equals(plugin.getArtifactId())) continue;
                multiSourcePlugin = plugin;
                break;
            }
            if ((configuration = this.getConfiguration(multiSourcePlugin)) != null && configuration.getChildCount() > 0 && (directories = configuration.getChild(0)) != null && (childCount = directories.getChildCount()) > 0) {
                String baseDirectory = PathNormalizer.normalizePath(ObjectUtils.toString((Object)project.getBasedir()) + '/');
                Xpp3Dom[] children = directories.getChildren();
                for (int ctr = 0; ctr < childCount; ++ctr) {
                    String directoryValue;
                    Xpp3Dom child = children[ctr];
                    if (child == null || (directoryValue = PathNormalizer.normalizePath(child.getValue())) == null) continue;
                    if (!directoryValue.startsWith(baseDirectory)) {
                        directoryValue = PathNormalizer.normalizePath(baseDirectory + directoryValue.trim());
                    }
                    sourceDirectories.add(directoryValue);
                }
            }
        }
        return sourceDirectories;
    }

    private Xpp3Dom getConfiguration(Plugin plugin) {
        Xpp3Dom configuration = null;
        if (plugin != null) {
            if (plugin.getConfiguration() != null) {
                configuration = (Xpp3Dom)plugin.getConfiguration();
            } else {
                List executions = plugin.getExecutions();
                if (executions != null && !executions.isEmpty()) {
                    PluginExecution execution = (PluginExecution)plugin.getExecutions().iterator().next();
                    configuration = (Xpp3Dom)execution.getConfiguration();
                }
            }
        }
        return configuration;
    }

    private MavenProject getRootProject() throws MojoExecutionException, ArtifactResolutionException, ArtifactNotFoundException {
        if (this.rootProject == null) {
            MavenProject firstParent = this.project.getParent();
            File rootFile = this.project.getFile();
            this.rootProject = this.project;
        }
        return this.rootProject;
    }

    private List getPoms() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getRootProject().getBasedir());
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludePoms != null ? this.excludePoms.split(",") : null);
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int ctr = 0; ctr < scanner.getIncludedFiles().length; ++ctr) {
            File file = new File(this.getRootProject().getBasedir(), scanner.getIncludedFiles()[ctr]);
            if (!file.exists()) continue;
            poms.add(file);
        }
        return poms;
    }
}

