/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.tools.maven.plugins.du;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.slee.ServiceID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.mobicents.slee.tools.maven.plugins.du.ant.DeployConfig;
import org.mobicents.slee.tools.maven.plugins.du.ant.RAEntity;
import org.mobicents.slee.tools.maven.plugins.du.ant.ServiceIds;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntManagementScriptMojo
extends AbstractMojo {
    private File deployConfigFile;
    private String scriptFileName;
    private String duFileName;
    private File serviceInputDirectory;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Collecting SLEE service descriptors...");
        }
        Set<String> services = this.collectFiles(this.serviceInputDirectory, ".xml");
        String xml = this.generateManagementAntScript(services);
        File file = new File(this.outputDirectory, this.scriptFileName);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(xml);
            this.getLog().info((CharSequence)"Ant management script generated with success.");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + file, (Exception)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String generateManagementAntScript(Set<String> services) throws MojoExecutionException {
        String xml;
        this.getLog().info((CharSequence)"Generating ant script for management without maven...");
        String header = "";
        String footer = "";
        LinkedList<String> deployElements = new LinkedList<String>();
        LinkedList<String> undeployElements = new LinkedList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("build.header")));
            String str = "";
            while ((str = in.readLine()) != null) {
                header = header + str + "\r\n";
            }
            in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("build.footer")));
            while ((str = in.readLine()) != null) {
                footer = footer + str + "\r\n";
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to read header and footer of build.xml file", (Exception)e);
        }
        if (this.deployConfigFile.exists()) {
            try {
                this.getLog().info((CharSequence)"Parsing deploy-config.xml without validation");
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(((Object)((Object)this)).getClass().getClassLoader().getResource("deploy-config.xsd"));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setSchema(schema);
                DocumentBuilder parser = factory.newDocumentBuilder();
                parser.setErrorHandler(new ErrorHandler(){

                    public void error(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void fatalError(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void warning(SAXParseException e) throws SAXException {
                        throw e;
                    }
                });
                Document document = parser.parse(this.deployConfigFile);
                DeployConfig deployConfig = DeployConfig.parse(document.getDocumentElement());
                for (RAEntity raEntity : deployConfig.getRaEntities()) {
                    Properties properties = new Properties();
                    xml = "\t\t<antcall target=\"activate-raentity\">\r\n\t\t\t<param name=\"ra.entity\" value=\"" + raEntity.getEntityName() + "\" />\r\n" + "\t\t\t<param name=\"ra.id\" value=\"" + raEntity.getResourceAdaptorId() + "\" />\r\n";
                    if (!properties.isEmpty()) {
                        xml = xml + "\t\t\t<param name=\"ra.entity.properties.filename\" value=\"" + raEntity.getEntityName() + ".properties\" />\r\n";
                        try {
                            File propertiesFile = new File(this.outputDirectory, ".." + File.separator + raEntity.getEntityName() + ".properties");
                            properties.store(new FileOutputStream(propertiesFile), null);
                            this.getLog().info((CharSequence)("generated properties file " + raEntity.getEntityName() + ".properties"));
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("failed to write ra entity properties file into output dir", (Exception)e);
                        }
                    }
                    xml = xml + "\t\t</antcall>\r\n";
                    deployElements.addLast(xml);
                    xml = "\t\t<antcall target=\"deactivate-raentity\">\r\n\t\t\t<param name=\"ra.entity\" value=\"" + raEntity.getEntityName() + "\" />\r\n" + "\t\t\t<param name=\"ra.id\" value=\"" + raEntity.getResourceAdaptorId() + "\" />\r\n" + "\t\t</antcall>\r\n";
                    undeployElements.addFirst(xml);
                    for (String raLink : raEntity.getRaLinks()) {
                        xml = "\t\t<antcall target=\"bind-ralink\">\r\n\t\t\t<param name=\"ra.entity\" value=\"" + raEntity.getEntityName() + "\" />\r\n" + "\t\t\t<param name=\"ra.link\" value=\"" + raLink + "\" />\r\n" + "\t\t</antcall>\r\n";
                        deployElements.addLast(xml);
                        xml = "\t\t<antcall target=\"unbind-ralink\">\r\n\t\t\t<param name=\"ra.entity\" value=\"" + raEntity.getEntityName() + "\" />\r\n" + "\t\t\t<param name=\"ra.link\" value=\"" + raLink + "\" />\r\n" + "\t\t</antcall>\r\n";
                        undeployElements.addFirst(xml);
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("failed to parse resource META-INF/deploy-config.xml", e);
            }
        }
        for (String fileName : services) {
            File serviceDescriptorFile = new File(this.serviceInputDirectory, fileName);
            try {
                this.getLog().info((CharSequence)("Parsing " + fileName + " with validation"));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(true);
                DocumentBuilder parser = factory.newDocumentBuilder();
                parser.setEntityResolver(new EntityResolver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
                        InputStream is = null;
                        BufferedReader br = null;
                        StringWriter stringWriter = null;
                        StringReader stringReader = null;
                        try {
                            String line;
                            URI uri = new URI(systemID);
                            AntManagementScriptMojo.this.getLog().info((CharSequence)("Resolving " + systemID + " locally from " + uri));
                            String filename = uri.toString().substring(uri.toString().lastIndexOf("/") + 1, uri.toString().length());
                            AntManagementScriptMojo.this.getLog().info((CharSequence)("Resolved filename " + filename));
                            stringWriter = new StringWriter();
                            is = this.getClass().getClassLoader().getResourceAsStream(filename);
                            br = new BufferedReader(new InputStreamReader(is));
                            while (null != (line = br.readLine())) {
                                stringWriter.write(line);
                            }
                            stringWriter.flush();
                            if (stringWriter != null) {
                                stringWriter.close();
                            }
                            stringReader = new StringReader(stringWriter.getBuffer().toString());
                            InputSource inputSource = new InputSource(stringReader);
                            return inputSource;
                        }
                        catch (URISyntaxException e) {
                            AntManagementScriptMojo.this.getLog().error((Throwable)e);
                        }
                        catch (IOException e) {
                            AntManagementScriptMojo.this.getLog().error((Throwable)e);
                        }
                        finally {
                            try {
                                if (br != null) {
                                    br.close();
                                }
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e) {
                                AntManagementScriptMojo.this.getLog().error((Throwable)e);
                            }
                        }
                        return null;
                    }
                });
                parser.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException exception) throws SAXException {
                        AntManagementScriptMojo.this.getLog().warn((CharSequence)exception.getMessage());
                    }

                    public void fatalError(SAXParseException exception) throws SAXException {
                        AntManagementScriptMojo.this.getLog().warn((CharSequence)exception.getMessage());
                    }

                    public void error(SAXParseException exception) throws SAXException {
                        AntManagementScriptMojo.this.getLog().error((CharSequence)exception.getMessage());
                    }
                });
                Document document = parser.parse(serviceDescriptorFile);
                ServiceIds serviceIds = ServiceIds.parse(document.getDocumentElement());
                for (ServiceID serviceId : serviceIds.getIds()) {
                    xml = "\r\n\t\t<antcall target=\"activate-service\">\r\n\t\t\t<param name=\"service.id\" value=\"" + serviceId + "\" />\r\n" + "\t\t</antcall>\r\n";
                    deployElements.addLast(xml);
                    xml = "\r\n\t\t<antcall target=\"deactivate-service\">\r\n\t\t\t<param name=\"service.id\" value=\"" + serviceId + "\" />\r\n" + "\t\t</antcall>\r\n";
                    undeployElements.addFirst(xml);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("failed to parse service descriptor " + fileName, e);
            }
        }
        String xml2 = header + "\r\n\t<property name=\"du.filename\" value=\"" + this.duFileName + "\" />\r\n" + "\r\n\t<target name=\"deploy-jmx\">\r\n" + "\r\n\t\t<antcall target=\"install-DU\" />\r\n";
        for (String s : deployElements) {
            xml2 = xml2 + s;
        }
        xml2 = xml2 + "\r\n\t</target>\r\n\r\n\t<target name=\"undeploy-jmx\">\r\n";
        for (String s : undeployElements) {
            xml2 = xml2 + s;
        }
        xml2 = xml2 + footer;
        return xml2;
    }

    private Set<String> collectFiles(File inputDirectory, String suffix) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Collecting non hidden files with " + suffix + " name sufix from directory " + inputDirectory.getAbsolutePath()));
        }
        if (inputDirectory == null || !inputDirectory.exists() || !inputDirectory.isDirectory()) {
            return Collections.emptySet();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Directory " + inputDirectory.getAbsolutePath() + " sucessfully validated."));
        }
        HashSet<String> result = new HashSet<String>();
        for (File f : inputDirectory.listFiles()) {
            if (f.isDirectory() || f.isHidden() || !f.getName().endsWith(suffix)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Collecting file " + f.getName()));
            }
            result.add(f.getName());
        }
        return result;
    }
}

