/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.resources;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.components.ComponentNameLabel;
import org.mobicents.slee.container.management.console.client.components.ComponentsServiceAsync;
import org.mobicents.slee.container.management.console.client.components.info.ComponentInfo;
import org.mobicents.slee.container.management.console.client.components.info.ComponentTypeInfo;
import org.mobicents.slee.container.management.console.client.components.info.ResourceAdaptorInfo;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorListPanel;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorPanel;

public class ResourceAdaptorListPanel
extends Composite {
    private BrowseContainer browseContainer;
    private ComponentsServiceAsync service = ServerConnection.componentsService;
    private ControlContainer rootPanel = new ControlContainer();
    private ListPanel listPanel = new ListPanel();
    private ComponentInfo[] resourceAdaptorInfos;
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_TYPE = 2;
    private static final int COLUMN_VENDOR = 3;
    private static final int COLUMN_VERSION = 4;

    public ResourceAdaptorListPanel(BrowseContainer browseContainer) {
        this.browseContainer = browseContainer;
        this.initWidget((Widget)this.rootPanel);
        this.refreshData();
    }

    private void refreshData() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.getComponentInfos(new ComponentTypeInfo("Resource Adaptor", 0), (AsyncCallback)callback);
    }

    private void setResourceAdaptorList() {
        if (this.resourceAdaptorInfos == null || this.resourceAdaptorInfos.length == 0) {
            this.rootPanel.setWidget(0, 0, (Widget)new Label("(No resource adaptor)"));
            return;
        }
        this.listPanel = new ListPanel();
        this.listPanel.setHeader(1, "Name");
        this.listPanel.setHeader(2, "Type");
        this.listPanel.setHeader(3, "Vendor");
        this.listPanel.setHeader(4, "Version");
        this.listPanel.setColumnWidth(1, "100%");
        for (int i = 0; i < this.resourceAdaptorInfos.length; ++i) {
            ResourceAdaptorInfo resourceAdaptorInfo = (ResourceAdaptorInfo)this.resourceAdaptorInfos[i];
            this.listPanel.setCell(i, 0, (Widget)new Image("images/components.resource adaptor.gif"));
            Hyperlink nameLink = new Hyperlink(resourceAdaptorInfo.getName(), resourceAdaptorInfo.getName());
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.listPanel.setCell(i, 1, (Widget)nameLink);
            this.listPanel.setCell(i, 2, (Widget)new ComponentNameLabel(resourceAdaptorInfo.getResourceAdaptorTypeID()));
            this.listPanel.setCellText(i, 3, resourceAdaptorInfo.getVendor());
            this.listPanel.setCellText(i, 4, resourceAdaptorInfo.getVersion());
        }
        this.rootPanel.setWidget(0, 0, (Widget)this.listPanel);
    }

    private void onName(ResourceAdaptorInfo resourceAdaptorInfo) {
        ResourceAdaptorPanel resourceAdaptorPanel = new ResourceAdaptorPanel(this.browseContainer, resourceAdaptorInfo.getID());
        this.browseContainer.add(resourceAdaptorInfo.getName(), (Widget)resourceAdaptorPanel);
    }

    static /* synthetic */ ComponentInfo[] access$002(ResourceAdaptorListPanel x0, ComponentInfo[] x1) {
        x0.resourceAdaptorInfos = x1;
        return x1;
    }

    static /* synthetic */ void access$100(ResourceAdaptorListPanel x0) {
        x0.setResourceAdaptorList();
    }

    static /* synthetic */ void access$200(ResourceAdaptorListPanel x0, ResourceAdaptorInfo x1) {
        x0.onName(x1);
    }
}

