/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.log;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.Logger;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.log.LogStructureTreePanel;
import org.mobicents.slee.container.management.console.client.log.LogTreeNode;

public class LogTreeNode
extends Composite {
    private BrowseContainer parentDisplay = null;
    private HorizontalPanel myDisplay = new HorizontalPanel();
    private String shortName = null;
    private String fullName = null;
    private boolean isLogger = false;
    private Image stateImage = null;
    private Image stateChangeImage = null;
    private Hyperlink loggerDetailsLink = null;
    private LogStructureTreePanel logStructureTreePanel;
    public static final String _LEVEL_ALL = "ALL";
    public static final String _LEVEL_SEVERE = "SEVERE";
    public static final String _LEVEL_WARNING = "WARNING";
    public static final String _LEVEL_INFO = "INFO";
    public static final String _LEVEL_FINE = "FINE";
    public static final String _LEVEL_FINER = "FINER";
    public static final String _LEVEL_FINEST = "FINEST";
    public static final String _LEVEL_CONFIG = "CONFIG";
    public static final String _LEVEL_OFF = "OFF";
    public static final String[] _LEVELS = new String[]{"ALL", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "OFF"};

    public LogTreeNode(BrowseContainer parentDisplay, String shortName, String fullName, boolean isLogger, LogStructureTreePanel logStructureTreePanel) {
        try {
            this.initWidget((Widget)this.myDisplay);
            this.parentDisplay = parentDisplay;
            this.shortName = shortName;
            this.fullName = fullName;
            this.isLogger = isLogger;
            this.logStructureTreePanel = logStructureTreePanel;
            this.init();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private void init() {
        this.myDisplay.clear();
        this.loggerDetailsLink = new Hyperlink();
        this.loggerDetailsLink.setHTML(this.shortName);
        this.loggerDetailsLink.addClickListener((ClickListener)new DetailsLinkClickListener(this, this));
        this.stateImage = new Image("images/log.mgmt.logtree.state_active.jpg");
        this.stateChangeImage = new Image("images/log.mgmt.logtree.red_square.jpg");
        if (this.isLogger) {
            this.turnOn();
            ServerConnection.logServiceAsync.getLoggerLevel(this.fullName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.turnOff();
        }
        this.stateChangeImage.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.myDisplay.setSpacing(3);
        this.myDisplay.add((Widget)this.loggerDetailsLink);
        this.myDisplay.add((Widget)this.stateImage);
        this.myDisplay.add((Widget)this.stateChangeImage);
    }

    public void turnOff() {
        this.stateImage.setUrl("images/log.mgmt.logtree.state_inactive.jpg");
        this.stateChangeImage.setUrl("images/log.mgmt.logtree.green_square.jpg");
    }

    protected void turnOn() {
        this.stateImage.setUrl("images/log.mgmt.logtree.state_active.jpg");
        this.stateChangeImage.setUrl("images/log.mgmt.logtree.red_square.jpg");
    }

    static /* synthetic */ boolean access$000(LogTreeNode x0) {
        return x0.isLogger;
    }

    static /* synthetic */ String access$100(LogTreeNode x0) {
        return x0.fullName;
    }

    static /* synthetic */ Image access$200(LogTreeNode x0) {
        return x0.stateImage;
    }

    static /* synthetic */ Image access$400(LogTreeNode x0) {
        return x0.stateChangeImage;
    }

    static /* synthetic */ LogStructureTreePanel access$500(LogTreeNode x0) {
        return x0.logStructureTreePanel;
    }

    static /* synthetic */ BrowseContainer access$600(LogTreeNode x0) {
        return x0.parentDisplay;
    }

    static /* synthetic */ String access$700(LogTreeNode x0) {
        return x0.shortName;
    }
}

