/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.common;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;

public class BrowseContainer
extends Composite {
    private static int MAX_BREADCRUMB_LINKS = 3;
    private boolean showAllLinks = false;
    private ArrayList panels = new ArrayList();
    private ArrayList links = new ArrayList();
    private VerticalPanel rootPanel = new VerticalPanel();

    public BrowseContainer() {
        this.initWidget((Widget)this.rootPanel);
        this.setStyleName("common-BrowseContainer");
    }

    public void add(String title, Widget widget) {
        this.panels.add(widget);
        this.links.add(new BrowseLink(this, this, this.links.size(), title));
        this.refresh();
    }

    private void refresh() {
        this.rootPanel.clear();
        this.refreshLinks();
        this.refreshTitle();
        this.refreshPanel();
    }

    private void refreshLinks() {
        if (this.links.size() <= 1) {
            return;
        }
        HorizontalPanel header = new HorizontalPanel();
        header.setStyleName("common-BrowseContainer-links");
        header.setSpacing(5);
        header.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        int firstLink = 0;
        if (!this.showAllLinks && (firstLink = Math.max(0, this.links.size() - MAX_BREADCRUMB_LINKS)) > 0) {
            MenuBar hiddenMenu = new MenuBar();
            MenuBar subMenu = new MenuBar(true);
            for (int q = firstLink - 1; q >= 0; --q) {
                int fq = q;
                1 cmd = new /* Unavailable Anonymous Inner Class!! */;
                BrowseLink link = (BrowseLink)this.links.get(q);
                subMenu.addItem(link.getTitle(), (Command)cmd);
            }
            MenuItem root = new MenuItem("History", subMenu);
            hiddenMenu.addItem(root);
            header.add((Widget)hiddenMenu);
            header.add((Widget)new Image("images/chain.separator.gif"));
        }
        for (int i = firstLink; i <= this.links.size() - 1; ++i) {
            header.add((Widget)((BrowseLink)this.links.get(i)));
            if (i != this.links.size() - 1) {
                header.add((Widget)new Image("images/chain.separator.gif"));
                ((BrowseLink)this.links.get(i)).setStyle(false);
                continue;
            }
            ((BrowseLink)this.links.get(i)).setStyle(true);
        }
        this.rootPanel.add((Widget)header);
    }

    private void refreshTitle() {
        if (this.links.size() > 0) {
            Label title = new Label(((BrowseLink)this.links.get(this.links.size() - 1)).getTitle());
            title.setStyleName("common-BrowseContainer-title");
            this.rootPanel.add((Widget)title);
        }
    }

    private void refreshPanel() {
        if (this.panels.size() > 0 && this.panels.get(this.panels.size() - 1) != null) {
            this.rootPanel.add((Widget)this.panels.get(this.panels.size() - 1));
        }
    }

    protected void select(int index) {
        if (index >= this.panels.size()) {
            return;
        }
        while (index + 1 < this.panels.size()) {
            this.panels.remove(index + 1);
            this.links.remove(index + 1);
        }
        this.refresh();
    }

    public void back() {
        if (this.panels.size() <= 1) {
            return;
        }
        this.select(this.panels.size() - 2);
    }

    public void empty() {
        this.panels.clear();
        this.links.clear();
        this.refresh();
    }

    public void setTitle(Widget widget, String title) {
        for (int i = 0; i < this.panels.size(); ++i) {
            if ((Widget)this.panels.get(i) != widget) continue;
            ((BrowseLink)this.links.get(i)).setText(title);
            this.refresh();
            return;
        }
    }
}

