/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.rtp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.sdp.Attribute;
import org.apache.log4j.Logger;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketFactory;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketImpl;
import org.mobicents.media.server.testsuite.general.rtp.Transceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpSocketFactoryImpl
implements RtpSocketFactory {
    private static final Logger log = Logger.getLogger(RtpSocketFactoryImpl.class);
    private String localPortRange = "1024-6000";
    private int lowPort = 1024;
    private int highPort = 6000;
    private InetAddress bindAddress;
    private Vector<Attribute> formatMap;
    private Selector readSelector;
    private LinkedList<RtpSocket> notUsedSockets = new LinkedList();
    protected volatile HashMap<SelectionKey, RtpSocket> rtpSockets = new HashMap();
    private Transceiver transceiver;

    public RtpSocketFactoryImpl() throws IOException {
        this.readSelector = SelectorProvider.provider().openSelector();
    }

    @Override
    public RtpSocket createSocket() throws SocketException, IOException {
        RtpSocket rtpSocket = this.notUsedSockets.poll();
        if (rtpSocket == null) {
            rtpSocket = new RtpSocketImpl(this.formatMap, this);
            rtpSocket.init(this.bindAddress, this.lowPort, this.highPort);
        } else if (!rtpSocket.isChannelOpen()) {
            log.error((Object)"The RTPSocket's DatagramChannel is closed. Re init() RtpSocket ");
            rtpSocket.init(this.bindAddress, this.lowPort, this.highPort);
        }
        return rtpSocket;
    }

    @Override
    public void releaseSocket(RtpSocket rtpSocket) {
        this.rtpSockets.remove(rtpSocket.getSelectionKey());
        this.notUsedSockets.add(rtpSocket);
    }

    @Override
    public Vector<Attribute> getFormatMap() {
        return this.formatMap;
    }

    @Override
    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(bindAddress);
    }

    @Override
    public void setFormatMap(Vector<Attribute> originalFormatMap) {
        this.formatMap = originalFormatMap;
    }

    @Override
    public void stop() {
        if (this.transceiver != null) {
            this.transceiver.stop();
            this.transceiver = null;
        }
        for (RtpSocket socket : this.rtpSockets.values()) {
            socket.close();
        }
        this.rtpSockets.clear();
        for (RtpSocket socket : this.notUsedSockets) {
            socket.close();
        }
        this.notUsedSockets.clear();
        log.info((Object)"Stopped RTP Factory");
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress.toString();
    }

    @Override
    public void start() throws SocketException, IOException {
        log.info((Object)("Binding RTP transceiver to " + this.bindAddress + ":" + this.localPortRange));
        this.transceiver = new Transceiver(this.rtpSockets, this.readSelector);
        this.transceiver.start();
    }

    @Override
    public String getPortRange() {
        return this.localPortRange;
    }

    @Override
    public void setPortRange(String port) {
        this.localPortRange = port;
    }

    @Override
    public int getLowPort() {
        return this.lowPort;
    }

    public void setLowPort(int lowPort) {
        this.lowPort = lowPort;
    }

    @Override
    public int getHighPort() {
        return this.highPort;
    }

    public void setHighPort(int hightPort) {
        this.highPort = hightPort;
    }

    public SelectionKey registerSocket(RtpSocketImpl rtpSocketImpl) throws ClosedChannelException {
        try {
            SelectionKey key = rtpSocketImpl.getSelectionKey();
            if (key != null) {
                this.rtpSockets.put(key, rtpSocketImpl);
                return key;
            }
            this.transceiver.addNewChannel(rtpSocketImpl);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

