/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general;

import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.apache.log4j.Logger;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallState;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketFactory;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketListener;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCall
implements JainMgcpExtendedListener,
Serializable,
RtpSocketListener {
    protected transient Logger logger;
    public static final int _READ_PERIOD = 20;
    protected static final transient AtomicLong _GLOBAL_SEQ = new AtomicLong(-1L);
    protected final long sequence;
    protected CallState state;
    protected int avgJitter;
    protected int peakJitter;
    protected long lastDeliverTimeStamp;
    protected transient File dataFileName;
    protected transient File graphDataFileName;
    protected transient FileOutputStream fos;
    protected transient ObjectOutputStream dataDumpChannel;
    protected transient FileOutputStream graphDataDumpChannel;
    protected transient List<RtpPacket> rtpTraffic;
    protected String endpointName;
    protected EndpointIdentifier endpointIdentifier;
    protected CallIdentifier callIdentifier;
    protected transient AbstractTestCase testCase;
    protected transient RtpSocket socket;
    protected transient JainMgcpStackProviderImpl provider;
    protected transient ScheduledFuture<?> timeoutHandle;

    public static void resetSequence() {
        _GLOBAL_SEQ.set(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCall(AbstractTestCase testCase) throws IOException {
        block13: {
            this.logger = Logger.getLogger(AbstractCall.class);
            this.state = CallState.INITIAL;
            this.rtpTraffic = new ArrayList<RtpPacket>();
            this.endpointName = "";
            this.timeoutHandle = null;
            this.testCase = testCase;
            this.callIdentifier = testCase.getProvider().getUniqueCallIdentifier();
            boolean finished = false;
            try {
                this.sequence = _GLOBAL_SEQ.incrementAndGet();
                this.setDumpDir(this.testCase.getTestDumpDirectory());
                this.fos = new FileOutputStream(this.dataFileName);
                this.dataDumpChannel = new ObjectOutputStream(this.fos);
                this.graphDataDumpChannel = new FileOutputStream(this.graphDataFileName);
                this.provider = testCase.getProvider();
                finished = true;
                Object var4_3 = null;
                if (finished) break block13;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!finished) {
                    try {
                        if (this.dataDumpChannel != null) {
                            this.dataDumpChannel.close();
                        }
                        this.dataDumpChannel = null;
                        this.fos = null;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                    try {
                        if (this.graphDataDumpChannel != null) {
                            this.graphDataDumpChannel.close();
                            this.graphDataDumpChannel = null;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                }
                throw throwable;
            }
            try {
                if (this.dataDumpChannel != null) {
                    this.dataDumpChannel.close();
                }
                this.dataDumpChannel = null;
                this.fos = null;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            try {
                if (this.graphDataDumpChannel != null) {
                    this.graphDataDumpChannel.close();
                    this.graphDataDumpChannel = null;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    void setDumpDir(File testDumpDirectory) {
        this.dataFileName = new File(testDumpDirectory, this.sequence + ".rtp");
        this.graphDataFileName = new File(testDumpDirectory, this.sequence + "_graph.txt");
    }

    public File getGraphDataFileName() {
        return this.graphDataFileName;
    }

    protected void initSocket() throws IOException {
        if (this.testCase != null && this.testCase.getSocketFactory() != null) {
            RtpSocketFactory factory = this.testCase.getSocketFactory();
            this.socket = factory.createSocket();
            this.socket.addListener(this);
        }
    }

    protected void releaseSocket() {
        try {
            if (this.socket != null) {
                this.socket.release();
                this.socket = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<RtpPacket> getRtp() throws IOException {
        List<RtpPacket> ll = this.loadRtp();
        return ll;
    }

    private List<RtpPacket> loadRtp() throws IOException {
        ArrayList<RtpPacket> list = new ArrayList<RtpPacket>();
        FileInputStream fin = new FileInputStream(this.dataFileName);
        ObjectInputStream in = new ObjectInputStream(fin);
        while (fin.available() > 0) {
            try {
                RtpPacket p = (RtpPacket)in.readObject();
                list.add(p);
            }
            catch (ClassNotFoundException e) {}
        }
        return list;
    }

    public CallState getState() {
        return this.state;
    }

    public int getAvgJitter() {
        return this.avgJitter;
    }

    public int getPeakJitter() {
        return this.peakJitter;
    }

    public EndpointIdentifier getEndpoint() {
        return this.endpointIdentifier;
    }

    public CallIdentifier getCallID() {
        return this.callIdentifier;
    }

    public long getSequence() {
        return this.sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void setState(CallState state) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dumping data to file. State = " + (Object)state));
        }
        if (state == this.state) {
            return;
        }
        this.state = state;
        switch (1.$SwitchMap$org$mobicents$media$server$testsuite$general$CallState[this.state.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.releaseSocket();
                if (this.rtpTraffic != null && this.rtpTraffic.size() > 0) {
                    for (i = 0; i < this.rtpTraffic.size() - 1; ++i) {
                        p1 = this.rtpTraffic.get(i);
                        p2 = this.rtpTraffic.get(i + 1);
                        localJitter = (int)(p2.getTime().getTime() - p1.getTime().getTime());
                        if (localJitter > this.peakJitter) {
                            this.peakJitter = localJitter;
                        }
                        this.avgJitter += localJitter;
                        this.avgJitter /= 2;
                    }
                    try {
                        if (this.graphDataDumpChannel != null) {
                            this.graphDataDumpChannel.write((this.sequence + AbstractTestCase._LINE_SEPARATOR).getBytes());
                            this.graphDataDumpChannel.write((this.avgJitter + AbstractTestCase._LINE_SEPARATOR).getBytes());
                            this.graphDataDumpChannel.write((this.peakJitter + AbstractTestCase._LINE_SEPARATOR).getBytes());
                        }
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)ex);
                    }
                    for (i = 0; i < this.rtpTraffic.size() - 1; ++i) {
                        p1 = this.rtpTraffic.get(i);
                        p2 = this.rtpTraffic.get(i + 1);
                        try {
                            if (this.dataDumpChannel != null) {
                                this.dataDumpChannel.writeObject(p1);
                            }
                        }
                        catch (IOException ex) {
                            this.logger.error((Object)ex);
                        }
                        try {
                            if (this.graphDataDumpChannel == null) continue;
                            localJitter = (int)(p2.getTime().getTime() - p1.getTime().getTime());
                            this.graphDataDumpChannel.write((localJitter + AbstractTestCase._LINE_SEPARATOR).getBytes());
                            continue;
                        }
                        catch (IOException ex) {
                            this.logger.error((Object)ex);
                        }
                    }
                    try {
                        if (this.dataDumpChannel != null) {
                            p1 = this.rtpTraffic.get(this.rtpTraffic.size() - 1);
                            this.dataDumpChannel.writeObject(p1);
                        }
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)ex);
                    }
                    this.rtpTraffic.clear();
                }
                this.rtpTraffic = null;
                try {
                    if (this.dataDumpChannel != null) {
                        this.dataDumpChannel.close();
                    }
                    this.dataDumpChannel = null;
                    this.fos = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    try {
                        if (this.graphDataDumpChannel == null) ** GOTO lbl72
                        this.graphDataDumpChannel.close();
                        this.graphDataDumpChannel = null;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                        var7_16 = null;
                        break;
                    }
lbl72:
                    // 2 sources

                    var7_15 = null;
                    break;
                }
                catch (Throwable var6_18) {
                    var7_17 = null;
                    throw var6_18;
                }
            }
        }
        this.testCase.callStateChanged(this);
    }

    protected String getLocalDescriptor(int port) {
        long sessionID;
        SessionDescription localSDP = null;
        String userName = "Mobicents-Call-Generator";
        long sessionVersion = sessionID = System.currentTimeMillis() & 0xFFFFFFL;
        String networkType = "IN";
        String addressType = "IP4";
        SdpFactory sdpFactory = this.testCase.getSdpFactory();
        try {
            localSDP = sdpFactory.createSessionDescription();
            localSDP.setVersion(sdpFactory.createVersion(0));
            localSDP.setOrigin(sdpFactory.createOrigin(userName, sessionID, sessionVersion, networkType, addressType, this.testCase.getClientTestNodeAddress().getHostAddress()));
            localSDP.setSessionName(sdpFactory.createSessionName("session"));
            localSDP.setConnection(sdpFactory.createConnection(networkType, addressType, this.testCase.getClientTestNodeAddress().getHostAddress()));
            Vector<Attribute> attributes = this.testCase.getSDPAttributes();
            int[] audioMap = new int[attributes.size()];
            for (int index = 0; index < audioMap.length; ++index) {
                String m = attributes.get(index).getValue().split(" ")[0];
                audioMap[index] = Integer.valueOf(m);
            }
            MediaDescription md = sdpFactory.createMediaDescription("audio", port, 1, "RTP/AVP", audioMap);
            md.setAttributes(attributes);
            Vector<MediaDescription> descriptions = new Vector<MediaDescription>();
            descriptions.add(md);
            localSDP.setMediaDescriptions(descriptions);
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        return localSDP.toString();
    }

    public abstract void start();

    public abstract void timeOut();

    public abstract void stop();

    public ScheduledFuture<?> getTimeoutHandle() {
        return this.timeoutHandle;
    }

    public void setTimeoutHandle(ScheduledFuture<?> timeoutHandle) {
        this.timeoutHandle = timeoutHandle;
    }

    @Override
    public void error(Exception e) {
    }

    @Override
    public void receive(RtpPacket packet) {
        if (this.rtpTraffic != null) {
            this.rtpTraffic.add(packet);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$mobicents$media$server$testsuite$general$CallState;

        static {
            $SwitchMap$org$mobicents$media$server$testsuite$general$CallState = new int[CallState.values().length];
            try {
                1.$SwitchMap$org$mobicents$media$server$testsuite$general$CallState[CallState.ENDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$mobicents$media$server$testsuite$general$CallState[CallState.IN_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$mobicents$media$server$testsuite$general$CallState[CallState.TIMED_OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

