/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.cli;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import jain.protocol.ip.mgcp.CreateProviderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import org.apache.log4j.PropertyConfigurator;
import org.mobicents.media.server.testsuite.cli.TestTypeEnum;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallDisplayInterface;
import org.mobicents.media.server.testsuite.general.TestState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIRunner
implements CallDisplayInterface {
    private static final transient String _COLLECTIVE_FILE_NAME = "graph.txt";
    private String localAddress = "127.0.0.1";
    private String remoteAddress = "127.0.0.1";
    private int localPort = 2428;
    private int remotePort = 2427;
    private int cps = 1;
    private int callDuration = 2500;
    private long maxCalls = -1L;
    private int maxConcurrentCalls = -1;
    private int maxFailCalls = -1;
    private File dataDumpDir = new File("datadump");
    private String audioFileURL = new File("target/audio/ulaw_13s.wav").toURI().toString();
    private Vector<Attribute> codec = new Vector();
    private AbstractTestCase testCase;
    private TestTypeEnum testType = TestTypeEnum.AnnTest;
    private boolean performCollectiveFile;
    private boolean performTestRun;
    private static final LongOpt[] _LONG_OPTS = new LongOpt[14];
    private static final String _GETOPT_PARAMS_STRING = "h:q:w:e:r:t:y:u:i:o:p:a:f:g";
    private static final Logger log = Logger.getLogger(CLIRunner.class.getName());

    private static void configLog4j() {
        InputStream inStreamLog4j = CLIRunner.class.getClassLoader().getResourceAsStream("log4j.properties");
        Properties propertiesLog4j = new Properties();
        try {
            propertiesLog4j.load(inStreamLog4j);
            PropertyConfigurator.configure((Properties)propertiesLog4j);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.finest("log4j configured");
    }

    public CLIRunner() {
        this.convertCodec("0 pcmu/8000");
    }

    public static void usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("java " + CLIRunner.class.getName() + " [OPTIONS] --testtype TestType \n");
        sb.append("Where options can be:\n");
        sb.append("--localaddr       : local address, default is 127.0.0.1\n");
        sb.append("--remoteaddr      : remote address, default is 127.0.0.1\n");
        sb.append("--localpport      : local port, default is 2428\n");
        sb.append("--remoteport      : remote port, default is 2427\n");
        sb.append("--concurrentcalls : concurrent calls, default is -1, which means unbound\n");
        sb.append("--maxcalls        : max calls, default is -1, which means unbound\n");
        sb.append("--datadir         : data dump directory, default is ./datadump\n");
        sb.append("--audiofile       : audio file url, if requried, default is file:/./../../target/audio/ulaw_13s.wav\n");
        sb.append("--audiocodec      : audio codec to be used if requried, default is '0 pcmu/8000', value should be specifiedd in ''\n");
        sb.append("--testtype        : test type, currently there is only one available: AnnTest\n");
        sb.append("--maxfail         : specifies how many calls may fail until testtool will stop sending requests to server, default is -1, which means unbound\n");
        sb.append("--usage           : print this message\n");
        sb.append("--collectivegraph : no arg option which creates collective file with data that can be presented as graph, can be set for test, and will be executed as end action, file is created in datadump directory.\n");
        sb.append("example options part: --localaddress=127.0.0.1 --localport=2499 --concurentcalls=12 --audiocodec='8 pcma/8000' --testtype=AnnTest\n");
        log.severe("Usage: \n" + sb);
    }

    private void convertCodec(String s) {
        SdpFactory sdpFactory = SdpFactory.getInstance();
        this.codec.clear();
        this.codec.add(sdpFactory.createAttribute("rtpmap", s.replaceAll("'", "")));
    }

    private void convertTest(String v) {
        this.testType = TestTypeEnum.fromString(v);
    }

    @Override
    public int getCPS() {
        return this.cps;
    }

    @Override
    public int getCallDuration() {
        return this.callDuration;
    }

    @Override
    public Vector<Attribute> getCodecs() {
        return this.codec;
    }

    @Override
    public File getDefaultDataDumpDirectory() {
        return this.dataDumpDir;
    }

    @Override
    public String getFileURL() {
        return this.audioFileURL;
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public void updateCallView() {
        if (log.isLoggable(Level.INFO)) {
            StringBuffer sb = new StringBuffer();
            sb.append("=============================================================\n");
            sb.append("Press 'q' + Enter to stop test\n");
            sb.append("Current calls     : " + this.testCase.getOngoingCallNumber() + "\n");
            sb.append("Success calls     : " + this.testCase.getCompletedCallNumber() + "\n");
            sb.append("Failed calls      : " + this.testCase.getErrorCallNumber() + "\n");
            sb.append("Max failed calls  : " + this.maxFailCalls + "\n");
            sb.append("Total calls       : " + this.testCase.getTotalCallNumber() + "\n");
            log.info(sb.toString());
        }
    }

    @Override
    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    @Override
    public long getMaxCalls() {
        return this.maxCalls;
    }

    @Override
    public int getMaxFailCalls() {
        return this.maxFailCalls;
    }

    public static void main(String[] args) {
        CLIRunner cli = new CLIRunner();
        cli.parseArgs(args);
        if (cli.performTestRun) {
            cli.runTest();
        }
        if (cli.performCollectiveFile) {
            cli.doCollectiveFile();
        }
        System.exit(0);
    }

    private void doCollectiveFile() {
        String[] datadumpFiles;
        File outputFile = new File(this.dataDumpDir, _COLLECTIVE_FILE_NAME);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        ArrayList<BufferedReader> testGraphsInputs = new ArrayList<BufferedReader>();
        for (String file : datadumpFiles = this.dataDumpDir.list()) {
            File f = new File(this.dataDumpDir.getAbsoluteFile(), file);
            File graphFile = new File(f, _COLLECTIVE_FILE_NAME);
            if (f.canRead() && f.isDirectory() && graphFile.canRead() && graphFile.isFile()) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(graphFile));
                    testGraphsInputs.add(br);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            log.severe("Skipping file:" + f + " - it is not a directory or no graph file present: " + graphFile);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            HashSet<BufferedReader> finishedReaders = new HashSet<BufferedReader>();
            while (testGraphsInputs.size() != finishedReaders.size()) {
                for (int index = 0; index < testGraphsInputs.size(); ++index) {
                    BufferedReader br = (BufferedReader)testGraphsInputs.get(index);
                    if (finishedReaders.contains(br)) {
                        fos.write("\t".getBytes());
                        continue;
                    }
                    String line = null;
                    try {
                        line = br.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (line == null) {
                        finishedReaders.add(br);
                        fos.write("\t".getBytes());
                        continue;
                    }
                    fos.write((line + "\t").getBytes());
                    if (index != testGraphsInputs.size() - 1) continue;
                    fos.write(AbstractTestCase._LINE_SEPARATOR.getBytes());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            for (BufferedReader br : testGraphsInputs) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runTest() {
        block22: {
            try {
                this.testCase = this.testType.getTestCaseForType(this);
                log.info("Starting test case, prest 'q' to exit test");
            }
            catch (UnknownHostException ex) {
                log.log(Level.SEVERE, null, ex);
                return;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, null, e);
                return;
            }
            this.testCase.start();
            while (this.testCase.getTestState() != TestState.Stoped) {
                try {
                    int r;
                    Thread.sleep(1000L);
                    if (System.in.available() <= 0 || (r = System.in.read()) != 113) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object var3_7 = null;
            if (this.testCase == null) break block22;
            try {
                this.testCase.stop(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getCallDuration() + 5000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            break block22;
            {
                catch (CreateProviderException ex) {
                    log.log(Level.SEVERE, null, ex);
                    Object var3_8 = null;
                    if (this.testCase == null) break block22;
                    try {
                        this.testCase.stop(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.getCallDuration() + 5000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break block22;
                }
                catch (TooManyListenersException ex) {
                    log.log(Level.SEVERE, null, ex);
                    Object var3_9 = null;
                    if (this.testCase == null) break block22;
                    try {
                        this.testCase.stop(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.getCallDuration() + 5000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_10 = null;
                if (this.testCase != null) {
                    try {
                        this.testCase.stop(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.getCallDuration() + 5000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    private void parseArgs(String[] args) {
        Getopt getOpt = new Getopt("CLIRunner", args, _GETOPT_PARAMS_STRING, _LONG_OPTS);
        getOpt.setOpterr(true);
        int c = -1;
        String v = null;
        block38: while ((c = getOpt.getopt()) != -1) {
            switch (c) {
                case 104: {
                    CLIRunner.usage();
                    System.exit(0);
                }
                case 113: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Local Address must have value");
                    } else {
                        try {
                            InetAddress.getByName(v);
                            this.localAddress = v;
                        }
                        catch (UnknownHostException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 119: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Remote Address must have value");
                    } else {
                        try {
                            InetAddress.getByName(v);
                            this.remoteAddress = v;
                        }
                        catch (UnknownHostException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 101: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Remote Port must have value");
                    } else {
                        try {
                            this.remotePort = Integer.valueOf(v);
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 114: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Local Port must have value");
                    } else {
                        try {
                            this.localPort = Integer.valueOf(v);
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 116: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Concurrent Calls must have value");
                    } else {
                        try {
                            this.maxConcurrentCalls = Integer.valueOf(v);
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 121: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Max Calls must have value");
                    } else {
                        try {
                            this.maxCalls = Integer.valueOf(v).intValue();
                        }
                        catch (NumberFormatException ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 117: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Data Dir must have value");
                    } else {
                        this.dataDumpDir = new File(v);
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 105: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Audio File URL must have value");
                    } else {
                        try {
                            new URL(v);
                            this.audioFileURL = v;
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 111: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Audio Codec must have value");
                    } else {
                        try {
                            this.convertCodec(v);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 112: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Test Type must have value");
                    } else {
                        try {
                            this.convertTest(v);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 97: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Test Type must have value");
                    } else {
                        try {
                            this.cps = Integer.valueOf(v);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 102: {
                    v = getOpt.getOptarg();
                    if (v == null) {
                        log.severe("Max Failure Calls must have value");
                    } else {
                        try {
                            this.maxFailCalls = Integer.valueOf(v);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, null, ex);
                        }
                    }
                    this.performTestRun = true;
                    continue block38;
                }
                case 103: {
                    this.performCollectiveFile = true;
                    continue block38;
                }
            }
            log.severe("Wrong parameter!! ---> " + Character.toString((char)c));
        }
    }

    static {
        CLIRunner._LONG_OPTS[0] = new LongOpt("usage", 0, null, 104);
        CLIRunner._LONG_OPTS[1] = new LongOpt("localaddr", 2, null, 113);
        CLIRunner._LONG_OPTS[2] = new LongOpt("remoteaddr", 2, null, 119);
        CLIRunner._LONG_OPTS[3] = new LongOpt("remoteport", 2, null, 101);
        CLIRunner._LONG_OPTS[4] = new LongOpt("localport", 2, null, 114);
        CLIRunner._LONG_OPTS[5] = new LongOpt("concurrentcalls", 2, null, 116);
        CLIRunner._LONG_OPTS[6] = new LongOpt("maxcalls", 2, null, 121);
        CLIRunner._LONG_OPTS[7] = new LongOpt("datadir", 2, null, 117);
        CLIRunner._LONG_OPTS[8] = new LongOpt("audiofile", 2, null, 105);
        CLIRunner._LONG_OPTS[9] = new LongOpt("audiocodec", 2, null, 111);
        CLIRunner._LONG_OPTS[10] = new LongOpt("testtype", 2, null, 112);
        CLIRunner._LONG_OPTS[11] = new LongOpt("cps", 2, null, 97);
        CLIRunner._LONG_OPTS[12] = new LongOpt("maxfail", 2, null, 102);
        CLIRunner._LONG_OPTS[13] = new LongOpt("collectivegraph", 0, null, 103);
        CLIRunner.configLog4j();
    }
}

