/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.router;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;

public class DefaultSipApplicationRouterInfo
extends SipApplicationRouterInfo {
    private static final String HEADER_REGEX_PREFIX = "HEADER";
    private static final String HEADER_REGEX_SEPARATOR = "_";
    private int order;
    private Map<String, String> optionalParameters;
    private Map<String, Pattern> headerPatternMap = new HashMap<String, Pattern>();

    public DefaultSipApplicationRouterInfo(String applicationName, String subscriberIdentity, SipApplicationRoutingRegion routingRegion, String[] routes, SipRouteModifier routeModifier, int order, String optionalParameters) {
        super(applicationName, routingRegion, subscriberIdentity, routes, routeModifier, null);
        this.order = order;
        try {
            this.optionalParameters = DefaultSipApplicationRouterInfo.stringToMap(optionalParameters);
            this.scanForHeaderRegex();
        }
        catch (ParseException e) {
            throw new RuntimeException("Error", e);
        }
    }

    private void scanForHeaderRegex() {
        for (String optParamName : this.optionalParameters.keySet()) {
            if (!optParamName.startsWith(HEADER_REGEX_PREFIX)) continue;
            int headerNamePos = optParamName.indexOf(HEADER_REGEX_SEPARATOR);
            this.headerPatternMap.put(optParamName.substring(headerNamePos + 1), Pattern.compile(this.optionalParameters.get(optParamName)));
        }
    }

    public static Map<String, String> stringToMap(String str) throws ParseException {
        String[] props;
        HashMap<String, String> map = new HashMap<String, String>();
        if (str == null) {
            return map;
        }
        for (String prop : props = str.split(" ")) {
            if (prop.equals("") || prop.equals(" ")) continue;
            int indexOfEq = prop.indexOf(61);
            if (indexOfEq == -1) {
                throw new RuntimeException("Expected '=' sign in the optional Parameters");
            }
            String key = prop.substring(0, indexOfEq);
            String value = prop.substring(indexOfEq + 1);
            map.put(key, value);
        }
        return map;
    }

    public static String mapToString(Map<String, String> map) {
        StringBuilder str = new StringBuilder("");
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            str.append(entry.getKey()).append("=").append(entry.getValue()).append(" ");
        }
        return str.toString();
    }

    public String getApplicationName() {
        return this.getNextApplicationName();
    }

    public String getSubscriberIdentity() {
        return this.getSubscriberURI();
    }

    public int getOrder() {
        return this.order;
    }

    public void setStateInfo(int stateInfo) {
        this.order = stateInfo;
    }

    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void setOptionalParameters(HashMap<String, String> optionalParameters) {
        this.optionalParameters = optionalParameters;
    }

    public Map<String, Pattern> getHeaderPatternMap() {
        return this.headerPatternMap;
    }
}

