/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.router;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipApplicationRoutingRegionType;
import javax.servlet.sip.ar.SipRouteModifier;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.router.DefaultSipApplicationRouterInfo;

public class DefaultApplicationRouterParser {
    private static final int SIP_APPLICATION_ROUTER_INFO_PARAM_NB = 6;
    private static Logger log = Logger.getLogger(DefaultApplicationRouterParser.class);
    private Properties properties = new Properties();

    public void init(Properties props) {
        this.properties = props;
    }

    public void init() {
        String darConfigurationFileLocation = this.getDarConfigurationFileLocation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default Application Router file Location : " + darConfigurationFileLocation));
        }
        File darConfigurationFile = null;
        URL url = null;
        try {
            url = new URL(darConfigurationFileLocation);
        }
        catch (MalformedURLException e) {
            log.fatal((Object)"Cannot find the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " is not valid ! ", e);
        }
        try {
            darConfigurationFile = new File(new URI(darConfigurationFileLocation));
        }
        catch (URISyntaxException e) {
            darConfigurationFile = new File(url.getPath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(darConfigurationFile);
            this.properties.load(fis);
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"Cannot find the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " is not valid ! ", e);
        }
        catch (IOException e) {
            log.fatal((Object)"Cannot load the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " cannot be loaded ! ", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error((Object)("fail to close the following file " + darConfigurationFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    public Map<String, List<? extends SipApplicationRouterInfo>> parse() throws ParseException {
        HashMap<String, List<? extends SipApplicationRouterInfo>> sipApplicationRoutingInfo = new HashMap<String, List<? extends SipApplicationRouterInfo>>();
        for (Map.Entry<Object, Object> darEntry : this.properties.entrySet()) {
            String sipMethod = (String)darEntry.getKey();
            String sipApplicationRouterInfosStringified = (String)darEntry.getValue();
            List<? extends SipApplicationRouterInfo> sipApplicationRouterInfoList = this.parseSipApplicationRouterInfos(sipApplicationRouterInfosStringified);
            sipApplicationRoutingInfo.put(sipMethod, sipApplicationRouterInfoList);
        }
        return sipApplicationRoutingInfo;
    }

    public Map<String, List<? extends SipApplicationRouterInfo>> parse(String configuration) throws ParseException {
        Properties tempProperties = new Properties();
        ByteArrayInputStream stringStream = new ByteArrayInputStream(configuration.getBytes());
        try {
            tempProperties.load(stringStream);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to update AR configuration. Will use the old properties.");
            return null;
        }
        this.properties = tempProperties;
        return this.parse();
    }

    public Map<String, List<? extends SipApplicationRouterInfo>> parse(Properties properties) throws ParseException {
        this.properties = properties;
        return this.parse();
    }

    private List<? extends SipApplicationRouterInfo> parseSipApplicationRouterInfos(String sipApplicationRouterInfosStringified) throws ParseException {
        ArrayList<DefaultSipApplicationRouterInfo> sipApplicationRouterInfos = new ArrayList<DefaultSipApplicationRouterInfo>();
        while (sipApplicationRouterInfosStringified.indexOf("(") != -1) {
            int indexOfLeftParenthesis = sipApplicationRouterInfosStringified.indexOf("(");
            int indexOfRightParenthesis = sipApplicationRouterInfosStringified.indexOf(")");
            if (indexOfLeftParenthesis == -1 || indexOfRightParenthesis == -1) {
                throw new ParseException("Parenthesis expectected. Cannot parse the following string from the default application router file" + sipApplicationRouterInfosStringified, 0);
            }
            String sipApplicationRouterInfoStringified = sipApplicationRouterInfosStringified.substring(indexOfLeftParenthesis, indexOfRightParenthesis + 1);
            DefaultSipApplicationRouterInfo sipApplicationRouterInfo = this.parseSipApplicationRouterInfo(sipApplicationRouterInfoStringified);
            sipApplicationRouterInfos.add(sipApplicationRouterInfo);
            sipApplicationRouterInfosStringified = sipApplicationRouterInfosStringified.substring(indexOfRightParenthesis + 1);
        }
        Collections.sort(sipApplicationRouterInfos, new Comparator<DefaultSipApplicationRouterInfo>(){

            @Override
            public int compare(DefaultSipApplicationRouterInfo arg0, DefaultSipApplicationRouterInfo arg1) {
                if (arg0.getOrder() == arg1.getOrder()) {
                    return 0;
                }
                if (arg0.getOrder() > arg1.getOrder()) {
                    return 1;
                }
                return -1;
            }
        });
        return sipApplicationRouterInfos;
    }

    private DefaultSipApplicationRouterInfo parseSipApplicationRouterInfo(String sipApplicationRouterInfoStringified) throws ParseException {
        int indexOfRightQuote;
        int indexOfLeftQuote;
        String[] sipApplicationRouterInfoParameters = new String[6];
        for (int i = 0; i < 6; ++i) {
            String sipApplicationRouterInfoParameter;
            indexOfLeftQuote = sipApplicationRouterInfoStringified.indexOf("\"");
            if (indexOfLeftQuote == -1) {
                throw new ParseException("Left quote expected. Cannot parse the following string from the default application router file" + sipApplicationRouterInfoStringified, 0);
            }
            indexOfRightQuote = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1).indexOf("\"");
            if (indexOfRightQuote == -1) {
                throw new ParseException("Right quote expected. Cannot parse the following string from the default application router file " + sipApplicationRouterInfoStringified, 0);
            }
            sipApplicationRouterInfoParameters[i] = sipApplicationRouterInfoParameter = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1, (indexOfRightQuote += indexOfLeftQuote) + 1);
            sipApplicationRouterInfoStringified = sipApplicationRouterInfoStringified.substring(indexOfRightQuote + 2);
        }
        String optionalParameters = null;
        indexOfLeftQuote = sipApplicationRouterInfoStringified.indexOf("\"");
        if (indexOfLeftQuote != -1) {
            indexOfRightQuote = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1).indexOf("\"");
            if (indexOfRightQuote != -1) {
                optionalParameters = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1, (indexOfRightQuote += indexOfLeftQuote) + 1);
            } else {
                throw new ParseException("Expected a right quote in the optiona parameters", indexOfLeftQuote);
            }
        }
        int order = -1;
        try {
            order = Integer.parseInt(sipApplicationRouterInfoParameters[5]);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Impossible to parse the state info into an integer for this line " + sipApplicationRouterInfoStringified, 0);
        }
        return new DefaultSipApplicationRouterInfo(sipApplicationRouterInfoParameters[0], sipApplicationRouterInfoParameters[1], new SipApplicationRoutingRegion(sipApplicationRouterInfoParameters[2], (SipApplicationRoutingRegionType)SipApplicationRoutingRegionType.valueOf(SipApplicationRoutingRegionType.class, (String)sipApplicationRouterInfoParameters[2])), new String[]{sipApplicationRouterInfoParameters[3]}, (SipRouteModifier)SipRouteModifier.valueOf(SipRouteModifier.class, (String)sipApplicationRouterInfoParameters[4]), order, optionalParameters);
    }

    public String getDarConfigurationFileLocation() {
        return System.getProperty("javax.servlet.sip.dar");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

