/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.router;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.router.AppRouterCondition;
import org.mobicents.servlet.sip.router.DefaultApplicationRouterParser;
import org.mobicents.servlet.sip.router.DefaultSipApplicationRouterInfo;
import org.mobicents.servlet.sip.router.HeaderRegexCondition;
import org.mobicents.servlet.sip.router.ManageableApplicationRouter;

public class DefaultApplicationRouter
implements SipApplicationRouter,
ManageableApplicationRouter {
    private static final String DIRECTION_PARAMETER = "DIRECTION";
    private static final String REGEX_PARAMETER = "REGEX";
    private static final String REGEX_POPPED_ROUTE_PARAMETER = "REGEX_POPPED_ROUTE";
    private static final String DIRECTION_OUTBOUND = "OUTBOUND";
    private static final String DIRECTION_INBOUND = "INBOUND";
    private static final String DIRECTION_UAC_ROUTE_BACK = "UAC_ROUTE_BACK";
    private static Logger log = Logger.getLogger(DefaultApplicationRouter.class);
    private static final String DAR_SUSCRIBER_PREFIX = "DAR:";
    private static final String FROM = "From";
    private static final String TO = "To";
    private static final int DAR_SUSCRIBER_PREFIX_LENGTH = "DAR:".length();
    private static final String METHOD_WILDCARD = "ALL";
    private DefaultApplicationRouterParser defaultApplicationRouterParser;
    Set<String> containerDeployedApplicationNames = Collections.newSetFromMap(new ConcurrentHashMap());
    Map<String, List<? extends SipApplicationRouterInfo>> defaultSipApplicationRouterInfos;
    List<AppRouterCondition> conditions;

    public DefaultApplicationRouter() {
        this.defaultApplicationRouterParser = new DefaultApplicationRouterParser();
        this.defaultSipApplicationRouterInfos = new ConcurrentHashMap<String, List<? extends SipApplicationRouterInfo>>();
        this.conditions = new ArrayList<AppRouterCondition>();
        this.conditions.add(new HeaderRegexCondition());
    }

    public void applicationDeployed(List<String> newlyDeployedApplicationNames) {
        this.init();
        this.containerDeployedApplicationNames.addAll(newlyDeployedApplicationNames);
    }

    public void applicationUndeployed(List<String> undeployedApplicationNames) {
        this.init();
        this.containerDeployedApplicationNames.removeAll(undeployedApplicationNames);
    }

    public void destroy() {
        this.containerDeployedApplicationNames.clear();
    }

    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo targetedRequestInfo, Serializable stateInfo) {
        SipApplicationRouterInfo sipApplicationRouterInfo = null;
        if (initialRequest != null) {
            List<? extends SipApplicationRouterInfo> defaultSipApplicationRouterInfoList;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " checking for next application for request " + initialRequest + " , region=" + region + " , directive=" + directive + ", targetedRequestInfo=" + targetedRequestInfo + ", stateinfo=" + stateInfo + " with following dar " + this.defaultApplicationRouterParser.getProperties()));
            }
            if ((sipApplicationRouterInfo = this.getNextApplication(initialRequest, stateInfo, defaultSipApplicationRouterInfoList = this.defaultSipApplicationRouterInfos.get(initialRequest.getMethod()))) == null) {
                defaultSipApplicationRouterInfoList = this.defaultSipApplicationRouterInfos.get(METHOD_WILDCARD);
                sipApplicationRouterInfo = this.getNextApplication(initialRequest, stateInfo, defaultSipApplicationRouterInfoList);
            }
            if (sipApplicationRouterInfo != null) {
                return sipApplicationRouterInfo;
            }
        }
        return new SipApplicationRouterInfo(null, null, null, null, null, null);
    }

    private DefaultSipApplicationRouterInfo getFirstRequestApplicationEntry(List<? extends SipApplicationRouterInfo> defaultSipApplicationRouterInfoList, SipServletRequest initialRequest) {
        SipSession sipSession = initialRequest.getSession(false);
        if (sipSession != null) {
            String appName = sipSession.getApplicationSession().getApplicationName();
            for (DefaultSipApplicationRouterInfo defaultSipApplicationRouterInfo : defaultSipApplicationRouterInfoList) {
                if (!defaultSipApplicationRouterInfo.getApplicationName().equals(appName)) continue;
                return defaultSipApplicationRouterInfo;
            }
        }
        return null;
    }

    private SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, Serializable stateInfo, List<? extends SipApplicationRouterInfo> defaultSipApplicationRouterInfoList) {
        if (defaultSipApplicationRouterInfoList != null && defaultSipApplicationRouterInfoList.size() > 0) {
            int previousAppOrder = 0;
            if (stateInfo != null) {
                previousAppOrder = (Integer)stateInfo;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The previous app order was : " + previousAppOrder));
                }
            }
            ListIterator<? extends SipApplicationRouterInfo> defaultSipApplicationRouterInfoIt = defaultSipApplicationRouterInfoList.listIterator(previousAppOrder++);
            while (defaultSipApplicationRouterInfoIt.hasNext()) {
                String regExPoppedRoute;
                DefaultSipApplicationRouterInfo defaultSipApplicationRouterInfo = (DefaultSipApplicationRouterInfo)defaultSipApplicationRouterInfoIt.next();
                DefaultSipApplicationRouterInfo requestSipApplicationRouterInfo = this.getFirstRequestApplicationEntry(defaultSipApplicationRouterInfoList, initialRequest);
                String currentDirection = defaultSipApplicationRouterInfo.getOptionalParameters().get(DIRECTION_PARAMETER);
                String requestDirection = null;
                if (requestSipApplicationRouterInfo != null) {
                    requestDirection = requestSipApplicationRouterInfo.getOptionalParameters().get(DIRECTION_PARAMETER);
                } else if (initialRequest.getSession(false) != null) {
                    requestDirection = DIRECTION_OUTBOUND;
                }
                if (DIRECTION_OUTBOUND.equalsIgnoreCase(requestDirection) && DIRECTION_INBOUND.equalsIgnoreCase(currentDirection)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(defaultSipApplicationRouterInfo.getApplicationName() + " will not be called because we are routing the request out and the application has 'DIRECTION=INBOUND' hint."));
                    continue;
                }
                String regEx = defaultSipApplicationRouterInfo.getOptionalParameters().get(REGEX_PARAMETER);
                if (regEx != null) {
                    Pattern pattern = Pattern.compile(regEx);
                    Matcher matcher = pattern.matcher(initialRequest.toString());
                    if (matcher.find()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("initialRequest " + initialRequest + " matching regex pattern " + regEx + "begin index " + matcher.start() + " and ending at index " + matcher.end() + " for application " + defaultSipApplicationRouterInfo.getApplicationName()));
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("initialRequest " + initialRequest + " not matching regex pattern " + regEx + " skipping application " + defaultSipApplicationRouterInfo.getApplicationName()));
                        continue;
                    }
                }
                if ((regExPoppedRoute = defaultSipApplicationRouterInfo.getOptionalParameters().get(REGEX_POPPED_ROUTE_PARAMETER)) != null) {
                    Pattern pattern = Pattern.compile(regExPoppedRoute);
                    Matcher matcher = pattern.matcher(initialRequest.getPoppedRoute().toString());
                    if (matcher.find()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("initialRequest Popped Route" + initialRequest.getPoppedRoute() + " matching regex pattern " + regExPoppedRoute + "begin index " + matcher.start() + " and ending at index " + matcher.end() + " for application " + defaultSipApplicationRouterInfo.getApplicationName()));
                        }
                    } else {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("initialRequest Popped Route" + initialRequest.getPoppedRoute() + " matching regex pattern " + regExPoppedRoute + " skipping application " + defaultSipApplicationRouterInfo.getApplicationName()));
                        continue;
                    }
                }
                if (!this.checkConditions(initialRequest, defaultSipApplicationRouterInfo)) continue;
                boolean isApplicationPresentInContainer = false;
                if (this.containerDeployedApplicationNames.contains(defaultSipApplicationRouterInfo.getApplicationName())) {
                    isApplicationPresentInContainer = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(defaultSipApplicationRouterInfo.getApplicationName() + " is present in the container."));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("this " + this + " " + defaultSipApplicationRouterInfo.getApplicationName() + " is NOT present in the container."));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Route Modifier : " + defaultSipApplicationRouterInfo.getRouteModifier()));
                    log.debug((Object)("Previous App Name : " + defaultSipApplicationRouterInfoList.listIterator(previousAppOrder).previous().getNextApplicationName()));
                    log.debug((Object)("Previous App Route Region : " + defaultSipApplicationRouterInfoList.listIterator(previousAppOrder).previous().getRoutingRegion()));
                    log.debug((Object)("Current App Name : " + defaultSipApplicationRouterInfo.getNextApplicationName()));
                    log.debug((Object)("Current App Route Region : " + defaultSipApplicationRouterInfo.getRoutingRegion()));
                }
                if (!isApplicationPresentInContainer && SipRouteModifier.NO_ROUTE.equals((Object)defaultSipApplicationRouterInfo.getRouteModifier())) continue;
                SipSession initialSession = initialRequest.getSession(false);
                String initialAppName = null;
                String initialRoutingRegion = null;
                String defaultSipApplicationRouterAppName = null;
                String defaultSipApplicationRouterRoutingRegion = null;
                if (initialSession != null) {
                    initialAppName = initialRequest.getSession(false).getApplicationSession().getApplicationName();
                    initialRoutingRegion = defaultSipApplicationRouterInfoList.listIterator(previousAppOrder).previous().getRoutingRegion().toString();
                    defaultSipApplicationRouterAppName = defaultSipApplicationRouterInfo.getApplicationName();
                    defaultSipApplicationRouterRoutingRegion = defaultSipApplicationRouterInfo.getRoutingRegion().toString();
                }
                if (initialSession != null && defaultSipApplicationRouterAppName.equals(initialAppName) && (!defaultSipApplicationRouterAppName.equals(initialAppName) || initialRoutingRegion.equals(defaultSipApplicationRouterRoutingRegion)) && (requestDirection == null || !defaultSipApplicationRouterAppName.equals(initialAppName) || !DIRECTION_UAC_ROUTE_BACK.equals(requestDirection) || stateInfo != null)) continue;
                String subscriberIdentity = defaultSipApplicationRouterInfo.getSubscriberIdentity();
                if (subscriberIdentity.indexOf(DAR_SUSCRIBER_PREFIX) != -1) {
                    String headerName = subscriberIdentity.substring(DAR_SUSCRIBER_PREFIX_LENGTH);
                    subscriberIdentity = FROM.equalsIgnoreCase(headerName) ? initialRequest.getFrom().getURI().toString() : (TO.equalsIgnoreCase(headerName) ? initialRequest.getTo().getURI().toString() : initialRequest.getHeader(headerName));
                }
                return new SipApplicationRouterInfo(defaultSipApplicationRouterInfo.getApplicationName(), defaultSipApplicationRouterInfo.getRoutingRegion(), subscriberIdentity, defaultSipApplicationRouterInfo.getRoutes(), defaultSipApplicationRouterInfo.getRouteModifier(), (Serializable)Integer.valueOf(defaultSipApplicationRouterInfo.getOrder()));
            }
        }
        return null;
    }

    private boolean checkConditions(SipServletRequest initialRequest, DefaultSipApplicationRouterInfo info) {
        boolean allConditionsMet = true;
        Iterator<AppRouterCondition> iterator = this.conditions.iterator();
        while (allConditionsMet && iterator.hasNext()) {
            boolean condMet = iterator.next().checkCondition(initialRequest, info);
            allConditionsMet = allConditionsMet && condMet;
        }
        return allConditionsMet;
    }

    public void init() {
        this.defaultApplicationRouterParser.init();
        try {
            this.defaultSipApplicationRouterInfos = this.defaultApplicationRouterParser.parse();
        }
        catch (ParseException e) {
            log.fatal((Object)"Impossible to parse the default application router configuration file", (Throwable)e);
            throw new IllegalArgumentException("Impossible to parse the default application router configuration file", e);
        }
    }

    public void init(Properties properties) {
        this.defaultApplicationRouterParser.init(properties);
        try {
            this.defaultSipApplicationRouterInfos = this.defaultApplicationRouterParser.parse();
        }
        catch (ParseException e) {
            log.fatal((Object)"Impossible to parse the default application router configuration file", (Throwable)e);
            throw new IllegalArgumentException("Impossible to parse the default application router configuration file", e);
        }
    }

    public void configure(Object configuration) {
        int i;
        if (!(configuration instanceof Properties) && !(configuration.toString() instanceof String)) {
            throw new IllegalArgumentException("Configuration for DAR must be of type Properties or String; " + configuration.getClass().getName() + " was received");
        }
        Properties properties = new Properties();
        if (configuration instanceof String) {
            try {
                properties.load(new StringReader((String)configuration));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (configuration instanceof Properties) {
            properties = (Properties)configuration;
        }
        try {
            this.defaultSipApplicationRouterInfos = this.defaultApplicationRouterParser.parse(properties);
        }
        catch (ParseException e1) {
            throw new IllegalArgumentException("Failed to parse the new DAR properties", e1);
        }
        String configFileLocation = this.defaultApplicationRouterParser.getDarConfigurationFileLocation();
        if (configFileLocation.startsWith("file:/")) {
            i = 5;
            while (configFileLocation.charAt(i) == '/') {
                ++i;
            }
        } else {
            log.warn((Object)("Can not write persist DAR configuration to " + configFileLocation + ". Make sure you have write permissions and make sure it's a local file. NOTE THAT THE NEW DAR CONFIGURATION IS LOADED AND EFFECTIVE."));
            return;
        }
        configFileLocation = configFileLocation.substring(i - 1);
        if (configFileLocation == null || configFileLocation.length() < 1) {
            throw new IllegalStateException("Configuration file name is empty.");
        }
        File configFile = new File(configFileLocation);
        FileOutputStream fis = null;
        try {
            fis = new FileOutputStream(configFile);
            properties.store(fis, "Application Router Configuration");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to store configuration file.", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error((Object)("fail to close the following file " + configFile.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        log.info((Object)("Stored DAR configuration in " + configFile.getAbsolutePath()));
    }

    public Object getCurrentConfiguration() {
        return this.defaultApplicationRouterParser.getProperties();
    }

    public Map<String, List<? extends SipApplicationRouterInfo>> getConfiguration() {
        return this.defaultSipApplicationRouterInfos;
    }
}

