/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.router;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipApplicationRoutingRegionType;
import javax.servlet.sip.ar.SipRouteModifier;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.router.DefaultSipApplicationRouterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationRouterParser {
    private static final int SIP_APPLICATION_ROUTER_INFO_PARAM_NB = 6;
    private static Logger log = Logger.getLogger(DefaultApplicationRouterParser.class);
    private Properties properties = new Properties();

    public void init() {
        String darConfigurationFileLocation = this.getDarConfigurationFileLocation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Default Application Router file Location : " + darConfigurationFileLocation));
        }
        File darConfigurationFile = null;
        try {
            darConfigurationFile = new File(new URI(darConfigurationFileLocation));
        }
        catch (URISyntaxException e) {
            log.fatal((Object)"Cannot find the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " is not valid ! ", e);
        }
        try {
            FileInputStream fis = new FileInputStream(darConfigurationFile);
            this.properties.load(fis);
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"Cannot find the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " is not valid ! ", e);
        }
        catch (IOException e) {
            log.fatal((Object)"Cannot load the default application router file ! ", (Throwable)e);
            throw new IllegalArgumentException("The Default Application Router file Location : " + darConfigurationFileLocation + " cannot be loaded ! ", e);
        }
    }

    public Map<String, List<DefaultSipApplicationRouterInfo>> parse() throws ParseException {
        HashMap<String, List<DefaultSipApplicationRouterInfo>> sipApplicationRoutingInfo = new HashMap<String, List<DefaultSipApplicationRouterInfo>>();
        for (Map.Entry<Object, Object> darEntry : this.properties.entrySet()) {
            String sipMethod = (String)darEntry.getKey();
            String sipApplicationRouterInfosStringified = (String)darEntry.getValue();
            List<DefaultSipApplicationRouterInfo> sipApplicationRouterInfoList = this.parseSipApplicationRouterInfos(sipApplicationRouterInfosStringified);
            sipApplicationRoutingInfo.put(sipMethod, sipApplicationRouterInfoList);
        }
        return sipApplicationRoutingInfo;
    }

    public Map<String, List<DefaultSipApplicationRouterInfo>> parse(String configuration) throws ParseException {
        HashMap sipApplicationRoutingInfo = new HashMap();
        Properties tempProperties = new Properties();
        ByteArrayInputStream stringStream = new ByteArrayInputStream(configuration.getBytes());
        try {
            tempProperties.load(stringStream);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to update AR configuration. Will use the old properties.");
            return null;
        }
        this.properties = tempProperties;
        return this.parse();
    }

    public Map<String, List<DefaultSipApplicationRouterInfo>> parse(Properties properties) throws ParseException {
        HashMap sipApplicationRoutingInfo = new HashMap();
        this.properties = properties;
        return this.parse();
    }

    private List<DefaultSipApplicationRouterInfo> parseSipApplicationRouterInfos(String sipApplicationRouterInfosStringified) throws ParseException {
        ArrayList<DefaultSipApplicationRouterInfo> sipApplicationRouterInfos = new ArrayList<DefaultSipApplicationRouterInfo>();
        while (sipApplicationRouterInfosStringified.indexOf("(") != -1) {
            int indexOfLeftParenthesis = sipApplicationRouterInfosStringified.indexOf("(");
            int indexOfRightParenthesis = sipApplicationRouterInfosStringified.indexOf(")");
            if (indexOfLeftParenthesis == -1 || indexOfRightParenthesis == -1) {
                throw new ParseException("Cannot parse the following string from the default application router file" + sipApplicationRouterInfosStringified, 0);
            }
            String sipApplicationRouterInfoStringified = sipApplicationRouterInfosStringified.substring(indexOfLeftParenthesis, indexOfRightParenthesis + 1);
            DefaultSipApplicationRouterInfo sipApplicationRouterInfo = this.parseSipApplicationRouterInfo(sipApplicationRouterInfoStringified);
            sipApplicationRouterInfos.add(sipApplicationRouterInfo.getOrder(), sipApplicationRouterInfo);
            sipApplicationRouterInfosStringified = sipApplicationRouterInfosStringified.substring(indexOfRightParenthesis + 1);
        }
        return sipApplicationRouterInfos;
    }

    private DefaultSipApplicationRouterInfo parseSipApplicationRouterInfo(String sipApplicationRouterInfoStringified) throws ParseException {
        String[] sipApplicationRouterInfoParameters = new String[6];
        for (int i = 0; i < 6; ++i) {
            String sipApplicationRouterInfoParameter;
            int indexOfLeftQuote = sipApplicationRouterInfoStringified.indexOf("\"");
            if (indexOfLeftQuote == -1) {
                throw new ParseException("Cannot parse the following string from the default application router file" + sipApplicationRouterInfoStringified, 0);
            }
            int indexOfRightQuote = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1).indexOf("\"");
            if (indexOfRightQuote == -1) {
                throw new ParseException("Cannot parse the following string from the default application router file " + sipApplicationRouterInfoStringified, 0);
            }
            sipApplicationRouterInfoParameters[i] = sipApplicationRouterInfoParameter = sipApplicationRouterInfoStringified.substring(indexOfLeftQuote + 1, (indexOfRightQuote += indexOfLeftQuote) + 1);
            sipApplicationRouterInfoStringified = sipApplicationRouterInfoStringified.substring(indexOfRightQuote + 2);
        }
        int order = -1;
        try {
            order = Integer.parseInt(sipApplicationRouterInfoParameters[5]);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Impossible to parse the state info into an integer for this line " + sipApplicationRouterInfoStringified, 0);
        }
        return new DefaultSipApplicationRouterInfo(sipApplicationRouterInfoParameters[0], sipApplicationRouterInfoParameters[1], new SipApplicationRoutingRegion(sipApplicationRouterInfoParameters[2], (SipApplicationRoutingRegionType)SipApplicationRoutingRegionType.valueOf(SipApplicationRoutingRegionType.class, (String)sipApplicationRouterInfoParameters[2])), new String[]{sipApplicationRouterInfoParameters[3]}, (SipRouteModifier)SipRouteModifier.valueOf(SipRouteModifier.class, (String)sipApplicationRouterInfoParameters[4]), order);
    }

    public String getDarConfigurationFileLocation() {
        return System.getProperty("javax.servlet.sip.dar");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

