/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.router;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.router.DefaultApplicationRouterParser;
import org.mobicents.servlet.sip.router.DefaultSipApplicationRouterInfo;
import org.mobicents.servlet.sip.router.ManageableApplicationRouter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationRouter
implements SipApplicationRouter,
ManageableApplicationRouter {
    private static Logger log = Logger.getLogger(DefaultApplicationRouter.class);
    private static final String DAR_SUSCRIBER_PREFIX = "DAR:";
    private static final int DAR_SUSCRIBER_PREFIX_LENGTH = "DAR:".length();
    private DefaultApplicationRouterParser defaultApplicationRouterParser;
    Set<String> containerDeployedApplicationNames = new HashSet<String>();
    Map<String, List<DefaultSipApplicationRouterInfo>> defaultSipApplicationRouterInfos;

    public DefaultApplicationRouter() {
        this.defaultApplicationRouterParser = new DefaultApplicationRouterParser();
        this.defaultSipApplicationRouterInfos = new ConcurrentHashMap<String, List<DefaultSipApplicationRouterInfo>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationDeployed(List<String> newlyDeployedApplicationNames) {
        this.init();
        Set<String> set = this.containerDeployedApplicationNames;
        synchronized (set) {
            this.containerDeployedApplicationNames.addAll(newlyDeployedApplicationNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationUndeployed(List<String> undeployedApplicationNames) {
        this.init();
        Set<String> set = this.containerDeployedApplicationNames;
        synchronized (set) {
            this.containerDeployedApplicationNames.removeAll(undeployedApplicationNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Set<String> set = this.containerDeployedApplicationNames;
        synchronized (set) {
            this.containerDeployedApplicationNames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo targetedRequestInfo, Serializable stateInfo) {
        List<DefaultSipApplicationRouterInfo> defaultSipApplicationRouterInfoList;
        if (initialRequest != null && (defaultSipApplicationRouterInfoList = this.defaultSipApplicationRouterInfos.get(initialRequest.getMethod())) != null && defaultSipApplicationRouterInfoList.size() > 0) {
            int previousAppOrder = 0;
            if (stateInfo != null) {
                previousAppOrder = (Integer)stateInfo;
            }
            ListIterator<DefaultSipApplicationRouterInfo> defaultSipApplicationRouterInfoIt = defaultSipApplicationRouterInfoList.listIterator(previousAppOrder++);
            while (defaultSipApplicationRouterInfoIt.hasNext()) {
                DefaultSipApplicationRouterInfo defaultSipApplicationRouterInfo = defaultSipApplicationRouterInfoIt.next();
                boolean isApplicationPresentInContainer = false;
                Set<String> set = this.containerDeployedApplicationNames;
                synchronized (set) {
                    if (this.containerDeployedApplicationNames.contains(defaultSipApplicationRouterInfo.getApplicationName())) {
                        isApplicationPresentInContainer = true;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Route Modifier : " + defaultSipApplicationRouterInfo.getRouteModifier()));
                }
                if (!isApplicationPresentInContainer && SipRouteModifier.NO_ROUTE.equals((Object)defaultSipApplicationRouterInfo.getRouteModifier()) || initialRequest.getSession(false) != null && defaultSipApplicationRouterInfo.getApplicationName().equals(initialRequest.getSession(false).getApplicationSession().getApplicationName())) continue;
                String subscriberIdentity = defaultSipApplicationRouterInfo.getSubscriberIdentity();
                if (subscriberIdentity.indexOf(DAR_SUSCRIBER_PREFIX) != -1) {
                    String headerName = subscriberIdentity.substring(DAR_SUSCRIBER_PREFIX_LENGTH);
                    subscriberIdentity = initialRequest.getHeader(headerName);
                }
                return new SipApplicationRouterInfo(defaultSipApplicationRouterInfo.getApplicationName(), defaultSipApplicationRouterInfo.getRoutingRegion(), subscriberIdentity, defaultSipApplicationRouterInfo.getRoutes(), defaultSipApplicationRouterInfo.getRouteModifier(), (Serializable)Integer.valueOf(defaultSipApplicationRouterInfo.getOrder()));
            }
        }
        return new SipApplicationRouterInfo(null, null, null, null, null, null);
    }

    public void init() {
        this.defaultApplicationRouterParser.init();
        try {
            this.defaultSipApplicationRouterInfos = this.defaultApplicationRouterParser.parse();
        }
        catch (ParseException e) {
            log.fatal((Object)"Impossible to parse the default application router configuration file", (Throwable)e);
            throw new IllegalArgumentException("Impossible to parse the default application router configuration file", e);
        }
    }

    public void init(Properties properties) {
        this.init();
    }

    public synchronized void configure(Object configuration) {
        int i;
        if (!(configuration instanceof Properties)) {
            throw new IllegalArgumentException("Configuration for DAR must be of type Properties.");
        }
        Properties properties = (Properties)configuration;
        try {
            this.defaultSipApplicationRouterInfos = this.defaultApplicationRouterParser.parse(properties);
        }
        catch (ParseException e1) {
            throw new IllegalArgumentException("Failed to parse the new DAR properties", e1);
        }
        String configFileLocation = this.defaultApplicationRouterParser.getDarConfigurationFileLocation();
        if (configFileLocation.startsWith("file:/")) {
            i = 5;
            while (configFileLocation.charAt(i) == '/') {
                ++i;
            }
        } else {
            log.warn((Object)("Can not write persist DAR configuration to " + configFileLocation + ". Make sure you have write permissions and make sure it's a local file. NOTE THAT THE NEW DAR CONFIGURATION IS LOADED AND EFFECTIVE."));
            return;
        }
        configFileLocation = configFileLocation.substring(i - 1);
        if (configFileLocation == null || configFileLocation.length() < 1) {
            throw new IllegalStateException("Configuration file name is empty.");
        }
        File configFile = new File(configFileLocation);
        try {
            properties.store(new FileOutputStream(configFile), "Application Router Configuration");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to store configuration file.", e);
        }
        log.info((Object)("Stored DAR configuration in " + configFile.getAbsolutePath()));
    }

    public synchronized Object getCurrentConfiguration() {
        return this.defaultApplicationRouterParser.getProperties();
    }
}

