/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class SimpleSipServlet
extends SipServlet
implements SipErrorListener,
TimerListener {
    private static final String TEST_REGISTER_C_SEQ = "testRegisterCSeq";
    private static final String TEST_SUBSCRIBER_URI = "testSubscriberUri";
    private static final String TEST_EXTERNAL_ROUTING = "testExternalRouting";
    private static final String TEST_EXTERNAL_ROUTING_NO_INFO = "testExternalRoutingNoInfo";
    private static final String TEST_NON_EXISTING_HEADER = "TestNonExistingHeader";
    private static final String TEST_ALLOW_HEADER = "TestAllowHeader";
    private static final String TEST_TO_TAG = "TestToTag";
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String CANCEL_RECEIVED = "cancelReceived";
    private static final String SUBSCRIBER_URI = "sip:testSubscriberUri@sip-servlets.com";
    @Resource
    SipFactory sipFactory;
    @Resource
    TimerService timerService;
    private static transient Logger logger = Logger.getLogger(SimpleSipServlet.class);
    private static String TEST_REINVITE_USERNAME = "reinvite";
    private static String TEST_CANCEL_USERNAME = "cancel";

    protected void doBranchResponse(SipServletResponse resp) throws ServletException, IOException {
        resp.getApplicationSession().setAttribute("doBranchResponse", (Object)"true");
        super.doBranchResponse(resp);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the simple sip servlet has been started");
        super.init(servletConfig);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        SipServletResponse sipServletResponse;
        logger.info((Object)("from : " + request.getFrom()));
        logger.info((Object)("Got request: " + request.getMethod()));
        if (request.getParameterableHeader("additionalParameterableHeader") != null) {
            request.getParameterableHeader("additionalParameterableHeader").setParameter("dsfds", "value");
            boolean error = false;
            try {
                request.getParameterableHeader("nonParameterableHeader").setParameter("dsfds", "value");
            }
            catch (ServletParseException e) {
                error = true;
            }
            if (error) {
                request.createResponse(200).send();
            }
            return;
        }
        request.createResponse(100).send();
        String fromString = request.getFrom().toString();
        if (fromString.contains(TEST_EXTERNAL_ROUTING_NO_INFO)) {
            SipServletResponse sipServletResponse2 = request.createResponse(200);
            this.timerService.createTimer(request.getApplicationSession(), 1000L, false, (Serializable)sipServletResponse2);
            return;
        }
        if (fromString.contains(TEST_EXTERNAL_ROUTING)) {
            SipServletResponse sipServletResponse3 = request.createResponse(180);
            sipServletResponse3.send();
            sipServletResponse3 = request.createResponse(200);
            this.timerService.createTimer(request.getApplicationSession(), 1000L, false, (Serializable)sipServletResponse3);
            return;
        }
        if (fromString.contains(TEST_ALLOW_HEADER)) {
            SipServletResponse sipServletResponse4 = request.createResponse(405);
            sipServletResponse4.setHeader("Allow", "INVITE, ACK, CANCEL, OPTIONS, BYE");
            sipServletResponse4.addHeader("Allow", "SUBSCRIBE, NOTIFY");
            sipServletResponse4.addHeader("Allow", "REFER");
            sipServletResponse4.send();
            return;
        }
        logger.info((Object)("Subscriber URI received : " + request.getSubscriberURI()));
        if (fromString.contains(TEST_SUBSCRIBER_URI) && !SUBSCRIBER_URI.equalsIgnoreCase(request.getSubscriberURI().toString())) {
            SipServletResponse sipServletResponse5 = request.createResponse(500);
            sipServletResponse5.send();
            return;
        }
        if (fromString.contains(TEST_TO_TAG)) {
            Address fromAddress = request.getFrom();
            Address toAddress = this.sipFactory.createAddress(request.getRequestURI(), request.getTo().getDisplayName());
            SipServletRequest newRequest = this.sipFactory.createRequest(request.getApplicationSession(), "INVITE", fromAddress, toAddress);
            if (newRequest.getTo().getParameter("tag") != null) {
                logger.error((Object)"the ToTag should be empty, sending 500 response");
                SipServletResponse sipServletResponse6 = request.createResponse(500);
                sipServletResponse6.send();
                return;
            }
        }
        request.getAddressHeader(TEST_NON_EXISTING_HEADER);
        request.getHeader(TEST_NON_EXISTING_HEADER);
        request.getHeaders(TEST_NON_EXISTING_HEADER);
        request.getParameterableHeader("Reply-To");
        request.getParameterableHeaders("Reply-To");
        if (fromString.contains(TEST_REGISTER_C_SEQ)) {
            sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
            SipApplicationSession app = this.sipFactory.createApplicationSession();
            this.sipFactory.createRequest(app, "REGISTER", "sip:me@simple-servlet.com", "sip:you@localhost:5058").send();
            return;
        }
        if (!TEST_CANCEL_USERNAME.equalsIgnoreCase(((SipURI)request.getFrom().getURI()).getUser())) {
            sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        } else {
            sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        }
    }

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
        if (req.getFrom().getURI() instanceof SipURI && TEST_REINVITE_USERNAME.equalsIgnoreCase(((SipURI)req.getFrom().getURI()).getUser())) {
            SipServletRequest reInvite = req.getSession(false).createRequest("INVITE");
            if (reInvite.getHeader("Contact").contains("0.0.0.0")) {
                logger.error((Object)"Reinvite doesn't add correct address. We must not see 0.0.0.0 here");
                return;
            }
            if (req.getSession(false) == reInvite.getSession(false)) {
                reInvite.send();
            } else {
                logger.error((Object)"the newly created subsequent request doesn't have the same session instance as the one it has been created from");
            }
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getMethod().equalsIgnoreCase("REGISTER")) {
            int cseq = Integer.parseInt(resp.getRequest().getHeader("CSeq").substring(0, 1));
            if (cseq < 4) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (resp.getSession().getState().equals((Object)SipSession.State.INITIAL)) {
                    resp.getSession().createRequest("REGISTER").send();
                }
            }
            return;
        }
        if (!"BYE".equalsIgnoreCase(resp.getMethod())) {
            resp.createAck().send();
            resp.getSession(false).createRequest("BYE").send();
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        if (!"true".equals(request.getApplicationSession().getAttribute("doBranchResponse"))) {
            sipServletResponse.send();
        }
    }

    protected void doCancel(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got CANCEL request: " + request));
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        try {
            SipServletRequest sipServletRequest = sipFactory.createRequest(sipFactory.createApplicationSession(), "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = sipFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(CANCEL_RECEIVED.length());
            sipServletRequest.setContent((Object)CANCEL_RECEIVED, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        Address contact = req.getAddressHeader("Contact");
        contact.setExpires(3600);
        logger.info((Object)("REGISTER Contact Address.toString = " + contact.toString()));
        int response = 200;
        if (!"<sip:sender@127.0.0.1:5080;transport=udp;lr>;expires=3600".equals(contact.toString())) {
            response = 500;
        }
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    protected void doInfo(SipServletRequest req) throws ServletException, IOException {
        String content = (String)req.getContent();
        req.getSession().setAttribute("mutable", (Object)content);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int response = 200;
        if (!content.equals(req.getSession().getAttribute("mutable"))) {
            response = 500;
        }
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.error((Object)"noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.error((Object)"noPrackReceived.");
    }

    public void timeout(ServletTimer timer) {
        SipServletResponse sipServletResponse = (SipServletResponse)timer.getInfo();
        try {
            sipServletResponse.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the OK", (Throwable)e);
        }
    }
}

