/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class SimpleSipServlet
extends SipServlet
implements SipErrorListener,
TimerListener {
    private static final String TEST_NON_EXISTING_HEADER = "TestNonExistingHeader";
    private static final String TEST_ALLOW_HEADER = "TestAllowHeader";
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String CANCEL_RECEIVED = "cancelReceived";
    @Resource
    SipFactory sipFactory;
    @Resource
    TimerService timerService;
    private static transient Logger logger = Logger.getLogger(SimpleSipServlet.class);
    private static String TEST_REINVITE_USERNAME = "reinvite";
    private static String TEST_CANCEL_USERNAME = "cancel";

    protected void doBranchResponse(SipServletResponse resp) throws ServletException, IOException {
        resp.getApplicationSession().setAttribute("doBranchResponse", (Object)"true");
        super.doBranchResponse(resp);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the simple sip servlet has been started");
        super.init(servletConfig);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("from : " + request.getFrom()));
        logger.info((Object)("Got request: " + request.getMethod()));
        if (request.getFrom().toString().contains("testExternalRoutingNoInfo")) {
            SipServletResponse sipServletResponse = request.createResponse(200);
            this.timerService.createTimer(request.getApplicationSession(), 1000L, false, (Serializable)sipServletResponse);
            return;
        }
        if (request.getFrom().toString().contains("testExternalRouting")) {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            this.timerService.createTimer(request.getApplicationSession(), 1000L, false, (Serializable)sipServletResponse);
            return;
        }
        if (request.getFrom().toString().contains(TEST_ALLOW_HEADER)) {
            SipServletResponse sipServletResponse = request.createResponse(405);
            sipServletResponse.setHeader("Allow", "INVITE, ACK, CANCEL, OPTIONS, BYE");
            sipServletResponse.addHeader("Allow", "SUBSCRIBE, NOTIFY");
            sipServletResponse.addHeader("Allow", "REFER");
            sipServletResponse.send();
            return;
        }
        request.getAddressHeader(TEST_NON_EXISTING_HEADER);
        request.getHeader(TEST_NON_EXISTING_HEADER);
        request.getHeaders(TEST_NON_EXISTING_HEADER);
        request.getParameterableHeader("Reply-To");
        request.getParameterableHeaders("Reply-To");
        if (request.getFrom().toString().contains("testRegisterCSeq")) {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
            SipApplicationSession app = this.sipFactory.createApplicationSession();
            this.sipFactory.createRequest(app, "REGISTER", "sip:me@simple-servlet.com", "sip:you@localhost:5058").send();
            return;
        }
        if (!TEST_CANCEL_USERNAME.equalsIgnoreCase(((SipURI)request.getFrom().getURI()).getUser())) {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        } else {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        }
    }

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
        if (req.getFrom().getURI() instanceof SipURI && TEST_REINVITE_USERNAME.equalsIgnoreCase(((SipURI)req.getFrom().getURI()).getUser())) {
            SipServletRequest reInvite = req.getSession(false).createRequest("INVITE");
            if (req.getSession(false) == reInvite.getSession(false)) {
                reInvite.send();
            } else {
                logger.error((Object)"the newly created subsequent request doesn't have the same session instance as the one it has been created from");
            }
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getMethod().equalsIgnoreCase("REGISTER")) {
            int cseq = Integer.parseInt(resp.getRequest().getHeader("CSeq").substring(0, 1));
            if (cseq < 4) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (resp.getSession().getState().equals((Object)SipSession.State.INITIAL)) {
                    resp.getSession().createRequest("REGISTER").send();
                }
            }
            return;
        }
        if (!"BYE".equalsIgnoreCase(resp.getMethod())) {
            resp.createAck().send();
            resp.getSession(false).createRequest("BYE").send();
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        if (!"true".equals(request.getApplicationSession().getAttribute("doBranchResponse"))) {
            sipServletResponse.send();
        }
    }

    protected void doCancel(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got CANCEL request: " + request));
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        try {
            SipServletRequest sipServletRequest = sipFactory.createRequest(sipFactory.createApplicationSession(), "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = sipFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(CANCEL_RECEIVED.length());
            sipServletRequest.setContent((Object)CANCEL_RECEIVED, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }

    protected void doRegister(SipServletRequest req) throws ServletException, IOException {
        Address contact = req.getAddressHeader("Contact");
        contact.setExpires(3600);
        logger.info((Object)("REGISTER Contact Address.toString = " + contact.toString()));
        int response = 200;
        if (!"<sip:sender@127.0.0.1:5080;transport=udp;lr>;expires=3600".equals(contact.toString())) {
            response = 500;
        }
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    protected void doInfo(SipServletRequest req) throws ServletException, IOException {
        String content = (String)req.getContent();
        req.getSession().setAttribute("mutable", (Object)content);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int response = 200;
        if (!content.equals(req.getSession().getAttribute("mutable"))) {
            response = 500;
        }
        SipServletResponse resp = req.createResponse(response);
        resp.send();
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.error((Object)"noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.error((Object)"noPrackReceived.");
    }

    public void timeout(ServletTimer timer) {
        SipServletResponse sipServletResponse = (SipServletResponse)timer.getInfo();
        try {
            sipServletResponse.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the OK", (Throwable)e);
        }
    }
}

