/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSipServlet
extends SipServlet
implements SipErrorListener,
Servlet {
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String CANCEL_RECEIVED = "cancelReceived";
    private static Log logger = LogFactory.getLog(SimpleSipServlet.class);
    private static String TEST_REINVITE_USERNAME = "reinvite";
    private static String TEST_CANCEL_USERNAME = "cancel";

    protected void doBranchResponse(SipServletResponse resp) throws ServletException, IOException {
        resp.getApplicationSession().setAttribute("doBranchResponse", (Object)"true");
        super.doBranchResponse(resp);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the simple sip servlet has been started");
        super.init(servletConfig);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("from : " + request.getFrom()));
        logger.info((Object)("Got request: " + request.getMethod()));
        if (!TEST_CANCEL_USERNAME.equalsIgnoreCase(((SipURI)request.getFrom().getURI()).getUser())) {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        } else {
            SipServletResponse sipServletResponse = request.createResponse(180);
            sipServletResponse.send();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sipServletResponse = request.createResponse(200);
            sipServletResponse.send();
        }
    }

    protected void doAck(SipServletRequest req) throws ServletException, IOException {
        if (req.getFrom().getURI() instanceof SipURI && TEST_REINVITE_USERNAME.equalsIgnoreCase(((SipURI)req.getFrom().getURI()).getUser())) {
            SipServletRequest reInvite = req.getSession(false).createRequest("INVITE");
            if (req.getSession(false) == reInvite.getSession(false)) {
                reInvite.send();
            } else {
                logger.error((Object)"the newly created subsequent request doesn't have the same session instance as the one it has been created from");
            }
        }
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        if (!"BYE".equalsIgnoreCase(resp.getMethod())) {
            resp.createAck().send();
            resp.getSession(false).createRequest("BYE").send();
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        if (!"true".equals(request.getApplicationSession().getAttribute("doBranchResponse"))) {
            sipServletResponse.send();
        }
    }

    protected void doCancel(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got CANCEL request: " + request));
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        try {
            SipServletRequest sipServletRequest = sipFactory.createRequest(sipFactory.createApplicationSession(), "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = sipFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(CANCEL_RECEIVED.length());
            sipServletRequest.setContent((Object)CANCEL_RECEIVED, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }

    public void noAckReceived(SipErrorEvent ee) {
        logger.error((Object)"noAckReceived.");
    }

    public void noPrackReceived(SipErrorEvent ee) {
        logger.error((Object)"noPrackReceived.");
    }
}

