/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.mobicents.javax.servlet.sip.SipServletRequestExt;
import org.mobicents.javax.servlet.sip.SipSessionExt;

public class ShootistSipServlet
extends SipServlet
implements SipServletListener,
TimerListener,
SipSessionListener,
SipApplicationSessionListener {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String ENCODE_URI = "encodedURI";
    private static final String TEST_ERROR_RESPONSE = "testErrorResponse";
    private static transient Logger logger = Logger.getLogger(ShootistSipServlet.class);
    @Resource
    TimerService timerService;
    @Resource
    SipFactory sipFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the shootist has been started");
        super.init(servletConfig);
    }

    protected void doProvisionalResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getHeader("require") != null) {
            SipServletRequest prack = resp.createPrack();
            SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
            prack.setRequestURI((URI)requestURI);
            prack.send();
        }
    }

    protected void doSuccessResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        logger.info((Object)("Got : " + sipServletResponse.getStatus() + " " + sipServletResponse.getMethod()));
        int status = sipServletResponse.getStatus();
        if (status == 200 && "INVITE".equalsIgnoreCase(sipServletResponse.getMethod())) {
            SipServletRequest ackRequest = sipServletResponse.createAck();
            ackRequest.send();
            if (sipServletResponse.getRequest().isInitial() && !(sipServletResponse.getFrom().getURI() instanceof TelURL) && !(sipServletResponse.getTo().getURI() instanceof TelURL) && (((SipURI)sipServletResponse.getFrom().getURI()).getUser().equals("reinvite") || ((SipURI)sipServletResponse.getTo().getURI()).getUser().equals("reinvite"))) {
                SipServletRequest request = sipServletResponse.getSession().createRequest("INVITE");
                request.send();
            } else if (sipServletResponse.getApplicationSession().getAttribute(ENCODE_URI) == null) {
                String timeToWaitForBye = this.getServletContext().getInitParameter("timeToWaitForBye");
                int delay = 2000;
                if (timeToWaitForBye != null) {
                    delay = Integer.parseInt(timeToWaitForBye);
                }
                SipServletRequest sipServletRequest = sipServletResponse.getSession().createRequest("BYE");
                ServletTimer timer = this.timerService.createTimer(sipServletResponse.getApplicationSession(), (long)delay, false, (Serializable)sipServletRequest);
                sipServletResponse.getApplicationSession().setAttribute("timer", (Object)timer);
            }
        }
    }

    protected void doRequest(SipServletRequest req) throws ServletException, IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.getClass().getSimpleName().equals("WebappClassLoader")) {
            logger.error((Object)("ClassLoader " + cl));
            throw new IllegalArgumentException("Bad Context Classloader : " + cl);
        }
        super.doRequest(req);
    }

    protected void doResponse(SipServletResponse resp) throws ServletException, IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.getClass().getSimpleName().equals("WebappClassLoader")) {
            logger.error((Object)("ClassLoader " + cl));
            throw new IllegalArgumentException("Bad Context Classloader : " + cl);
        }
        super.doResponse(resp);
    }

    protected void doInvite(SipServletRequest req) throws ServletException, IOException {
        String requestURIStringified = req.getRequestURI().toString();
        logger.info((Object)requestURIStringified);
        if (req.getTo().getURI().toString().contains("nonrecordrouteeinvite")) {
            req.createResponse(200).send();
            return;
        }
        if (req.getTo().getURI().toString().contains("recordrouteeinvite")) {
            ((SipServletRequestExt)req).createResponse(200, null, true).send();
            return;
        }
        if (!requestURIStringified.startsWith("sip:mss@sip-servlets.com;org.mobicents.servlet.sip.ApplicationSessionKey=%28") && !requestURIStringified.endsWith("%3Aorg.mobicents.servlet.sip.testsuite.ShootistApplication%29")) {
            req.createResponse(500, "SipURI.toString() does not escape charachters according to RFC2396.").send();
        }
        if (((SipURI)req.getFrom().getURI()).getUser().equalsIgnoreCase(ENCODE_URI)) {
            if (req.getApplicationSession().getAttribute(ENCODE_URI) != null) {
                req.createResponse(200).send();
            } else {
                req.createResponse(500, "received a request using the encodeURI mechanism but not the same sip application session").send();
            }
        } else {
            req.createResponse(500, "received a request using the encodeURI mechanism but not the same sip application session").send();
        }
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        ServletTimer timer = (ServletTimer)req.getApplicationSession().getAttribute("timer");
        if (timer != null) {
            timer.cancel();
        }
        req.createResponse(200).send();
    }

    public void servletInitialized(SipServletContextEvent ce) {
        String testErrorResponse;
        String dontSetRURI;
        String outboundInterface;
        String routeHeader;
        String authHeader;
        SipServletRequest sipServletRequest;
        String method;
        SipApplicationSession sipApplicationSession;
        SipFactory sipFactory;
        block38: {
            String toParam;
            String toTag;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (!cl.getClass().getSimpleName().equals("WebappClassLoader")) {
                logger.error((Object)("ClassLoader " + cl));
                throw new IllegalArgumentException("Bad Context Classloader : " + cl);
            }
            sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            sipApplicationSession = sipFactory.createApplicationSession();
            String testServletListener = ce.getServletContext().getInitParameter("testServletListener");
            if (testServletListener != null) {
                logger.error((Object)("servlet initialized " + this));
                this.sendMessage(sipApplicationSession, sipFactory, "testServletListener");
                return;
            }
            String testContentLength = ce.getServletContext().getInitParameter("testContentLength");
            if (testContentLength != null) {
                this.sendMessage(sipApplicationSession, sipFactory, null);
                return;
            }
            String userName = ce.getServletContext().getInitParameter("username");
            if (userName == null || userName.length() < 1) {
                userName = "BigGuy";
            }
            SipURI fromURI = sipFactory.createSipURI(userName, "here.com");
            SipURI toURI = null;
            if (ce.getServletContext().getInitParameter("urlType") != null && ce.getServletContext().getInitParameter("urlType").equalsIgnoreCase("tel")) {
                try {
                    toURI = sipFactory.createURI("tel:+358-555-1234567");
                }
                catch (ServletParseException e) {
                    logger.error((Object)"Impossible to create the tel URL", (Throwable)e);
                }
            } else {
                toURI = sipFactory.createSipURI("LittleGuy", "there.com");
            }
            if ((toTag = ce.getServletContext().getInitParameter("toTag")) != null) {
                toURI.setParameter("tag", toTag);
            }
            if ((toParam = ce.getServletContext().getInitParameter("toParam")) != null) {
                toURI.setParameter("toParam", toParam);
            }
            if ((method = ce.getServletContext().getInitParameter("method")) == null) {
                method = "INVITE";
            }
            sipServletRequest = null;
            if (ce.getServletContext().getInitParameter("useStringFactory") != null) {
                try {
                    sipServletRequest = sipFactory.createRequest(sipApplicationSession, method, "sip:LittleGuy@there.com", userName);
                    if (!sipServletRequest.getTo().toString().contains(userName)) {
                        logger.error((Object)"To Address and username should match!");
                        return;
                    }
                    break block38;
                }
                catch (ServletParseException e) {
                    logger.error((Object)("Impossible to create the " + method + " request "), (Throwable)e);
                    return;
                }
            }
            sipServletRequest = sipFactory.createRequest(sipApplicationSession, method, (URI)fromURI, (URI)toURI);
        }
        if ((authHeader = ce.getServletContext().getInitParameter("auth-header")) != null) {
            sipServletRequest.addHeader("Proxy-Authorization", authHeader);
            sipServletRequest.addHeader("Proxy-Authenticate", authHeader);
        }
        if ((routeHeader = ce.getServletContext().getInitParameter("route")) != null) {
            try {
                sipServletRequest.pushRoute((SipURI)sipFactory.createURI(routeHeader));
            }
            catch (ServletParseException e) {
                logger.error((Object)("Couldn't create Route Header from " + routeHeader));
                return;
            }
        }
        if ((outboundInterface = ce.getServletContext().getInitParameter("outboundInterface")) != null) {
            List outboundInterfaces = (List)this.getServletContext().getAttribute("javax.servlet.sip.outboundInterfaces");
            if (outboundInterfaces == null) {
                throw new NullPointerException("Outbound interfaces should not be null");
            }
            for (SipURI uri : outboundInterfaces) {
                logger.info((Object)("checking following outboudinterface" + uri + " against transport" + outboundInterface));
                if (!uri.toString().contains(outboundInterface)) continue;
                logger.info((Object)("using following outboudinterface" + uri));
                ((SipSessionExt)sipServletRequest.getSession()).setOutboundInterface(uri);
                break;
            }
        }
        if (!method.equalsIgnoreCase("REGISTER")) {
            Address addr = null;
            try {
                addr = sipServletRequest.getAddressHeader("Contact");
            }
            catch (ServletParseException e1) {
                // empty catch block
            }
            if (addr == null) {
                return;
            }
            String prack = ce.getServletContext().getInitParameter("prack");
            if (prack != null) {
                sipServletRequest.addHeader("Require", "100rel");
            }
            addr.setParameter("headerparam1", "headervalue1");
            addr.setParameter("param5", "ffff");
            addr.getURI().setParameter("uriparam", "urivalue");
        }
        if ((dontSetRURI = ce.getServletContext().getInitParameter("dontSetRURI")) == null) {
            SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
            if (ce.getServletContext().getInitParameter("encodeRequestURI") != null) {
                sipApplicationSession.encodeURI((URI)requestURI);
                sipApplicationSession.setAttribute(ENCODE_URI, (Object)"true");
            }
            sipServletRequest.setRequestURI((URI)requestURI);
        }
        if ((testErrorResponse = ce.getServletContext().getInitParameter(TEST_ERROR_RESPONSE)) != null) {
            sipServletRequest.getApplicationSession().setAttribute(TEST_ERROR_RESPONSE, (Object)"true");
        }
        if (sipServletRequest.getTo().getParameter("tag") != null) {
            logger.error((Object)"the ToTag should be empty, not sending the request");
            return;
        }
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the INVITE request", (Throwable)e);
        }
        if (ce.getServletContext().getInitParameter("cancel") != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                sipServletRequest.getApplicationSession().setAttribute(TEST_ERROR_RESPONSE, (Object)"true");
                sipServletRequest.createCancel().send();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public void timeout(ServletTimer timer) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.getClass().getSimpleName().equals("WebappClassLoader")) {
            logger.error((Object)("ClassLoader " + cl));
            throw new IllegalArgumentException("Bad Context Classloader : " + cl);
        }
        SipServletRequest sipServletRequest = (SipServletRequest)timer.getInfo();
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the BYE request", (Throwable)e);
        }
    }

    private void sendMessage(SipApplicationSession sipApplicationSession, SipFactory storedFactory, String content) {
        try {
            SipServletRequest sipServletRequest = storedFactory.createRequest(sipApplicationSession, "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = storedFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            if (content != null) {
                sipServletRequest.setContentLength(content.length());
                sipServletRequest.setContent((Object)content, CONTENT_TYPE);
            } else {
                sipServletRequest.setContentLength(0);
            }
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }

    public void sessionCreated(SipSessionEvent se) {
    }

    public void sessionDestroyed(SipSessionEvent se) {
    }

    public void sessionReadyToInvalidate(SipSessionEvent se) {
        if (se.getSession().getApplicationSession().getAttribute(TEST_ERROR_RESPONSE) != null) {
            this.sendMessage(this.sipFactory.createApplicationSession(), this.sipFactory, "sipSessionReadyToInvalidate", null);
        }
    }

    public void sessionCreated(SipApplicationSessionEvent ev) {
    }

    public void sessionDestroyed(SipApplicationSessionEvent ev) {
    }

    public void sessionExpired(SipApplicationSessionEvent ev) {
    }

    public void sessionReadyToInvalidate(SipApplicationSessionEvent ev) {
        if (ev.getApplicationSession().getAttribute(TEST_ERROR_RESPONSE) != null) {
            this.sendMessage(this.sipFactory.createApplicationSession(), this.sipFactory, "sipAppSessionReadyToInvalidate", null);
        }
    }

    private void sendMessage(SipApplicationSession sipApplicationSession, SipFactory storedFactory, String content, String transport) {
        try {
            SipServletRequest sipServletRequest = storedFactory.createRequest(sipApplicationSession, "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            sipServletRequest.addHeader("Ext", "Test 1, 2 ,3");
            SipURI sipUri = storedFactory.createSipURI("receiver", "127.0.0.1:5080");
            if (transport != null) {
                if (transport.equalsIgnoreCase("TCP")) {
                    sipUri = storedFactory.createSipURI("receiver", "127.0.0.1:5081");
                }
                sipUri.setTransportParam(transport);
            }
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(content.length());
            sipServletRequest.setContent((Object)content, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }
}

