/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class ShootistSipServlet
extends SipServlet
implements SipServletListener,
TimerListener {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static transient Logger logger = Logger.getLogger(ShootistSipServlet.class);
    @Resource
    TimerService timerService;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the shootist has been started");
        super.init(servletConfig);
    }

    protected void doProvisionalResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getHeader("require") != null) {
            SipServletRequest prack = resp.createPrack();
            SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
            prack.setRequestURI((URI)requestURI);
            prack.send();
        }
    }

    protected void doSuccessResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        logger.info((Object)("Got : " + sipServletResponse.getStatus() + " " + sipServletResponse.getMethod()));
        int status = sipServletResponse.getStatus();
        if (status == 200 && "INVITE".equalsIgnoreCase(sipServletResponse.getMethod())) {
            SipServletRequest ackRequest = sipServletResponse.createAck();
            ackRequest.send();
            if (sipServletResponse.getRequest().isInitial() && !(sipServletResponse.getFrom().getURI() instanceof TelURL) && !(sipServletResponse.getTo().getURI() instanceof TelURL) && (((SipURI)sipServletResponse.getFrom().getURI()).getUser().equals("reinvite") || ((SipURI)sipServletResponse.getTo().getURI()).getUser().equals("reinvite"))) {
                SipServletRequest request = sipServletResponse.getSession().createRequest("INVITE");
                request.send();
            } else {
                SipServletRequest sipServletRequest = sipServletResponse.getSession().createRequest("BYE");
                ServletTimer timer = this.timerService.createTimer(sipServletResponse.getApplicationSession(), 2000L, false, (Serializable)sipServletRequest);
                sipServletResponse.getApplicationSession().setAttribute("timer", (Object)timer);
            }
        }
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        ServletTimer timer = (ServletTimer)req.getApplicationSession().getAttribute("timer");
        timer.cancel();
        req.createResponse(200).send();
    }

    public void servletInitialized(SipServletContextEvent ce) {
        SipServletRequest sipServletRequest;
        SipApplicationSession sipApplicationSession;
        SipFactory sipFactory;
        block21: {
            String toParam;
            String toTag;
            sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            sipApplicationSession = sipFactory.createApplicationSession();
            String testServletListener = ce.getServletContext().getInitParameter("testServletListener");
            if (testServletListener != null) {
                logger.error((Object)("servlet initialized " + this));
                this.sendMessage(sipApplicationSession, sipFactory, "testServletListener");
                return;
            }
            String testContentLength = ce.getServletContext().getInitParameter("testContentLength");
            if (testContentLength != null) {
                this.sendMessage(sipApplicationSession, sipFactory, null);
                return;
            }
            String userName = ce.getServletContext().getInitParameter("username");
            if (userName == null || userName.length() < 1) {
                userName = "BigGuy";
            }
            SipURI fromURI = sipFactory.createSipURI(userName, "here.com");
            SipURI toURI = null;
            if (ce.getServletContext().getInitParameter("urlType") != null && ce.getServletContext().getInitParameter("urlType").equalsIgnoreCase("tel")) {
                try {
                    toURI = sipFactory.createURI("tel:+358-555-1234567");
                }
                catch (ServletParseException e) {
                    logger.error((Object)"Impossible to create the tel URL", (Throwable)e);
                }
            } else {
                toURI = sipFactory.createSipURI("LittleGuy", "there.com");
            }
            if ((toTag = ce.getServletContext().getInitParameter("toTag")) != null) {
                toURI.setParameter("tag", toTag);
            }
            if ((toParam = ce.getServletContext().getInitParameter("toParam")) != null) {
                toURI.setParameter("toParam", toParam);
            }
            sipServletRequest = null;
            if (ce.getServletContext().getInitParameter("useStringFactory") != null) {
                try {
                    sipServletRequest = sipFactory.createRequest(sipApplicationSession, "INVITE", "sip:LittleGuy@there.com", userName);
                    if (!sipServletRequest.getTo().toString().contains(userName)) {
                        logger.error((Object)"To Address and username should match!");
                        return;
                    }
                    break block21;
                }
                catch (ServletParseException e) {
                    logger.error((Object)"Impossible to create the INVITE request ", (Throwable)e);
                    return;
                }
            }
            sipServletRequest = sipFactory.createRequest(sipApplicationSession, "INVITE", (URI)fromURI, (URI)toURI);
        }
        Address addr = null;
        try {
            addr = sipServletRequest.getAddressHeader("Contact");
        }
        catch (ServletParseException e1) {
            // empty catch block
        }
        if (addr == null) {
            return;
        }
        String prack = ce.getServletContext().getInitParameter("prack");
        if (prack != null) {
            sipServletRequest.addHeader("Require", "100rel");
        }
        addr.setParameter("headerparam1", "headervalue1");
        addr.setParameter("param5", "ffff");
        addr.getURI().setParameter("uriparam", "urivalue");
        SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
        if (ce.getServletContext().getInitParameter("encodeRequestURI") != null) {
            sipApplicationSession.encodeURI((URI)requestURI);
        }
        sipServletRequest.setRequestURI((URI)requestURI);
        if (sipServletRequest.getTo().getParameter("tag") != null) {
            logger.error((Object)"the ToTag should be empty, not sending the request");
            return;
        }
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the INVITE request", (Throwable)e);
        }
    }

    public void timeout(ServletTimer timer) {
        SipServletRequest sipServletRequest = (SipServletRequest)timer.getInfo();
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the BYE request", (Throwable)e);
        }
    }

    private void sendMessage(SipApplicationSession sipApplicationSession, SipFactory storedFactory, String content) {
        try {
            SipServletRequest sipServletRequest = storedFactory.createRequest(sipApplicationSession, "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = storedFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            if (content != null) {
                sipServletRequest.setContentLength(content.length());
                sipServletRequest.setContent((Object)content, CONTENT_TYPE);
            } else {
                sipServletRequest.setContentLength(0);
            }
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }
}

