/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShootistSipServlet
extends SipServlet
implements SipServletListener,
TimerListener {
    private static Log logger = LogFactory.getLog(ShootistSipServlet.class);
    @Resource
    TimerService timerService;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the shootist has been started");
        super.init(servletConfig);
    }

    protected void doSuccessResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        logger.info((Object)("Got : " + sipServletResponse.getStatus() + " " + sipServletResponse.getMethod()));
        int status = sipServletResponse.getStatus();
        if (status == 200 && "INVITE".equalsIgnoreCase(sipServletResponse.getMethod())) {
            SipServletRequest ackRequest = sipServletResponse.createAck();
            ackRequest.send();
            SipServletRequest sipServletRequest = sipServletResponse.getSession().createRequest("BYE");
            ServletTimer timer = this.timerService.createTimer(sipServletResponse.getApplicationSession(), 2000L, false, (Serializable)sipServletRequest);
            sipServletResponse.getApplicationSession().setAttribute("timer", (Object)timer);
        }
    }

    protected void doBye(SipServletRequest req) throws ServletException, IOException {
        ServletTimer timer = (ServletTimer)req.getApplicationSession().getAttribute("timer");
        timer.cancel();
        req.createResponse(200).send();
    }

    public void servletInitialized(SipServletContextEvent ce) {
        SipFactory sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        SipApplicationSession sipApplicationSession = sipFactory.createApplicationSession();
        SipURI fromURI = sipFactory.createSipURI("BigGuy", "here.com");
        SipURI toURI = null;
        if (ce.getServletContext().getInitParameter("urlType") != null && ce.getServletContext().getInitParameter("urlType").equalsIgnoreCase("tel")) {
            try {
                toURI = sipFactory.createURI("tel:+358-555-1234567");
            }
            catch (ServletParseException e) {
                logger.error((Object)"Impossible to create the tel URL", (Throwable)e);
            }
        } else {
            toURI = sipFactory.createSipURI("LittleGuy", "there.com");
        }
        SipServletRequest sipServletRequest = sipFactory.createRequest(sipApplicationSession, "INVITE", (URI)fromURI, (URI)toURI);
        SipURI requestURI = sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
        if (ce.getServletContext().getInitParameter("encodeRequestURI") != null) {
            sipApplicationSession.encodeURI((URI)requestURI);
        }
        sipServletRequest.setRequestURI((URI)requestURI);
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the INVITE request", (Throwable)e);
        }
    }

    public void timeout(ServletTimer timer) {
        SipServletRequest sipServletRequest = (SipServletRequest)timer.getInfo();
        try {
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected exception while sending the BYE request", (Throwable)e);
        }
    }
}

