/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class SessionStateUASSipServlet
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(SessionStateUASSipServlet.class);
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String SEND_1XX_2XX = "send1xx_2xx";
    private static final String SEND_1XX_4XX = "send1xx_4xx";
    private static final String SEND_4XX = "send4xx";
    private static final String SEND_2XX = "send2xx";
    private static final String TEST_TIMEOUT = "test_timeout";
    private static final String STX_408_RECEIVED = "408 received on STX";
    private static final int TIMEOUT = 10000;
    private SipFactory sipFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        logger.info((Object)"the session state UAS test sip servlet has been started");
        try {
            Properties jndiProps = new Properties();
            InitialContext initCtx = new InitialContext(jndiProps);
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.sipFactory = (SipFactory)envCtx.lookup("sip/org.mobicents.servlet.sip.testsuite.SessionStateUASApplication/SipFactory");
            logger.info((Object)("Sip Factory ref from JNDI : " + this.sipFactory));
        }
        catch (NamingException e) {
            throw new ServletException("Uh oh -- JNDI problem !", (Throwable)e);
        }
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request: " + request.getMethod()));
        String message = (String)request.getContent();
        if (message != null && message.length() > 0) {
            if (TEST_TIMEOUT.equals(message)) {
                SipServletResponse response = request.createResponse(400);
                response.send();
                return;
            }
            this.sendMessage(request.getSession().getState().toString());
            if (SEND_1XX_2XX.equals(message)) {
                SipServletResponse ringingResponse = request.createResponse(180);
                ringingResponse.send();
                this.sendMessage(request.getSession().getState().toString());
                SipServletResponse okResponse = request.createResponse(200);
                okResponse.send();
                this.sendMessage(request.getSession().getState().toString());
            } else if (SEND_1XX_4XX.equals(message)) {
                request.getSession().setInvalidateWhenReady(false);
                SipServletResponse ringingResponse = request.createResponse(180);
                ringingResponse.send();
                this.sendMessage(request.getSession().getState().toString());
                SipServletResponse forbiddenResponse = request.createResponse(403);
                forbiddenResponse.send();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"unexpected exception while putting the thread to sleep", (Throwable)e);
                }
                if (request.getSession().isValid()) {
                    logger.info((Object)"the session have not been invalidated by the container since the invalidateWhenReady flag is false");
                    this.sendMessage(request.getSession().getState().toString());
                    request.getSession().invalidate();
                } else {
                    logger.error((Object)"the session should not have been invalidated by the container since the invalidateWhenReady flag is false");
                }
            } else if (SEND_2XX.equals(message)) {
                SipServletResponse okResponse = request.createResponse(200);
                okResponse.send();
                this.sendMessage(request.getSession().getState().toString());
            } else if (SEND_4XX.equals(message)) {
                SipServletResponse forbiddenResponse = request.createResponse(403);
                forbiddenResponse.send();
                if (request.getSession().isValid()) {
                    this.sendMessage(request.getSession().getState().toString());
                } else {
                    this.sendMessage(SipSession.State.TERMINATED.toString());
                }
            }
        }
    }

    protected void doRefer(SipServletRequest request) throws ServletException, IOException {
        SipServletResponse finalResponse = request.createResponse(487);
        finalResponse.send();
        this.sendMessage(request.getSession().getState().toString());
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
        this.sendMessage(request.getSession().getState().toString());
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
        if (resp.getStatus() == 408 && resp.getMethod().equalsIgnoreCase("INVITE")) {
            this.sendMessage(STX_408_RECEIVED);
        }
    }

    public void sendMessage(String messageContent) {
        try {
            SipApplicationSession sipApplicationSession = this.sipFactory.createApplicationSession();
            SipServletRequest sipServletRequest = this.sipFactory.createRequest(sipApplicationSession, "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = this.sipFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(messageContent.length());
            sipServletRequest.setContent((Object)messageContent, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }
}

