/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionStateUASSipServlet
extends SipServlet {
    private static Log logger = LogFactory.getLog(SessionStateUASSipServlet.class);
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String SEND_1XX_2XX = "send1xx_2xx";
    private static final String SEND_1XX_4XX = "send1xx_4xx";
    private static final String SEND_4XX = "send4xx";
    private static final String SEND_2XX = "send2xx";
    private SipFactory sipFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        logger.info((Object)"the session state UAS test sip servlet has been started");
        try {
            Properties jndiProps = new Properties();
            InitialContext initCtx = new InitialContext(jndiProps);
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            this.sipFactory = (SipFactory)envCtx.lookup("sip/org.mobicents.servlet.sip.testsuite.SessionStateUASApplication/SipFactory");
            logger.info((Object)("Sip Factory ref from JNDI : " + this.sipFactory));
        }
        catch (NamingException e) {
            throw new ServletException("Uh oh -- JNDI problem !", (Throwable)e);
        }
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got request: " + request.getMethod()));
        this.sendMessage(request.getSession().getState().toString());
        String message = (String)request.getContent();
        if (message != null && message.length() > 0) {
            if (SEND_1XX_2XX.equals(message)) {
                SipServletResponse ringingResponse = request.createResponse(180);
                ringingResponse.send();
                this.sendMessage(request.getSession().getState().toString());
                SipServletResponse okResponse = request.createResponse(200);
                okResponse.send();
                this.sendMessage(request.getSession().getState().toString());
            } else if (SEND_1XX_4XX.equals(message)) {
                SipServletResponse ringingResponse = request.createResponse(180);
                ringingResponse.send();
                this.sendMessage(request.getSession().getState().toString());
                SipServletResponse forbiddenResponse = request.createResponse(403);
                forbiddenResponse.send();
                this.sendMessage(request.getSession().getState().toString());
            } else if (SEND_2XX.equals(message)) {
                SipServletResponse okResponse = request.createResponse(200);
                okResponse.send();
                this.sendMessage(request.getSession().getState().toString());
            } else if (SEND_4XX.equals(message)) {
                SipServletResponse forbiddenResponse = request.createResponse(403);
                forbiddenResponse.send();
                if (request.getSession().isValid()) {
                    this.sendMessage(request.getSession().getState().toString());
                } else {
                    this.sendMessage(SipSession.State.TERMINATED.toString());
                }
            }
        }
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
        this.sendMessage(request.getSession().getState().toString());
    }

    public void sendMessage(String messageContent) {
        try {
            SipApplicationSession sipApplicationSession = this.sipFactory.createApplicationSession();
            SipServletRequest sipServletRequest = this.sipFactory.createRequest(sipApplicationSession, "MESSAGE", "sip:sender@sip-servlets.com", "sip:receiver@sip-servlets.com");
            SipURI sipUri = this.sipFactory.createSipURI("receiver", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(messageContent.length());
            sipServletRequest.setContent((Object)messageContent, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (ServletParseException e) {
            logger.error((Object)"Exception occured while parsing the addresses", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }
}

