/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;

public class PublishSipServlet
extends SipServlet
implements SipServletListener,
TimerListener {
    private static final String SUBSCRIBER_SESSIONS = "subscriberSessions";
    private static final String PUBLISH_SIP_ETAGS = "publishSIP-ETag_s";
    private static transient Logger logger = Logger.getLogger(PublishSipServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the publish sip servlet has been started");
        super.init(servletConfig);
        this.getServletContext().setAttribute(SUBSCRIBER_SESSIONS, new HashMap());
        this.getServletContext().setAttribute(PUBLISH_SIP_ETAGS, new HashMap());
    }

    protected void doSuccessResponse(SipServletResponse resp) throws ServletException, IOException {
        if ("PUBLISH".equals(resp.getMethod()) && !"Modify".equals(this.getServletContext().getAttribute("publishStateSent"))) {
            SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
            SipApplicationSession sipApplicationSession = sipFactory.createApplicationSession();
            SipURI fromURI = sipFactory.createSipURI("presentity", "example.com");
            SipURI toURI = sipFactory.createSipURI("presentity", "example.com");
            SipServletRequest sipServletRequest = sipFactory.createRequest(sipApplicationSession, "PUBLISH", (URI)fromURI, (URI)toURI);
            SipURI requestURI = sipFactory.createSipURI("presentity", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)requestURI);
            sipServletRequest.setExpires(3600);
            sipServletRequest.setHeader("Event", "presence");
            sipServletRequest.setHeader("SIP-If-Match", resp.getHeader("Sip-ETag"));
            try {
                if (this.getServletContext().getAttribute("publishStateSent") != null) {
                    sipServletRequest.setContent((Object)"Modify", "application/pidf+xml");
                    this.getServletContext().setAttribute("publishStateSent", (Object)"Modify");
                } else {
                    this.getServletContext().setAttribute("publishStateSent", (Object)"Refresh");
                }
                sipServletRequest.send();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    protected void doSubscribe(SipServletRequest request) throws ServletException, IOException {
        ServletTimer servletTimer = (ServletTimer)this.getServletContext().getAttribute("servletTimer");
        servletTimer.cancel();
        logger.info((Object)("Got Subscribe: " + request.getMethod()));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.addHeader("Expires", request.getHeader("Expires"));
        sipServletResponse.addHeader("Event", request.getHeader("Event"));
        sipServletResponse.send();
        Map subscriberSessions = (Map)this.getServletContext().getAttribute(SUBSCRIBER_SESSIONS);
        subscriberSessions.put(request.getRequestURI(), request.getSession());
        SipServletRequest notifyRequest = request.getSession().createRequest("NOTIFY");
        notifyRequest.addHeader("Subscription-State", "active");
        notifyRequest.addHeader("Event", "presence");
        notifyRequest.send();
    }

    protected void doPublish(SipServletRequest request) throws ServletException, IOException {
        Map subscriberSessions = (Map)this.getServletContext().getAttribute(SUBSCRIBER_SESSIONS);
        Map sipETags = (Map)this.getServletContext().getAttribute(PUBLISH_SIP_ETAGS);
        SipSession subscriberSession = (SipSession)subscriberSessions.get(request.getRequestURI());
        boolean sipIfMatchFound = true;
        String sipIfMatch = request.getHeader("SIP-If-Match");
        if (sipIfMatch != null && !sipIfMatch.equalsIgnoreCase((String)sipETags.get(request.getRequestURI()))) {
            sipIfMatchFound = false;
        }
        if (subscriberSession != null && sipIfMatchFound) {
            String content;
            SipServletResponse sipServletResponse = request.createResponse(200);
            sipServletResponse.addHeader("Expires", request.getHeader("Expires"));
            String sipETag = Integer.toString((int)(Math.random() * 1.0E7));
            sipETags.put(request.getRequestURI(), sipETag);
            sipServletResponse.addHeader("SIP-ETag", sipETag);
            sipServletResponse.send();
            if (request.getRawContent() != null && (content = new String(request.getRawContent())).length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Content : " + content));
                }
                SipServletRequest notifyRequest = subscriberSession.createRequest("NOTIFY");
                notifyRequest.addHeader("Subscription-State", "active");
                notifyRequest.addHeader("Event", "presence");
                notifyRequest.send();
            }
        } else {
            SipServletResponse sipServletResponse = request.createResponse(500);
            sipServletResponse.send();
        }
    }

    public void servletInitialized(SipServletContextEvent ce) {
        SipFactory sipFactory = (SipFactory)ce.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        SipApplicationSession sipApplicationSession = sipFactory.createApplicationSession();
        TimerService timerService = (TimerService)ce.getServletContext().getAttribute("javax.servlet.sip.TimerService");
        sipApplicationSession.setAttribute("sipFactory", (Object)sipFactory);
        ServletTimer servletTimer = timerService.createTimer(sipApplicationSession, 2000L, false, null);
        ce.getServletContext().setAttribute("servletTimer", (Object)servletTimer);
    }

    public void timeout(ServletTimer timer) {
        SipFactory sipFactory = (SipFactory)timer.getApplicationSession().getAttribute("sipFactory");
        SipURI fromURI = sipFactory.createSipURI("presentity", "example.com");
        SipURI toURI = sipFactory.createSipURI("presentity", "example.com");
        SipServletRequest sipServletRequest = sipFactory.createRequest(timer.getApplicationSession(), "PUBLISH", (URI)fromURI, (URI)toURI);
        SipURI requestURI = sipFactory.createSipURI("presentity", "127.0.0.1:5080");
        sipServletRequest.setRequestURI((URI)requestURI);
        sipServletRequest.setExpires(3600);
        sipServletRequest.setHeader("Event", "presence");
        try {
            sipServletRequest.setContent((Object)"Initial", "application/pidf+xml");
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }
}

