/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.testsuite;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotifierSipServlet
extends SipServlet
implements SipSessionListener {
    private static Log logger = LogFactory.getLog(NotifierSipServlet.class);
    private static final String CONTENT_TYPE = "text/plain;charset=UTF-8";
    private static final String SIP_SESSION_READY_TO_BE_INVALIDATED = "sipSessionReadyToBeInvalidated";
    @Resource
    SipFactory sipFactory;

    public void init(ServletConfig servletConfig) throws ServletException {
        logger.info((Object)"the notifier sip servlet has been started");
        super.init(servletConfig);
    }

    protected void doInvite(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("from : " + request.getFrom()));
        logger.info((Object)("Got request: " + request.getMethod()));
        SipServletResponse sipServletResponse = request.createResponse(180);
        sipServletResponse.send();
        request.getSession().setAttribute("inviteReceived", (Object)"true");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
    }

    protected void doErrorResponse(SipServletResponse resp) throws ServletException, IOException {
        logger.info((Object)("Got response: " + resp));
        resp.getSession().createRequest("BYE").send();
    }

    protected void doBye(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got BYE request: " + request));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.send();
    }

    protected void doSubscribe(SipServletRequest request) throws ServletException, IOException {
        logger.info((Object)("Got Subscribe: " + request.getMethod()));
        SipServletResponse sipServletResponse = request.createResponse(200);
        sipServletResponse.addHeader("Expires", request.getHeader("Expires"));
        sipServletResponse.addHeader("Event", request.getHeader("Event"));
        sipServletResponse.send();
        SipServletRequest notifyRequest = request.getSession().createRequest("NOTIFY");
        if (request.isInitial() || request.getSession().getAttribute("inviteReceived") != null) {
            request.getSession().removeAttribute("inviteReceived");
            notifyRequest.addHeader("Subscription-State", "pending");
            notifyRequest.addHeader("Event", "reg");
            notifyRequest.send();
            notifyRequest = request.getSession().createRequest("NOTIFY");
        }
        if (request.getHeader("Expires").trim().equals("0")) {
            notifyRequest.addHeader("Subscription-State", "terminated");
        } else {
            notifyRequest.addHeader("Subscription-State", "active");
        }
        notifyRequest.addHeader("Event", "reg");
        notifyRequest.send();
    }

    public void sessionCreated(SipSessionEvent se) {
    }

    public void sessionDestroyed(SipSessionEvent se) {
    }

    public void sessionReadyToInvalidate(SipSessionEvent se) {
        logger.info((Object)("sip session expired " + se.getSession()));
        try {
            SipServletRequest sipServletRequest = this.sipFactory.createRequest(this.sipFactory.createApplicationSession(), "MESSAGE", se.getSession().getLocalParty(), se.getSession().getRemoteParty());
            SipURI sipUri = this.sipFactory.createSipURI("LittleGuy", "127.0.0.1:5080");
            sipServletRequest.setRequestURI((URI)sipUri);
            sipServletRequest.setContentLength(SIP_SESSION_READY_TO_BE_INVALIDATED.length());
            sipServletRequest.setContent((Object)SIP_SESSION_READY_TO_BE_INVALIDATED, CONTENT_TYPE);
            sipServletRequest.send();
        }
        catch (IOException e) {
            logger.error((Object)"Exception occured while sending the request", (Throwable)e);
        }
    }
}

